package com.ericsson.cms.epgmgmt.client.partner;


import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.UIExecutionLog;
import com.ericsson.cms.epgmgmt.client.model.UIExecutionStep;
import com.ericsson.cms.epgmgmt.client.model.util.TableUtils;
import com.ericsson.cms.epgmgmt.client.utils.DefaultAsyncCallback;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;

public class ExecutionStepPopup extends PopupPanel{

    private final EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class);
    public ExecutionStepPopup(UIExecutionLog executionLog){
        super(true); 
        VerticalPanel mainPanel = new VerticalPanel();
        initCloseButton(mainPanel);        
        Table<Long, UIExecutionStep> table = new Table<Long, UIExecutionStep>(new ExecutionStepDataProvider(executionLog));
        table.initialize(new DefaultAsyncCallback<Void>(null));
        table.refresh();
        ScrollContainer panel = new ScrollContainer();
        panel.setWidget(table);
        panel.setSize("600px", "280px");
        mainPanel.add(panel); 
        center();
        setWidget(mainPanel);
        setSize("600px", "300px");
        int left = (Window.getClientWidth() - 600) / 2;
        int top = (Window.getClientHeight() - 300) / 2;
        setPopupPosition(left, top);
    }
    private void initCloseButton(VerticalPanel vp) {
        HorizontalContainer hc = new HorizontalContainer();
        hc.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        hc.add(createCloseButton());
        hc.setWidth("100%");
        hc.setHeight("20px");
        vp.add(hc);
    }
    private ImageWidget createCloseButton() {
        ImageWidget cb = new ImageWidget();
        ClickHandler handler = new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                ExecutionStepPopup.this.hide();
            }
        };
        cb.setUrl("cms_epgmgmt_ui/images/delete.gif");
        cb.setHeight("18px");
        cb.setWidth("18px");
        cb.addClickHandler(handler);
        cb.addStyleName("epg-exportsetting-verticalpanel-widget");
        return cb;
    }
    class ExecutionStepDataProvider implements DataProvider<Long, UIExecutionStep>{
        
        private static final String STATUS = "status";
        private static final String EXECUTION_TIME = "executionTime";
        private static final String END_DATE = "endDate";
        private static final String START_DATE = "startDate";
        private static final String STEP_NAME = "name";
        private final List<Column<?, UIExecutionStep>> columns;
        private final UIExecutionLog executionLog;
        public ExecutionStepDataProvider(UIExecutionLog executionLog){
            this.executionLog = executionLog;
            columns= new ArrayList<Column<?, UIExecutionStep>>();
            columns.add(TableUtils.<UIExecutionStep>createTextColumn(STEP_NAME, constants.jobStepLabel(), STEP_NAME));
            columns.add(TableUtils.<UIExecutionStep>createDateColumn(START_DATE, constants.jobStartDateLabel(), START_DATE,constants.activityLogTimeFormat()));
            columns.add(TableUtils.<UIExecutionStep>createDateColumn(END_DATE, constants.jobEndDateLabel(), END_DATE,constants.activityLogTimeFormat()));
            columns.add(TableUtils.<UIExecutionStep>createTextColumn(EXECUTION_TIME, constants.jobExecutionTimeLable(), EXECUTION_TIME));
            columns.add(new ExecutionStatusColumn(STATUS, constants.jobStatusLabel()));            
        }
        @Override
        public void initialize(AsyncCallback<Void> callback) {
            callback.onSuccess(null);
        }

        @Override
        public List<Column<?, UIExecutionStep>> getColumns() {
            return columns;
        }

        @Override
        public void getRecords(AsyncCallback<List<UIExecutionStep>> callback) {
            callback.onSuccess(executionLog.getSteps());
        }

        @Override
        public void getRecord(Long key, AsyncCallback<UIExecutionStep> callback) {
            
        }

        @Override
        public boolean isRecordCountEnabled() {
            return true;
        }

        @Override
        public boolean isCheckboxEnabled() {
            return false;
        }
    }
}
