package com.ericsson.cms.epgmgmt.client.partner;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.EPGFormContainer;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentMessages;
import com.ericsson.cms.epgmgmt.client.model.PartnerConstantUtils;
import com.ericsson.cms.epgmgmt.client.model.UIConstants;
import com.ericsson.cms.epgmgmt.client.model.UIPartner;
import com.ericsson.cms.epgmgmt.client.model.enumeration.PartnerType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasHorizontalAlignment.HorizontalAlignmentConstant;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

public class PartnerBasicSettingForm extends EPGFormContainer {

    private UIPartner model;
    private final EPGComponentConstants constants = GWT.create(EPGComponentConstants.class);
    private final EPGComponentMessages constantsMsg = (EPGComponentMessages) GWT.create(EPGComponentMessages.class);
    private final TextBoxWidget nameValueWidget = new TextBoxWidget();
    private final TextBoxWidget contactValueWidget = new TextBoxWidget();
    private final TextBoxWidget emailValueWidget = new TextBoxWidget();
    private final CheckBoxWidget isEnabled = new CheckBoxWidget();
    private final CheckBoxWidget isAlert = new CheckBoxWidget();

    public PartnerBasicSettingForm(UIPartner model) {
        this(HorizontalContainer.ALIGN_LEFT, model);
    }

    public PartnerBasicSettingForm(HorizontalAlignmentConstant buttonPanelHAlign, UIPartner model) {
        super(buttonPanelHAlign);
        this.model = model;
        initForm();
        bindEventHandler();
        loadModel(model);
    }

    private void bindEventHandler() {
        isAlert.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                if (isAlert.getValue() && !Window.confirm(constants.emailTips())) {
                    isAlert.setValue(false);
                }
            }
        });
    }

    private void initForm() {
        nameValueWidget.setMaxLength(UIConstants.NAME_MAX_LENGTH);
        contactValueWidget.setMaxLength(UIConstants.NAME_MAX_LENGTH);
        emailValueWidget.setMaxLength(UIConstants.EMAIL_MAX_LENGTH);

        addRow(constants.enable(), isEnabled);
        addRow((model.getPartnerType() == PartnerType.Provider) ? constants.providerName() : constants.receiverName(), nameValueWidget, true);
        addRow(constants.partnerContact(), contactValueWidget);
        addRow(constants.partnerrEmail(), emailValueWidget);
        addRow(constants.emailAlert(), isAlert);
    }

    /**
     * Set the model of the widget and load the data.
     *
     * @param model
     */
    public void loadModel(UIPartner model) {
        this.model = model;
        isEnabled.setValue(model.isActive());
        nameValueWidget.setValue(model.getName());
        contactValueWidget.setValue(model.getContact());
        emailValueWidget.setValue(model.getEmail());
        isAlert.setValue(model.isAlert());
    }

    public UIPartner populateModel() {
        model.setActive(isEnabled.getValue());
        model.setName(nameValueWidget.getValue());
        model.setContact(contactValueWidget.getValue());
        model.setEmail(emailValueWidget.getValue());
        model.setAlert(isAlert.getValue());
        return model;
    }

    public List<String> validateField() {
        List<String> validationMessages = new ArrayList<String>();
        if ((nameValueWidget.getText() == null) || nameValueWidget.getText().isEmpty()) {
            validationMessages.add(constantsMsg.requiredPartnerName(PartnerConstantUtils.getPartnerType(model)));
        }
        if (isAlert.getValue()
                && ((emailValueWidget.getText() == null) || emailValueWidget.getText().isEmpty() || !emailValueWidget
                        .getText().contains("@"))) {
            validationMessages.add(constantsMsg.requiredEmailForAlert());
        }
        return validationMessages;
    }

    public CheckBoxWidget getIsEnabled() {
        return isEnabled;
    }

    /**
     * Only set the model to the widget, if reloading data is needed, use
     * {@link PartnerBasicSettingForm#loadModel(UIPartner)}.
     *
     * @param model
     */
    public void setPartner(UIPartner model) {
        this.model = model;
    }
}
