package com.ericsson.cms.epgmgmt.client.partner;

import java.util.List;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.UIPartner;
import com.ericsson.cms.epgmgmt.client.utils.MessageAreaUtils;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class PartnerBasicTab extends AbstractPartnerTab {

    private final VerticalContainer mainPanel;
    private RoundedDisclosureContainer mainDisclosurePanel;
    private PartnerBasicSettingForm basicForm;
    private UIPartner partner;
    private final EPGComponentConstants constants = GWT.create(EPGComponentConstants.class);
    private ButtonWidget saveButton;
    private ButtonWidget cancelButton;
    private ScheduledCommand resizePanel;
    private final AbstractPartnerTabContainer parent;
    private static final String STYLE_DISCLOSURE_CONTAINER = "epg-basicTab-disclosureContainer";
    private final LabelWidget titleWidget = new LabelWidget();

    public PartnerBasicTab(UIPartner partner, AbstractPartnerTabContainer parent) {
        NeptuneApplication.getApplication().getSecurity();
        this.partner = partner;
        this.parent = parent;
        mainPanel = new VerticalContainer();
        mainPanel.setSpacing(10);
        mainPanel.setWidth("100%");
        initForm();
    }

    private void initForm() {
        basicForm = new PartnerBasicSettingForm(partner);
        mainPanel.add(basicForm);
        mainPanel.add(getButtonContainer());

        refreshTitle();
        mainDisclosurePanel = new RoundedDisclosureContainer(titleWidget, true);
        mainDisclosurePanel.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        mainDisclosurePanel.setContent(mainPanel);
        initWidget(mainDisclosurePanel);
    }

    private HorizontalContainer getButtonContainer() {
        HorizontalContainer buttonContainer = new HorizontalContainer();
        saveButton = createSaveButton();
        cancelButton = createCancelButton();
        buttonContainer.add(saveButton);
        buttonContainer.add(cancelButton);
        return buttonContainer;
    }

    private void refreshTitle() {
        String partnerDetails = constants.basicTab();
        String parterActiveInfo = partner.isActive() ? "" : ", " + constants.buttonLabelDisable();
        String title = partnerDetails + " (" + partner.getShortName() + parterActiveInfo + ")";
        titleWidget.setText(title);
    }

    private ButtonWidget createSaveButton() {
        ButtonWidget button = new ButtonWidget(constants.buttonLabelSave(), new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                parent.clear();
                List<String> validationMsg = validate();
                if (validationMsg.size() > 0) {
                    MessageAreaUtils.displayErrorMessages("", validationMsg, "", messageArea);
                    return;
                }
                parent.onCommit();
                // after saved, colse the basc form
                mainDisclosurePanel.setOpen(false);
            }
        });
        button.addStyleDependentName("commit-button");
        return button;
    }

    private ButtonWidget createCancelButton() {
        ButtonWidget button = new ButtonWidget(constants.buttonLabelCancel(), new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                basicForm.loadModel(partner);
                setOpen(false);
            }
        });
        button.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
        return button;
    }

    public void setOpen(boolean isOpen) {
        mainDisclosurePanel.setOpen(isOpen);
    }

    public void setPartner(UIPartner partner) {
        this.partner = partner;
        refreshTitle();
        basicForm.loadModel(partner);
    }

    public UIPartner populatePartner() {
        return basicForm.populateModel();
    }

    @Override
    public void updateScrollPanelSize() {
        // Scheduler.get().scheduleDeferred(resizePanel);
    }

    public ButtonWidget getSaveButton() {
        return saveButton;
    }

    @Override
    public String getName() {
        return "Basic";
    }

    @Override
    public void setSelected(boolean selected) {
        if (!selected) {
            return;
        }

        messageArea.reset();
        setOpen(false);
        refreshTitle();
    }

    @Override
    public String getDisplayName() {
        return constants.basicTab();
    }

    @Override
    public List<String> validate() {
        return basicForm.validateField();
    }

    @Override
    public void reload() {
        basicForm.clearAllValidationErrors();
        basicForm.loadModel(partner);
        refreshTitle();
        setOpen(false);
    }

    public void saveSuccess() {
        partner = parent.getPartner();
        refreshTitle();
    }
}
