package com.ericsson.cms.epgmgmt.client.partner;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.Permissions;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.UIPartner;
import com.ericsson.cms.epgmgmt.client.model.enumeration.JobType;
import com.ericsson.cms.epgmgmt.client.model.enumeration.PartnerType;
import com.ericsson.cms.epgmgmt.client.task.AbstractTaskTab;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class PartnerUpdateTab  extends AbstractPartnerTab {
    private final EPGComponentConstants constants = GWT.create(EPGComponentConstants.class);
    private PartnerBasicTab basicTab;
    private AbstractTaskTab taskTab;
    private ExecutionLogTab logTab;
    private UIPartner uiPartner;
    private AbstractPartnerTabContainer parent;
    private TabContainer tabContainer;
    private static final String TAB_CONTAINER_STYLE = "epg-tabContainer";
    private static final int SPACE = 10;
    
    
    public PartnerUpdateTab(AbstractPartnerTabContainer parent, UIPartner uiPartner) {
        this.uiPartner = uiPartner;
        this.parent = parent;
    }
    
    public void init() {
        VerticalContainer taskVertical = new VerticalContainer();
        taskVertical.setSpacing(SPACE); 
        taskVertical.setWidth(A_HUNDRED_PERCENT);
        taskVertical.add(createBasicDisclosure());
        taskVertical.add(createTaskDetailDisclosure());
        
        super.initWidget(taskVertical, createDeleteButton());
    }

    private PartnerBasicTab createBasicDisclosure() {
        basicTab = new PartnerBasicTab(uiPartner, parent);
        basicTab.setMessageArea(messageArea);
        basicTab.setOpen(false);
        return basicTab;
    }
    
    private TabContainer createTaskDetailDisclosure() {
        tabContainer = new TabContainer();
        tabContainer.setStyleName(TAB_CONTAINER_STYLE);
        tabContainer.setWidth(A_HUNDRED_PERCENT);
        addTabs();
        return tabContainer;
    }
    
    private ButtonWidget createDeleteButton() {
        ButtonWidget deleteButton = new ButtonWidget(constants.buttonLabelDelete(), new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                parent.onDelete();
            }
        });
        deleteButton.addStyleDependentName("dataloss-button");
        deleteButton.setVisible(ClientAuthorizationManager.isAuthorized(Permissions.EPG_DELETE));
        
        return deleteButton;
    }

    @Override
    public String getName() {
        return "Update Partner";
    }

    @Override
    public String getDisplayName() {
        return (uiPartner.getPartnerType() == PartnerType.Provider) ? constants.providerDetails() : constants.publisherDetails();
    }

    @Override
    public void setSelected(boolean selected) {
        if (!selected) {
            return;
        }

        messageArea.reset();

        basicTab.setSelected(selected);
        taskTab.setSelected(selected);
        logTab.setSelected(selected);
    }

    @Override
    public void reload() {
        basicTab.reload();
        taskTab.reload();
        logTab.reload();
    }  
    
    @Override
    public List<String> validate() {
        List<String> errors = new ArrayList<String>();
        errors.addAll(basicTab.validate());
        errors.addAll(taskTab.validate());
        errors.addAll(logTab.validate());
        return errors;
    }

    private void addTabs() {
        taskTab = parent.getTaskTab(uiPartner);
        logTab = ExecutionLogTab.createForPartner(uiPartner.getPartnerType() == PartnerType.Provider ? JobType.INGEST
                : JobType.EXPORT);
        
        
        taskTab.setMessageArea(messageArea);

        logTab.setUiPartner(uiPartner);
        logTab.setMessageArea(messageArea);
        logTab.setParentTabContainer(this);

        tabContainer.add(taskTab, taskTab.getDisplayName());
        tabContainer.add(logTab, logTab.getDisplayName());
        tabContainer.selectTab(0);
    }

    public void disableButtons() {
        basicTab.updateScrollPanelSize();
        logTab.updateScrollPanelSize();
    }

    public void setButtonVisible(boolean visible) {
        basicTab.getSaveButton().setVisible(visible);
    }

    public void refreshPartner(UIPartner uiPartner) {
        this.uiPartner = uiPartner;
        taskTab.setPartner(uiPartner, true);
        basicTab.setPartner(uiPartner);
        logTab.refreshData(uiPartner);
    }

    public void updateTabSize() {
        taskTab.updateScrollPanelSize();
        logTab.updateScrollPanelSize();
        basicTab.updateScrollPanelSize();
    }

    public PartnerBasicTab getBasicTab() {
        return basicTab;
    }

    public AbstractTaskTab getTaskTab() {
        return taskTab;
    }

    public ExecutionLogTab getLogTab() {
        return logTab;
    }

    public void saveSuccess() {
        basicTab.saveSuccess();
    }

}
