package com.ericsson.cms.epgmgmt.client.partner;


import com.ericsson.cms.epgmgmt.client.Permissions;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.PartnerConstantUtils;
import com.ericsson.cms.epgmgmt.client.model.enumeration.PartnerType;
import com.ericsson.cms.epgmgmt.client.provider.ProviderTabContainer;
import com.ericsson.cms.epgmgmt.client.publisher.PublisherTabContainer;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class PartnerViewPanel  extends Composite implements AnchorChangeListener{

    private static final String FULL_SCALE = "100%";
    private final AbstractPartnerTabContainer partnerTabContainer;
    private final HeaderPanel partnerHeaderPanel;
    private final HorizontalContainer buttonPanel = new HorizontalContainer();
    private final EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class);
    private static final String LIST_PANEL = "epg-tree-dock-panel";
    private static final String TABCONTAINER_DOCK_PANEL = "epg-tabContainer-dock-panel";
    private static final String TAB_CONTAINER_STYLE = "epg-tabContainer";
    private static final int MENU_HEIGHT = 155; // NOSONAR  150 too tight
    private final ScheduledCommand resizePanel;
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private HandlerRegistration windowRegistration = null;
    private static final String FULL_STYLE_NAME = "content-EPGPanel";
    private final HorizontalContainer horizontalPanel;
    private final PartnerType partnerType;


    public PartnerViewPanel(PartnerType partnerType, NeptuneSecurity security) {
        this.partnerType = partnerType;
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setStylePrimaryName(FULL_STYLE_NAME);
        mainPanel.setSpacing(1);
        partnerHeaderPanel = new HeaderPanel(getTitleName());
        mainPanel.add(partnerHeaderPanel);
        
        TabContainer mainTabContainer = new TabContainer();
        mainTabContainer.addStyleName(TAB_CONTAINER_STYLE);
        mainPanel.add(mainTabContainer);
        
        horizontalPanel = new HorizontalContainer();
        mainTabContainer.add(horizontalPanel, PartnerConstantUtils.getPartnerType(partnerType));
        mainTabContainer.selectTab(0);

        horizontalPanel.setStylePrimaryName(FULL_STYLE_NAME);
        
        
        createButtonPanel();
        PartnerListPanel partnerListWidget = new PartnerListPanel(security, partnerType);
        partnerListWidget.setHeight(FULL_SCALE);
        ScrollPanel scrollPanel = new ScrollPanel();
        scrollPanel.setHeight(FULL_SCALE);
        scrollPanel.add(partnerListWidget);
        DockPanel leftDockPanel = new DockPanel();
        leftDockPanel.setHeight(FULL_SCALE);
        leftDockPanel.add(scrollPanel, DockPanel.CENTER);
        leftDockPanel.setStyleName(LIST_PANEL);
        leftDockPanel.setWidth("200px");
        
        VerticalContainer leftVerticalContainer = new VerticalContainer();
        leftVerticalContainer.setHeight(FULL_SCALE);
        leftVerticalContainer.add(leftDockPanel);
        leftVerticalContainer.add(buttonPanel);
        
        leftVerticalContainer.setCellHeight(leftDockPanel, FULL_SCALE);
        
        
        Panel messagePanel = new VerticalPanel();
        MessageArea messageArea = new MessageArea();
        messagePanel.add(messageArea);
        if (partnerType == PartnerType.Provider) {
            partnerTabContainer = new ProviderTabContainer(partnerListWidget, messageArea);
        } else {
            partnerTabContainer = new PublisherTabContainer(partnerListWidget, messageArea);
        }
        
        partnerTabContainer.setHeight(FULL_SCALE);
        DockPanel rightDockPanel= new DockPanel();
        rightDockPanel.setHeight(FULL_SCALE);
        rightDockPanel.add(messagePanel, DockPanel.NORTH);
        rightDockPanel.add(partnerTabContainer, DockPanel.CENTER);
        rightDockPanel.setStyleName(TABCONTAINER_DOCK_PANEL);
        rightDockPanel.setCellHeight(partnerTabContainer, FULL_SCALE);
        

        
        horizontalPanel.add(leftVerticalContainer);
        horizontalPanel.setCellHorizontalAlignment(leftVerticalContainer, HorizontalContainer.ALIGN_LEFT);
        horizontalPanel.setCellWidth(leftVerticalContainer, "200px");
        horizontalPanel.setCellHeight(leftVerticalContainer, FULL_SCALE);
        
        
        horizontalPanel.add(rightDockPanel);
        horizontalPanel.setCellHorizontalAlignment(rightDockPanel, HorizontalContainer.ALIGN_LEFT);
        horizontalPanel.setCellVerticalAlignment(rightDockPanel, VerticalContainer.ALIGN_TOP);
        horizontalPanel.setCellWidth(rightDockPanel, FULL_SCALE);
        horizontalPanel.setCellHeight(rightDockPanel, FULL_SCALE);
        
        partnerListWidget.setTabContainer(partnerTabContainer);
        
        initWidget(mainPanel);
        resizePanel = new ScheduledCommand() {
            @Override
            public void execute() {
                resizePartnerListScrollPanel();
            }
        };
        updatePartnerListScrollPanelSize();
    }


    private String getTitleName() {
        return partnerType == PartnerType.Provider ? constants.providerTitleName() : constants.publisherTitleName();
    }


    private void createButtonPanel() {
        // Create button
        if(ClientAuthorizationManager.isAuthorized(Permissions.EPG_CREATE)) {

            ButtonWidget createButton = new ButtonWidget(constants.buttonLabelCreate());
            createButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
            createButton.addClickHandler(new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {
                    onCreate();
                }});
            buttonPanel.add(createButton);
        }
    }

    /**
     * 
     */
    private void onCreate(){
        partnerTabContainer.viewCreatePartner();
    }


    protected void updatePartnerListScrollPanelSize() {
        Scheduler.get().scheduleDeferred(resizePanel);
    }

    /*
     * Resize the right scroll panel
     */
    protected void resizePartnerListScrollPanel() {
        int treeHeight = Window.getClientHeight() - MENU_HEIGHT;
        treeHeight -= partnerHeaderPanel.getOffsetHeight();
        String height = treeHeight + "px";
        horizontalPanel.setHeight(height);
        partnerTabContainer.setHeight(treeHeight);
    }

    @Override
    public void anchorChanged(String anchor) {
        partnerTabContainer.anchorChanged(anchor);
        resizePartnerListScrollPanel();
    }

    @Override
    protected void onLoad() {
        super.onLoad();

        windowRegistration = Window.addResizeHandler(new ResizeHandler() {
            @Override
            public void onResize(ResizeEvent event) {
                updatePartnerListScrollPanelSize();
            }
        });
    };


    @Override
    protected void onUnload() {

        windowRegistration.removeHandler();
        windowRegistration = null;

        if (busyIndicator != null) {
            busyIndicator.hide();
        }

        super.onUnload();
    }

}
