package com.ericsson.cms.epgmgmt.client.partner;

import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

public class TaskStatusInfoPanel extends HorizontalPanel {

    private final String statusInfo;
    private static final String imageUrl = "cms_epgmgmt_ui/images/"; // NOSONAR

    public TaskStatusInfoPanel(String statusInfo) {
        this.statusInfo = statusInfo;
        createTaskStatusInfoPanel();
        setHorizontalAlignment(ALIGN_CENTER);
    }

    private void createTaskStatusInfoPanel() {
        if (statusInfo == null || "".equals(statusInfo.trim())) {
            return;
        }

        String[] images = statusInfo.split(",");
        for (String imageUrlText : images) {
            String imageInfo[] = imageUrlText.split(":", 2);
            if (imageInfo.length != 2) {
                continue;
            }
            Image image = createImageWidget(imageUrl + imageInfo[0].trim());
            LabelWidget statusInfoLable = new LabelWidget(imageInfo[1].trim());
            Image blankImage = createImageWidget(imageUrl + "layer-indicator-blank.png");
            this.add(image);
            this.add(statusInfoLable);
            this.add(blankImage);
        }
    }

    private Image createImageWidget(String url) {
        String width = "18px";
        String height = "18px";
        Image image = new Image(url);
        image.setWidth(width);
        image.setHeight(height);
        return image;
    }
    

    public static  HorizontalContainer createStatusBar(String labelName) {
        TaskStatusInfoPanel statusIndicatorPanel = new TaskStatusInfoPanel(labelName);
        HorizontalContainer lineBar = new HorizontalContainer();
        lineBar.setWidth("100%");
        lineBar.setHorizontalAlignment(HorizontalContainer.ALIGN_CENTER);
        lineBar.add(statusIndicatorPanel);
        return lineBar;
    }

 
}
