package com.ericsson.cms.epgmgmt.client.plugin;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.Permissions;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.UIPluginInfo;
import com.ericsson.cms.epgmgmt.client.model.UIPluginResult;
import com.ericsson.cms.epgmgmt.client.model.util.TableUtils;
import com.ericsson.cms.epgmgmt.client.rpc.IPluginMgmtService;
import com.ericsson.cms.epgmgmt.client.rpc.IPluginMgmtServiceAsync;
import com.ericsson.cms.epgmgmt.client.widget.AlignableCheckBoxView;
import com.ericsson.cms.epgmgmt.client.widget.ImageButtonBarView;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

public class EPGPluginDataProvider implements DataProvider<Long, UIPluginInfo> {

    private final List<String> buildinPluginFormatNames;
    private final List<Column<?, UIPluginInfo>> columns;
    // column names
    private static final String DATE_COLUMN = "createdDate";
    private static final String UPDATE_COLUMN = "updatedDate";
    private static final String JARNAME_COLUMN = "jarName";
    private static final String FORMAT_COLUMN = "formatName";
    private static final String TYPE_COLUMN = "type";
    private static final String INFO_COLUMN = "info";
    private static final String VERSION_COLUMN = "version";
    private static final String ACTIVE_COLUMN = "Active";
    private static final String ACTION_COLUMN = "Actions";
    private IBusyNotifier busyNotifier;

    private static final String STYLE_EXPORTSETTING_SMMAL_TEXT_SIZE = "epg-TableColumnPanel-dataCell-text";
    private final EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class);

    private final IPluginMgmtServiceAsync pluginMgmtService = GWT.create(IPluginMgmtService.class);

    public EPGPluginDataProvider(final EPGPluginListViewPanel panelView) {
        // columns for this table
        columns = new ArrayList<Column<?, UIPluginInfo>>();
        columns.add(createTypeColumn(TYPE_COLUMN, constants.epgTypeLabel()));
        columns.add(TableUtils.<UIPluginInfo> createTextColumn(FORMAT_COLUMN, constants.epgFormatNameLabel(),
                FORMAT_COLUMN));
        columns.add(TableUtils.<UIPluginInfo>createTextColumn(INFO_COLUMN, constants.epgInfoLabel(), INFO_COLUMN));
        columns.add(TableUtils.<UIPluginInfo>createTextColumn(VERSION_COLUMN, constants.epgVersionLabel(), VERSION_COLUMN) );
        columns.add(TableUtils.<UIPluginInfo>createDateColumn(DATE_COLUMN, constants.epgCreatedDateLabel(), DATE_COLUMN, constants.activityLogTimeFormat()));
        columns.add(TableUtils.<UIPluginInfo> createDateColumn(UPDATE_COLUMN, constants.epgUpdatedDateLabel(),
                UPDATE_COLUMN, constants.activityLogTimeFormat()));
        columns.add(TableUtils.<UIPluginInfo>createTextColumn(JARNAME_COLUMN, constants.epgFormatJarNameLabel(), JARNAME_COLUMN));
        columns.add(createActivateColumn(panelView));
        if (ClientAuthorizationManager.isAuthorized(Permissions.EPG_PLUGIN_MGMT)) {
            columns.add(createActionColumn(panelView));
        }
        buildinPluginFormatNames = new ArrayList<String>();
        /**
         * Comment out lines below to allow MGMT for build-in plugin in GUI
         * Will revert in the future.
            buildinPluginFormatNames.add("ETV");
            buildinPluginFormatNames.add("GLF");
            buildinPluginFormatNames.add("ROVI");
         */
    }

    private Column<?, UIPluginInfo> createTypeColumn(String typeColumn, String epgTypeLabel) {
        Column<String, UIPluginInfo> col = new ColumnBase<String, UIPluginInfo>(typeColumn,epgTypeLabel) {
            @Override
            public View<String> getView(final UIPluginInfo record) {
                if("Publisher".equals(record.getType())){
                    return new LabelStringView( constants.pluginTypePublisher());
                }else{
                    return new LabelStringView( constants.pluginTypeProvider());
                }
            }
        };
        return col;
    }

    private boolean isBuildinEpgFormat(String formatName) {
        return buildinPluginFormatNames.contains(formatName.toUpperCase());
    }

    private ColumnBase<String, UIPluginInfo> createActionColumn(final EPGPluginListViewPanel panelView) {
        ColumnBase<String, UIPluginInfo> deleteColumn = new ColumnBase<String, UIPluginInfo>(ACTIVE_COLUMN,
                constants.actionLabel()) {
            @Override
            public View<String> getView(final UIPluginInfo record) {
                ImageButtonBarView v = new ImageButtonBarView(new String[] { constants.uninstallLabel() },
                        new String[] { "cms_epgmgmt_ui/images/stop.png" }, true);
                v.getWidget().setWidth("100%");
                v.getButton(0).setVisible(!record.isDeleted() && !isBuildinEpgFormat(record.getFormatName()));
                v.getButton(0).addClickHandler(new ClickHandler() {

                    @Override
                    public void onClick(ClickEvent event) {
                        panelView.checkPlugin(record, EPGPluginListViewPanel.ACTION_UNINSTALL);
                    }
                });

                return v;
            }
        };
        deleteColumn.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);
        return deleteColumn;
    }

    private ColumnBase<Boolean, UIPluginInfo> createActivateColumn(final EPGPluginListViewPanel panelView) {
        ColumnBase<Boolean, UIPluginInfo> activeColumn = new ColumnBase<Boolean, UIPluginInfo>(ACTION_COLUMN,
                constants.epgFormatActiveLabel()) {
            @Override
            public View<Boolean> getView(final UIPluginInfo record) {
                boolean isEnabled = !record.isDeleted() && !isBuildinEpgFormat(record.getFormatName());
                AlignableCheckBoxView view = new AlignableCheckBoxView(record.isActive(), isEnabled,
                        HasHorizontalAlignment.ALIGN_CENTER);
                view.getCheckbox().addValueChangeHandler(new ActiveChangeListener(record, panelView));
                return view;
            }
        };
        activeColumn.setCellStyle(STYLE_EXPORTSETTING_SMMAL_TEXT_SIZE);
        return activeColumn;
    }


    @Override
    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    @Override
    public List<Column<?, UIPluginInfo>> getColumns() {
        return columns;
    }

    @Override
    public void getRecords(final AsyncCallback<List<UIPluginInfo>> callback) {
        notifyBusyStart();
        pluginMgmtService.listPlugin(new AsyncCallback<UIPluginResult>() {
            @Override
            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
                notifyBusyFinish();
            }

            @Override
            public void onSuccess(UIPluginResult result) {
                callback.onSuccess(result.getUiPlugins());
                notifyBusyFinish();
            }

        });
    }

    @Override
    public void getRecord(Long key, AsyncCallback<UIPluginInfo> callback) {

    }

    @Override
    public boolean isRecordCountEnabled() {
        return true;
    }

    @Override
    public boolean isCheckboxEnabled() {
        return false;
    }

    public interface IBusyNotifier {
        void startingToBeBusy();

        void doneBeingBusy();
    }
    private void notifyBusyStart() {
        if (busyNotifier != null) {
            busyNotifier.startingToBeBusy();
        }
    }

    public void setBusyNotifier(IBusyNotifier busyNotifier) {
        this.busyNotifier = busyNotifier;
    }

    private void notifyBusyFinish() {
        if (busyNotifier != null) {
            busyNotifier.doneBeingBusy();
        }
    }

    class ActiveChangeListener implements ValueChangeHandler<Boolean> {

        private final UIPluginInfo format;
        private final EPGPluginListViewPanel panel;

        public ActiveChangeListener(UIPluginInfo format, EPGPluginListViewPanel panel) {
            this.format = format;
            this.panel = panel;
        }

        @Override
        public void onValueChange(ValueChangeEvent<Boolean> event) {
            if (event.getValue()) {
                panel.activatePlugin(format);
            } else {
                panel.checkPlugin(format, EPGPluginListViewPanel.ACTION_DEACTIVATE);
            }
        }
    }
}