package com.ericsson.cms.epgmgmt.client.plugin;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentMessages;
import com.ericsson.cms.epgmgmt.client.model.UIEpgFormat;
import com.ericsson.cms.epgmgmt.client.model.UIPluginInfo;
import com.ericsson.cms.epgmgmt.client.rpc.IPluginMgmtService;
import com.ericsson.cms.epgmgmt.client.rpc.IPluginMgmtServiceAsync;
import com.ericsson.cms.epgmgmt.client.utils.DefaultAsyncCallback;
import com.ericsson.cms.epgmgmt.client.widget.EPGNoIconRoundedDisclosureContainer;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.FormPanel.SubmitCompleteEvent;
import com.google.gwt.user.client.ui.FormPanel.SubmitCompleteHandler;
import com.google.gwt.user.client.ui.HTMLTable.CellFormatter;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class PluginFileUploadpopup extends PopupPanel {

    private static final String DEFAULT_WIDTH = "100%";
    private final EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class);
    private final EPGComponentMessages messages = (EPGComponentMessages) GWT.create(EPGComponentMessages.class);
    private final IPluginMgmtServiceAsync service = GWT.create(IPluginMgmtService.class);
    private Button okButton;
    private TextBoxWidget typeBox;
    private TextBoxWidget nameBox;
    private TextBoxWidget versionBox;
    private TextBoxWidget jarNameBox;
    private EPGNoIconRoundedDisclosureContainer pluginInfoDisclosure;
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private FileUpload fileUpload;
    private UIEpgFormat epgFormat;
    private final Table<Long, UIPluginInfo> pluginTable;
    private Label pluginInfoLabel;

    public PluginFileUploadpopup(Table<Long, UIPluginInfo> pluginTable) {
        super(false);
        this.pluginTable = pluginTable;
        VerticalPanel mainPanel = new VerticalPanel();
        initCloseButton(mainPanel);
        mainPanel.add(createForm());
        mainPanel.add(createEpgFormPanel());
        mainPanel.add(creatButtonBar());
        mainPanel.setWidth(DEFAULT_WIDTH);
        mainPanel.setHeight(DEFAULT_WIDTH);
        mainPanel.setSpacing(5); //NOSONAR
        setWidget(mainPanel);
        setWidth("400px");
        center();
        setModal(true);
    }

    private Widget creatButtonBar() {
        HorizontalPanel outer = new HorizontalPanel();
        HorizontalPanel panel = new HorizontalPanel();
        okButton = new Button(constants.buttonLabelInstall());
        okButton.setEnabled(false);
        okButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
        okButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                installPlugin();
            }
        });
        panel.add(okButton);
        Button cancelButton = new Button(constants.buttonLabelCancel());
        cancelButton.addStyleName(StyleNames.DATALOSS_BUTTON_STYLE);
        cancelButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                hide();
            }
        });
        panel.add(cancelButton);
        outer.setWidth(DEFAULT_WIDTH);
        outer.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        outer.add(panel);
        return outer;
    }

    private Widget createForm() {
        final FormPanel form = new FormPanel();
        form.setAction(GWT.getModuleBaseURL() + "epgManagerService");
        form.setMethod("upload");
        fileUpload = new FileUpload();
        fileUpload.setName("uploadFormElement");
        fileUpload.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {
                String fileName = fileUpload.getFilename();
                if ("".equals(fileName) || !fileUpload.getFilename().endsWith(".zip")) {
                    Window.alert(messages.choosePluginFile());
                    okButton.setEnabled(false);
                    return;
                }
                busyIndicator.center();
                form.submit();
            }
        });
        form.add(fileUpload);
        form.addSubmitCompleteHandler(new SubmitCompleteHandler() {
            @Override
            public void onSubmitComplete(SubmitCompleteEvent event) {
                getPluginInfo();
            }
        });
        // Because we're going to add a FileUpload widget, we'll need to set the
        // form to use the POST method, and multipart MIME encoding.
        form.setEncoding(FormPanel.ENCODING_MULTIPART);
        form.setMethod(FormPanel.METHOD_POST);
        form.setHeight("50px");
        EPGNoIconRoundedDisclosureContainer formDisclosure = new EPGNoIconRoundedDisclosureContainer(new LabelWidget(constants.epgUploadFileLabel()), true);
        formDisclosure.setHeight(DEFAULT_WIDTH);
        formDisclosure.setWidth(DEFAULT_WIDTH);
        formDisclosure.setContent(form);
        return formDisclosure;
    }

    private Widget createEpgFormPanel() {
        FlexTable epgInfoForm = new FlexTable();
        typeBox = new TextBoxWidget();
        typeBox.setReadOnly(true);
        epgInfoForm.setText(0, 0, constants.epgTypeLabel());
        epgInfoForm.setWidget(0, 1, typeBox);

        nameBox = new TextBoxWidget();
        nameBox.setReadOnly(true);
        epgInfoForm.setText(1, 0, constants.epgFormatNameLabel());
        epgInfoForm.setWidget(1, 1, nameBox);

        versionBox = new TextBoxWidget();
        versionBox.setReadOnly(true);
        epgInfoForm.setText(2, 0, constants.epgVersionLabel());
        epgInfoForm.setWidget(2, 1, versionBox);

        jarNameBox = new TextBoxWidget();
        jarNameBox.setReadOnly(true);
        epgInfoForm.setText(3, 0, constants.epgFormatJarNameLabel()); //NOSONAR
        epgInfoForm.setWidget(3, 1, jarNameBox); //NOSONAR

        epgInfoForm.setCellPadding(4); //NOSONAR
        epgInfoForm.setCellSpacing(5); //NOSONAR
        CellFormatter formater = epgInfoForm.getCellFormatter();
        for (int i = 0; i < epgInfoForm.getRowCount(); i++) {
            formater.setHorizontalAlignment(i, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        }

        pluginInfoLabel = new Label();
        pluginInfoLabel.setVisible(false);

        VerticalPanel contentPanel = new VerticalPanel();
        contentPanel.add(pluginInfoLabel);
        contentPanel.add(epgInfoForm);
        contentPanel.setSpacing(5); //NOSONAR

        pluginInfoDisclosure = new EPGNoIconRoundedDisclosureContainer(new LabelWidget(constants.epgPluginInfoLabel()),
                true);
        pluginInfoDisclosure.setContent(contentPanel);
        pluginInfoDisclosure.setVisible(false);
        pluginInfoDisclosure.setWidth(DEFAULT_WIDTH);
        return pluginInfoDisclosure;
    }

    private void initCloseButton(VerticalPanel vp) {
        HorizontalContainer hc = new HorizontalContainer();
        hc.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        hc.add(createCloseButton());
        hc.setWidth(DEFAULT_WIDTH);
        hc.setHeight("20px");
        vp.add(hc);
    }

    private ImageWidget createCloseButton() {
        ImageWidget cb = new ImageWidget();
        ClickHandler handler = new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                PluginFileUploadpopup.this.hide();
            }
        };
        cb.setUrl("cms_epgmgmt_ui/images/delete.gif");
        cb.setHeight("18px");
        cb.setWidth("18px");
        cb.addClickHandler(handler);
        cb.addStyleName("epg-exportsetting-verticalpanel-widget");
        return cb;
    }

    private void fillEpgPanel(UIEpgFormat result) {
        this.epgFormat = result;
        typeBox.setText(result.getType());
        nameBox.setText(result.getName());
        versionBox.setText(result.getVersion());
        jarNameBox.setText(result.getJarName());
        pluginInfoDisclosure.setVisible(true);
        okButton.setEnabled(true);
        service.getPluginFormat(epgFormat.getName(), new DefaultAsyncCallback<UIEpgFormat>(null) {
            @Override
            public void onNeptuneSuccess(UIEpgFormat result) {
                if (result == null || result.isDeleted()) {
                    pluginInfoLabel.setVisible(false);
                    return;
                }
                pluginInfoLabel.setStyleName("epg-text-color-red");
                        pluginInfoLabel.setText(messages.installPluginMessage(epgFormat.getVersion()));
                        pluginInfoLabel.setVisible(true);
            }
        });
    }

    private void getPluginInfo() {
        service.getPluginInfo(0L, new DefaultAsyncCallback<UIEpgFormat>(null) {
            @Override
            public void onNeptuneSuccess(UIEpgFormat result) {
                busyIndicator.hide();
                fillEpgPanel(result);
            }
        });
    }

    private void installPlugin() {
        if (!Window.confirm(messages.installPluginConfirm())) {
            return;
        }

        service.installPlugin(-1L, fileUpload.getFilename(), epgFormat, new DefaultAsyncCallback<String>(null) {
            @Override
            public void onNeptuneSuccess(String result) {
                if (result != null && !result.trim().equals("")) {
                    Window.alert(result);
                } else {
                    PluginFileUploadpopup.this.hide();
                    pluginTable.refresh();
                }
            }
        });

    }
}
