package com.ericsson.cms.epgmgmt.client.presenter;

import java.util.Date;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.model.UiProgramGuideFilter;
import com.ericsson.cms.epgmgmt.client.model.enumeration.PGSortPropertyEnum;
import com.ericsson.cms.epgmgmt.client.rpc.IProgramGuideServiceAsync;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;

public class ProgramGuideFilterPresenter implements Presenter {
    public interface Display {
        HasClickHandlers getShowScheduleButton();
        void setData(List<String> data);
        String getHeadEndId();
        Date getStartDate();
        String getTime();
        Long getDuration();
        PGSortPropertyEnum getSort();
        Boolean isAscending();
        Widget asWidget();
        String getHeadEndName();
    }

    public ProgramGuideFilterPresenter(IProgramGuideServiceAsync rpcService, HandlerManager eventBus, Display view) {
        new UiProgramGuideFilter();
    }

    @Override
    public void go(HasWidgets container) {
    }
}
