/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.programguide;

import static com.google.gwt.user.client.ui.HasVerticalAlignment.ALIGN_MIDDLE;

import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * @author amit.r.seth
 *
 */
class EPGHeaderPanel extends Composite {
	private static final String STYLE_HEADER_LABEL = "epg-HeaderPanel-label";
	private static final String STYLE_HEADER = "epg-HeaderPanel";

	private SimpleContainer mainContainer;
	private VerticalContainer container;
	private LabelWidget label;

	public EPGHeaderPanel(String label) {
		/* Wrap the header panel table in a 'div' to avoid issues with margin on table */
		mainContainer = new SimpleContainer();
		initWidget(mainContainer);

		container = new VerticalContainer();
		container.setVerticalAlignment(ALIGN_MIDDLE);
		mainContainer.setWidget(container);

		this.label = new LabelWidget(label);
		this.label.setStyleName(STYLE_HEADER_LABEL);
		container.add(this.label);

		this.setStyleName(STYLE_HEADER);
	}
}
