package com.ericsson.cms.epgmgmt.client.programguide;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.UiProgram;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.DateBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;

public class ProgramDetailsPanel extends Composite {

    private static final String EPG_S_P_TABLE_BORDER_STYLE = "epg-s-p-table-border";
    private static final String HUNDRED_PER = "100%";

    private final EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class);

    private TextBoxWidget textBoxReducedDescription;
    private TextBoxWidget textBoxDescription;
    private TextBoxWidget textBoxAdvisory;
    private TextBoxWidget textBoxGenre;
    private DateBoxWidget dateBoxOriginalAirDate;
    private DateBoxWidget dateBoxGameDate;
    private TextBoxWidget textBoxGameTz;
    private TextBoxWidget textBoxUniqueID;
    private TextBoxWidget textBoxSyndicateEpisodeNo;
    private TextBoxWidget textBoxAltSyndicateEpisodeNo;
    private TextBoxWidget textBoxNetworkSynType;
    private TextBoxWidget textBoxNetworkSynSource;
    private TextBoxWidget textBoxSourceType;
    private TextBoxWidget textBoxShowType;
    private TextBoxWidget textBoxHoliday;
    private TextBoxWidget textBoxOriginalStudio;
    private TextBoxWidget textBoxMPAARating;
    private TextBoxWidget textBoxStarRating;
    private TextBoxWidget textBoxTitle;
    private TextBoxWidget textBoxAltTitle;
    private TextBoxWidget textBoxEpisodeTitle;
    private TextBoxWidget textBoxReducedTitle;
    private TextBoxWidget textBoxProgID;
    private TextBoxWidget textBoxLanguage;
    private TextBoxWidget textBoxRunTime;
    private TextBoxWidget textBoxProgramLang;
    private TextBoxWidget textBoxColorCode;
    private TextBoxWidget textBoxYear;
    private TextBoxWidget textBoxCountryOfOrigin;
    private CheckBox chckbxMadeForTv;
    // User data fields
    private TextBoxWidget textBoxUserData1;
    private TextBoxWidget textBoxUserData2;
    private TextBoxWidget textBoxUserData3;
    private TextBoxWidget textBoxUserData4;
    private TextBoxWidget textBoxUserData5;
    private TextBoxWidget textBoxUserData6;
    private TextBoxWidget textBoxUserData7;
    private TextBoxWidget textBoxUserData8;
    private TextBoxWidget textBoxUserData9;
    private TextBoxWidget textBoxUserData10;
    private TextBoxWidget textBoxUserData11;
    private TextBoxWidget textBoxUserData12;
    private TextBoxWidget textBoxUserData13;

    public ProgramDetailsPanel(UiProgram program) {
        ScrollContainer thisPanel = new ScrollContainer();

        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setSpacing(2);

        FormPanel formPanel = new FormPanel();
        formPanel.setWidget(mainPanel);
        thisPanel.add(formPanel);
        mainPanel.setWidth(HUNDRED_PER);

        createTopPanel(mainPanel);

        createSyndicatePanel(mainPanel);

        createDatePanel(mainPanel);

        createDescriptionsPanel(mainPanel);

        createUserDataPanel(mainPanel);

        if (program != null) {
            setData(program);
        }

        initWidget(thisPanel);

        disableFields();
    }

    /**
     * @param mainPanel
     */
    private void createUserDataPanel(VerticalPanel mainPanel) {
        VerticalPanel usrDataDisclosurePanel = new VerticalPanel();
        usrDataDisclosurePanel.setSpacing(2);
        usrDataDisclosurePanel.setStyleName(EPG_S_P_TABLE_BORDER_STYLE);

        RoundedDisclosureContainer disclosurePanel = new RoundedDisclosureContainer(constants.userDataLabel());
        ScrollPanel scrollPanel = new ScrollPanel(disclosurePanel);
        usrDataDisclosurePanel.add(scrollPanel);
        disclosurePanel.setWidth(HUNDRED_PER);
        disclosurePanel.setOpen(false);

        VerticalPanel userDataPanel = new VerticalPanel();
        userDataPanel.setSpacing(2);
        disclosurePanel.setContent(userDataPanel);
        userDataPanel.setWidth(HUNDRED_PER);

        Grid grid = new Grid(13, 2);
        userDataPanel.add(grid);
        grid.setWidth("98%");

        LabelWidget lblUserData1 = new LabelWidget(constants.userData1Label());
        grid.setWidget(0, 0, lblUserData1);

        textBoxUserData1 = new TextBoxWidget();
        grid.setWidget(0, 1, textBoxUserData1);
        textBoxUserData1.setWidth(HUNDRED_PER);

        LabelWidget lblUserData2 = new LabelWidget(constants.userData2Label());
        grid.setWidget(1, 0, lblUserData2);

        textBoxUserData2 = new TextBoxWidget();
        grid.setWidget(1, 1, textBoxUserData2);
        textBoxUserData2.setWidth(HUNDRED_PER);

        LabelWidget lblUserData3 = new LabelWidget(constants.userData3Label());
        grid.setWidget(2, 0, lblUserData3);

        textBoxUserData3 = new TextBoxWidget();
        grid.setWidget(2, 1, textBoxUserData3);
        textBoxUserData3.setWidth(HUNDRED_PER);

        LabelWidget lblUserData4 = new LabelWidget(constants.userData4Label());
        grid.setWidget(3, 0, lblUserData4);

        textBoxUserData4 = new TextBoxWidget();
        grid.setWidget(3, 1, textBoxUserData4);
        textBoxUserData4.setWidth(HUNDRED_PER);

        LabelWidget lblUserData5 = new LabelWidget(constants.userData5Label());
        grid.setWidget(4, 0, lblUserData5);

        textBoxUserData5 = new TextBoxWidget();
        grid.setWidget(4, 1, textBoxUserData5);
        textBoxUserData5.setWidth(HUNDRED_PER);

        LabelWidget lblUserData6 = new LabelWidget(constants.userData6Label());
        grid.setWidget(5, 0, lblUserData6);

        textBoxUserData6 = new TextBoxWidget();
        grid.setWidget(5, 1, textBoxUserData6);
        textBoxUserData6.setWidth(HUNDRED_PER);

        LabelWidget lblUserData7 = new LabelWidget(constants.userData7Label());
        grid.setWidget(6, 0, lblUserData7);

        textBoxUserData7 = new TextBoxWidget();
        grid.setWidget(6, 1, textBoxUserData7);
        textBoxUserData7.setWidth(HUNDRED_PER);

        LabelWidget lblUserData8 = new LabelWidget(constants.userData8Label());
        grid.setWidget(7, 0, lblUserData8);

        textBoxUserData8 = new TextBoxWidget();
        grid.setWidget(7, 1, textBoxUserData8);
        textBoxUserData8.setWidth(HUNDRED_PER);

        LabelWidget lblUserData9 = new LabelWidget(constants.userData9Label());
        grid.setWidget(8, 0, lblUserData9);

        textBoxUserData9 = new TextBoxWidget();
        grid.setWidget(8, 1, textBoxUserData9);
        textBoxUserData9.setWidth(HUNDRED_PER);

        LabelWidget lblUserData10 = new LabelWidget(constants.userData10Label());
        grid.setWidget(9, 0, lblUserData10);

        textBoxUserData10 = new TextBoxWidget();
        grid.setWidget(9, 1, textBoxUserData10);
        textBoxUserData10.setWidth(HUNDRED_PER);

        LabelWidget lblUserData11 = new LabelWidget(constants.userData11Label());
        grid.setWidget(10, 0, lblUserData11);

        textBoxUserData11 = new TextBoxWidget();
        grid.setWidget(10, 1, textBoxUserData11);
        textBoxUserData11.setWidth(HUNDRED_PER);

        LabelWidget lblUserData12 = new LabelWidget(constants.userData12Label());
        grid.setWidget(11, 0, lblUserData12);

        textBoxUserData12 = new TextBoxWidget();
        grid.setWidget(11, 1, textBoxUserData12);
        textBoxUserData12.setWidth(HUNDRED_PER);

        LabelWidget lblUserData13 = new LabelWidget(constants.userData13Label());
        grid.setWidget(12, 0, lblUserData13);

        textBoxUserData13 = new TextBoxWidget();
        grid.setWidget(12, 1, textBoxUserData13);
        textBoxUserData13.setWidth(HUNDRED_PER);

        mainPanel.add(usrDataDisclosurePanel);
    }

    /**
     * @param mainPanel
     */
    private void createDescriptionsPanel(VerticalPanel mainPanel) {
        VerticalPanel descriptionsPanel = new VerticalPanel();
        mainPanel.add(descriptionsPanel);
        descriptionsPanel.setStyleName(EPG_S_P_TABLE_BORDER_STYLE);

        FlexTable flexTable = new FlexTable();
        descriptionsPanel.add(flexTable);
        descriptionsPanel.setWidth(HUNDRED_PER);
        flexTable.setWidth("98%");

        LabelWidget lblReducedDescription = new LabelWidget(constants.lblReducedDescription());
        flexTable.setWidget(0, 0, lblReducedDescription);

        textBoxReducedDescription = new TextBoxWidget();
        flexTable.setWidget(0, 1, textBoxReducedDescription);
        textBoxReducedDescription.setWidth(HUNDRED_PER);

        LabelWidget lblDescription = new LabelWidget(constants.lblDescription());
        flexTable.setWidget(1, 0, lblDescription);

        textBoxDescription = new TextBoxWidget();
        flexTable.setWidget(1, 1, textBoxDescription);
        textBoxDescription.setWidth(HUNDRED_PER);

        LabelWidget lblAdvisory = new LabelWidget(constants.lblAdvisory());
        flexTable.setWidget(2, 0, lblAdvisory);

        textBoxAdvisory = new TextBoxWidget();
        flexTable.setWidget(2, 1, textBoxAdvisory);
        textBoxAdvisory.setWidth(HUNDRED_PER);

        LabelWidget lblGenre = new LabelWidget(constants.lblGenre());
        flexTable.setWidget(3, 0, lblGenre);

        textBoxGenre = new TextBoxWidget();
        flexTable.setWidget(3, 1, textBoxGenre);
        textBoxGenre.setWidth(HUNDRED_PER);

        flexTable.getFlexCellFormatter().setWidth(0, 1, "90%");
    }

    /**
     * @param mainPanel
     */
    private void createDatePanel(VerticalPanel mainPanel) {
        HorizontalPanel datePanel = new HorizontalPanel();
        datePanel.setStyleName(EPG_S_P_TABLE_BORDER_STYLE);
        mainPanel.add(datePanel);

        Grid grid = new Grid(1, 8);
        datePanel.add(grid);
        grid.setWidth(HUNDRED_PER);

        LabelWidget lblOriginalAirDate = new LabelWidget(constants.lblOriginalAirDate());
        grid.setWidget(0, 0, lblOriginalAirDate);

        dateBoxOriginalAirDate = new DateBoxWidget();
        grid.setWidget(0, 1, dateBoxOriginalAirDate);

        LabelWidget lblGameDate = new LabelWidget(constants.lblGameDate());
        grid.setWidget(0, 2, lblGameDate);

        dateBoxGameDate = new DateBoxWidget();
        grid.setWidget(0, 3, dateBoxGameDate);

        LabelWidget lblGameTimezone = new LabelWidget(constants.lblGameTimezone());
        grid.setWidget(0, 4, lblGameTimezone);

        textBoxGameTz = new TextBoxWidget();
        grid.setWidget(0, 5, textBoxGameTz);

        LabelWidget lblUniqueId = new LabelWidget(constants.lblUniqueId());
        grid.setWidget(0, 6, lblUniqueId);

        textBoxUniqueID = new TextBoxWidget();
        textBoxUniqueID.setMaxLength(8);
        textBoxUniqueID.setVisibleLength(8);
        grid.setWidget(0, 7, textBoxUniqueID);
    }

    /**
     * @param mainPanel
     */
    private void createSyndicatePanel(VerticalPanel mainPanel) {
        HorizontalPanel syndicatePanel = new HorizontalPanel();
        syndicatePanel.setStyleName(EPG_S_P_TABLE_BORDER_STYLE);
        mainPanel.add(syndicatePanel);

        Grid grid = new Grid(1, 8);
        syndicatePanel.add(grid);
        grid.setWidth(HUNDRED_PER);

        LabelWidget lblSyndicateEpisodeNo = new LabelWidget(constants.lblSyndicateEpisodeNo());
        grid.setWidget(0, 0, lblSyndicateEpisodeNo);

        textBoxSyndicateEpisodeNo = new TextBoxWidget();
        textBoxSyndicateEpisodeNo.setMaxLength(20);
        textBoxSyndicateEpisodeNo.setVisibleLength(20);
        grid.setWidget(0, 1, textBoxSyndicateEpisodeNo);

        LabelWidget lblAltSyndicateEpisode = new LabelWidget(constants.lblAltSyndicateEpisode());
        grid.setWidget(0, 2, lblAltSyndicateEpisode);

        textBoxAltSyndicateEpisodeNo = new TextBoxWidget();
        textBoxAltSyndicateEpisodeNo.setMaxLength(20);
        textBoxAltSyndicateEpisodeNo.setVisibleLength(20);
        grid.setWidget(0, 3, textBoxAltSyndicateEpisodeNo);

        LabelWidget lblNetworkSyndicateType = new LabelWidget(constants.lblNetworkSyndicateType());
        grid.setWidget(0, 4, lblNetworkSyndicateType);

        textBoxNetworkSynType = new TextBoxWidget();
        textBoxNetworkSynType.setMaxLength(21);
        grid.setWidget(0, 5, textBoxNetworkSynType);

        LabelWidget lblNetworkSyndicateSource = new LabelWidget(constants.lblNetworkSyndicateSource());
        grid.setWidget(0, 6, lblNetworkSyndicateSource);

        textBoxNetworkSynSource = new TextBoxWidget();
        textBoxNetworkSynSource.setMaxLength(10);
        textBoxNetworkSynSource.setVisibleLength(10);
        grid.setWidget(0, 7, textBoxNetworkSynSource);
    }

    /**
     * @param mainPanel
     */
    private void createTopPanel(VerticalPanel mainPanel) {
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        horizontalPanel.setSpacing(2);
        mainPanel.add(horizontalPanel);

        createMainDetailsPanel(horizontalPanel);

        createTitleSourcePanel(horizontalPanel);
    }

    /**
     * @param horizontalPanel
     */
    private void createTitleSourcePanel(HorizontalPanel horizontalPanel) {
        VerticalPanel titleSourcePanel = new VerticalPanel();
        horizontalPanel.add(titleSourcePanel);

        createTitlePanel(titleSourcePanel);

        createSourcePanel(titleSourcePanel);
    }

    /**
     * @param titleSourcePanel
     */
    private void createSourcePanel(VerticalPanel titleSourcePanel) {
        VerticalPanel sourcePanel = new VerticalPanel();
        sourcePanel.setStyleName(EPG_S_P_TABLE_BORDER_STYLE);
        titleSourcePanel.add(sourcePanel);

        FlexTable flexTable = new FlexTable();
        sourcePanel.add(flexTable);

        LabelWidget lblSourceType = new LabelWidget(constants.lblSourceType());
        flexTable.setWidget(0, 0, lblSourceType);

        textBoxSourceType = new TextBoxWidget();
        textBoxSourceType.setMaxLength(10);
        textBoxSourceType.setVisibleLength(10);
        flexTable.setWidget(0, 1, textBoxSourceType);

        LabelWidget lblShowType = new LabelWidget(constants.lblShowType());
        flexTable.setWidget(0, 2, lblShowType);

        textBoxShowType = new TextBoxWidget();
        textBoxShowType.setMaxLength(30);
        flexTable.setWidget(0, 3, textBoxShowType);

        LabelWidget lblHoliday = new LabelWidget(constants.lblHoliday());
        flexTable.setWidget(0, 4, lblHoliday);

        textBoxHoliday = new TextBoxWidget();
        textBoxHoliday.setMaxLength(30);
        flexTable.setWidget(0, 5, textBoxHoliday);

        LabelWidget lblOriginalStudio = new LabelWidget(constants.lblOriginalStudio());
        flexTable.setWidget(1, 0, lblOriginalStudio);

        textBoxOriginalStudio = new TextBoxWidget();
        flexTable.setWidget(1, 1, textBoxOriginalStudio);

        LabelWidget lblMpaaRating = new LabelWidget(constants.lblMpaaRating());
        flexTable.setWidget(1, 2, lblMpaaRating);

        textBoxMPAARating = new TextBoxWidget();
        textBoxMPAARating.setMaxLength(5);
        textBoxMPAARating.setVisibleLength(5);
        flexTable.setWidget(1, 3, textBoxMPAARating);

        LabelWidget lblStarRating = new LabelWidget(constants.lblStarRating());
        flexTable.setWidget(1, 4, lblStarRating);

        textBoxStarRating = new TextBoxWidget();
        textBoxStarRating.setMaxLength(5);
        textBoxStarRating.setVisibleLength(5);
        flexTable.setWidget(1, 5, textBoxStarRating);
    }

    /**
     * @param titleSourcePanel
     */
    private void createTitlePanel(VerticalPanel titleSourcePanel) {
        VerticalPanel titlePanel = new VerticalPanel();
        titlePanel.setStyleName(EPG_S_P_TABLE_BORDER_STYLE);
        titleSourcePanel.add(titlePanel);

        FlexTable flexTable = new FlexTable();
        titlePanel.add(flexTable);

        LabelWidget lblTitle = new LabelWidget(constants.lblTitle());
        flexTable.setWidget(0, 0, lblTitle);

        textBoxTitle = new TextBoxWidget();
        flexTable.setWidget(0, 1, textBoxTitle);

        LabelWidget lblAltTitle = new LabelWidget(constants.lblAltTitle());
        flexTable.setWidget(0, 2, lblAltTitle);

        textBoxAltTitle = new TextBoxWidget();
        flexTable.setWidget(0, 3, textBoxAltTitle);

        LabelWidget lblEpisodeTitle = new LabelWidget(constants.lblEpisodeTitle());
        flexTable.setWidget(0, 4, lblEpisodeTitle);

        textBoxEpisodeTitle = new TextBoxWidget();
        flexTable.setWidget(0, 5, textBoxEpisodeTitle);

        LabelWidget lblReducedTitle = new LabelWidget(constants.lblReducedTitle());
        flexTable.setWidget(1, 0, lblReducedTitle);

        textBoxReducedTitle = new TextBoxWidget();
        flexTable.setWidget(1, 1, textBoxReducedTitle);
        flexTable.getFlexCellFormatter().setColSpan(1, 1, 5);
        textBoxReducedTitle.setWidth("98%");
    }

    /**
     * @param horizontalPanel
     */
    private void createMainDetailsPanel(HorizontalPanel horizontalPanel) {
        VerticalPanel mainDetailsPanel = new VerticalPanel();
        mainDetailsPanel.setStyleName(EPG_S_P_TABLE_BORDER_STYLE);
        horizontalPanel.add(mainDetailsPanel);
        Grid grid = new Grid(4, 4);
        mainDetailsPanel.add(grid);

        LabelWidget lblProgID = new LabelWidget(constants.programID());
        grid.setWidget(0, 0, lblProgID);

        textBoxProgID = new TextBoxWidget();
        grid.setWidget(0, 1, textBoxProgID);

        LabelWidget lblLanguage = new LabelWidget(constants.lblLanguage());
        grid.setWidget(0, 2, lblLanguage);

        textBoxLanguage = new TextBoxWidget();
        textBoxLanguage.setMaxLength(12);
        textBoxLanguage.setVisibleLength(12);
        grid.setWidget(0, 3, textBoxLanguage);

        LabelWidget lblRunTime = new LabelWidget(constants.lblRunTime());
        grid.setWidget(1, 0, lblRunTime);

        textBoxRunTime = new TextBoxWidget();
        textBoxRunTime.setVisibleLength(4);
        textBoxRunTime.setMaxLength(4);
        grid.setWidget(1, 1, textBoxRunTime);

        LabelWidget lblProgramLanguage = new LabelWidget(constants.lblProgramLanguage());
        grid.setWidget(1, 2, lblProgramLanguage);

        textBoxProgramLang = new TextBoxWidget();
        textBoxProgramLang.setMaxLength(10);
        textBoxProgramLang.setVisibleLength(10);
        grid.setWidget(1, 3, textBoxProgramLang);

        LabelWidget lblColorCode = new LabelWidget(constants.lblColorCode());
        grid.setWidget(2, 0, lblColorCode);

        textBoxColorCode = new TextBoxWidget();
        textBoxColorCode.setMaxLength(20);
        grid.setWidget(2, 1, textBoxColorCode);

        LabelWidget lblYear = new LabelWidget(constants.lblYear());
        grid.setWidget(2, 2, lblYear);

        textBoxYear = new TextBoxWidget();
        textBoxYear.setVisibleLength(4);
        textBoxYear.setMaxLength(4);
        grid.setWidget(2, 3, textBoxYear);

        LabelWidget lblCountryOfOrigin = new LabelWidget(constants.lblCountryOfOrigin());
        grid.setWidget(3, 0, lblCountryOfOrigin);

        textBoxCountryOfOrigin = new TextBoxWidget();
        textBoxCountryOfOrigin.setMaxLength(15);
        textBoxCountryOfOrigin.setVisibleLength(15);
        grid.setWidget(3, 1, textBoxCountryOfOrigin);

        chckbxMadeForTv = new CheckBox(constants.chckbxMadeForTv());
        grid.setWidget(3, 3, chckbxMadeForTv);
    }

    private void setData(UiProgram program) {
        textBoxReducedDescription.setValue((program.getReducedDescription1()!=null ? program.getReducedDescription1():"") + " " + (program.getReducedDescription2()!=null ? program.getReducedDescription2():"") + " " + (program.getReducedDescription3()!=null ? program.getReducedDescription3():"") + " " + (program.getReducedDescription4()!=null ? program.getReducedDescription4():""));
        textBoxDescription.setValue((program.getDescription1()!=null ? program.getDescription1():"") + " " + (program.getDescription2()!=null ? program.getDescription2():""));
        textBoxAdvisory.setValue((program.getAdvisoryDesc1()!=null ? program.getAdvisoryDesc1():"") + " " + (program.getAdvisoryDesc2()!=null ? program.getAdvisoryDesc2():"") + " " + (program.getAdvisoryDesc3()!=null ? program.getAdvisoryDesc3():"") + " " + (program.getAdvisoryDesc4()!=null ? program.getAdvisoryDesc4():"") + " " + (program.getAdvisoryDesc5()!=null ? program.getAdvisoryDesc5():"") + " " + (program.getAdvisoryDesc6()!=null ? program.getAdvisoryDesc6():""));
        textBoxGenre.setValue((program.getGenreDesc1()!=null ? program.getGenreDesc1():"") + " " + (program.getGenreDesc2()!=null ? program.getGenreDesc2():"") + " " + (program.getGenreDesc3()!=null ? program.getGenreDesc3():"") + " " + (program.getGenreDesc4()!=null ? program.getGenreDesc4():"") + " " + (program.getGenreDesc5()!=null ? program.getGenreDesc5():"") + " " + (program.getGenreDesc6()!=null ? program.getGenreDesc6():""));
        dateBoxOriginalAirDate.setValue(program.getOrgAirDate());
        dateBoxGameDate.setValue(program.getGameDatetime());
        textBoxGameTz.setValue(program.getGameTimezone());
        textBoxUniqueID.setValue(program.getUniqueId());
        textBoxSyndicateEpisodeNo.setValue(program.getSyndicateEpisodeNum());
        textBoxAltSyndicateEpisodeNo.setValue(program.getAltSyndicateEpiNum());
        textBoxNetworkSynType.setValue(program.getNetSynType());
        textBoxNetworkSynSource.setValue(program.getNetSynSource());
        textBoxSourceType.setValue(program.getSourceType());
        textBoxShowType.setValue(program.getShowType());
        textBoxHoliday.setValue(program.getHoliday());
        textBoxOriginalStudio.setValue(program.getOrgStudio());
        textBoxMPAARating.setValue(program.getMpaaRating());
        textBoxStarRating.setValue(program.getStarRating());
        textBoxTitle.setValue(program.getTitle());
        textBoxAltTitle.setValue(program.getAltTitle());
        textBoxEpisodeTitle.setValue(program.getEpisodeTitle());
        textBoxReducedTitle.setValue((program.getReducedTitle1()!=null ? program.getReducedTitle1():"") + " " + (program.getReducedTitle2()!=null ? program.getReducedTitle2():"") + " " + (program.getReducedTitle3()!=null ? program.getReducedTitle3():"") + " " + (program.getReducedTitle4()!=null ? program.getReducedTitle4():""));
        textBoxProgID.setValue(program.getProgramId());
        textBoxLanguage.setValue(program.getLanguage());
        textBoxRunTime.setValue(program.getRunTime());
        textBoxProgramLang.setValue(program.getProgramLanguage());
        textBoxColorCode.setValue(program.getColorCode());
        textBoxYear.setValue(program.getYearProgram());
        textBoxCountryOfOrigin.setValue(program.getCountryOfOrigin());
        if (program.getMadeForTv() != null) {
            chckbxMadeForTv.setValue(program.getMadeForTv());
        }
        // User data fields
        textBoxUserData1.setValue(program.getUserData1());
        textBoxUserData2.setValue(program.getUserData2());
        textBoxUserData3.setValue(program.getUserData3());
        textBoxUserData4.setValue(program.getUserData4());
        textBoxUserData5.setValue(program.getUserData5());
        textBoxUserData6.setValue(program.getUserData6());
        textBoxUserData7.setValue(program.getUserData7());
        textBoxUserData8.setValue(program.getUserData8());
        textBoxUserData9.setValue(program.getUserData9());
        textBoxUserData10.setValue(program.getUserData10());
        textBoxUserData11.setValue(program.getUserData11());
        textBoxUserData12.setValue(program.getUserData12());
        textBoxUserData13.setValue(program.getUserData13());
    }

    public void disableFields() {
        boolean editable = false;
        textBoxReducedDescription.setEnabled(editable);
        textBoxDescription.setEnabled(editable);
        textBoxAdvisory.setEnabled(editable);
        textBoxGenre.setEnabled(editable);
        dateBoxOriginalAirDate.setEnabled(editable);
        dateBoxGameDate.setEnabled(editable);
        textBoxGameTz.setEnabled(editable);
        textBoxUniqueID.setEnabled(editable);
        textBoxSyndicateEpisodeNo.setEnabled(editable);
        textBoxAltSyndicateEpisodeNo.setEnabled(editable);
        textBoxNetworkSynType.setEnabled(editable);
        textBoxNetworkSynSource.setEnabled(editable);
        textBoxSourceType.setEnabled(editable);
        textBoxShowType.setEnabled(editable);
        textBoxHoliday.setEnabled(editable);
        textBoxOriginalStudio.setEnabled(editable);
        textBoxMPAARating.setEnabled(editable);
        textBoxStarRating.setEnabled(editable);
        textBoxTitle.setEnabled(editable);
        textBoxAltTitle.setEnabled(editable);
        textBoxEpisodeTitle.setEnabled(editable);
        textBoxReducedTitle.setEnabled(editable);
        textBoxProgID.setEnabled(editable);
        textBoxLanguage.setEnabled(editable);
        textBoxRunTime.setEnabled(editable);
        textBoxProgramLang.setEnabled(editable);
        textBoxColorCode.setEnabled(editable);
        textBoxYear.setEnabled(editable);
        textBoxCountryOfOrigin.setEnabled(editable);
        chckbxMadeForTv.setEnabled(editable);
        // User data fields
        textBoxUserData1.setEnabled(editable);
        textBoxUserData2.setEnabled(editable);
        textBoxUserData3.setEnabled(editable);
        textBoxUserData4.setEnabled(editable);
        textBoxUserData5.setEnabled(editable);
        textBoxUserData6.setEnabled(editable);
        textBoxUserData7.setEnabled(editable);
        textBoxUserData8.setEnabled(editable);
        textBoxUserData9.setEnabled(editable);
        textBoxUserData10.setEnabled(editable);
        textBoxUserData11.setEnabled(editable);
        textBoxUserData12.setEnabled(editable);
        textBoxUserData13.setEnabled(editable);
    }
}
