package com.ericsson.cms.epgmgmt.client.programguide;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.model.ProgramGuideSearchResult;
import com.ericsson.cms.epgmgmt.client.model.UiProgramGuideFilter;
import com.ericsson.cms.epgmgmt.client.model.UiProgramGuideResult;
import com.ericsson.cms.epgmgmt.client.rpc.IProgramGuideService;
import com.ericsson.cms.epgmgmt.client.rpc.IProgramGuideServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;

public class ProgramGuideDataProvider {

    // filter
    private UiProgramGuideFilter uiProgramGuideFilter;

    private final IProgramGuideServiceAsync programGuideManagerService = GWT.create( IProgramGuideService.class );

    private PageFeature parentPageFeature;
    private SortFeatureImpl<Long, UiProgramGuideRecord> parentSortFeature;

    private IBusyNotifier busyNotifier;

    public ProgramGuideDataProvider( ProgramGuideDisplayPanel programGuideDisplayPanel ) {

    }

    public void getRecord( Long key, final AsyncCallback<UiProgramGuideResult> callback ) {

    }


    public void getRecords( final AsyncCallback<UiProgramGuideResult> callback ) {
        int length = getParentPageFeature().getPageSize();
        int start = (getParentPageFeature().getPageNumber() - 1) * length;
        notifyBusyStart();


        programGuideManagerService.findProgramsByFilter( start, length,uiProgramGuideFilter.getSortType().toString(),
                uiProgramGuideFilter, new NeptuneAsyncCallback<ProgramGuideSearchResult>() {

            @Override
            public void onNeptuneFailure( Throwable caught ) {
                callback.onFailure( caught );
                notifyBusyFinish();
            }

            @Override
            public void onNeptuneSuccess( ProgramGuideSearchResult result ) {
                getParentPageFeature().setRecordCount(result.getTotalCount());
                List<UiProgramGuideResult> uiProgramGuideResultList = new ArrayList<UiProgramGuideResult>();
                uiProgramGuideResultList.addAll(result.getUiProgramGuideResultList());

                uiProgramGuideResultList.get(0).setDuration(uiProgramGuideFilter.getDuration());
                uiProgramGuideResultList.get(0).setStartTime(uiProgramGuideFilter.getTime());
                uiProgramGuideResultList.get(0).setStartTimeKey(uiProgramGuideFilter.getTimeKey());

                callback.onSuccess( uiProgramGuideResultList.get(0));
                notifyBusyFinish();
            }

        } );

    }


    public void initialize( AsyncCallback<Void> callback ) {
        callback.onSuccess( null );
    }

    //@Override
    public boolean isCheckboxEnabled() {
        return true;
    }

    //@Override
    public boolean isRecordCountEnabled() {
        return true;
    }

    /**
     * @return the parentPageFeature
     */
    public PageFeature getParentPageFeature() {
        return parentPageFeature;
    }

    /**
     * @param parentPageFeature
     *            the parentPageFeature to set
     */
    public void setParentPageFeature( PageFeature parentPageFeature ) {
        this.parentPageFeature = parentPageFeature;
    }

    /**
     * @return the parentSortFeature
     */
    public SortFeatureImpl<Long, UiProgramGuideRecord> getParentSortFeature() {
        return parentSortFeature;
    }

    /**
     * @param parentSortFeature
     *            the parentSortFeature to set
     */
    public void setParentSortFeature( SortFeatureImpl<Long, UiProgramGuideRecord> parentSortFeature ) {
        this.parentSortFeature = parentSortFeature;
    }

    public static interface IBusyNotifier {
        void startingToBeBusy();

        void doneBeingBusy();
    }

    public void setBusyNotifier( IBusyNotifier busyNotifier ) {
        this.busyNotifier = busyNotifier;
    }


    private void notifyBusyStart() {
        if ( busyNotifier != null ) {
            busyNotifier.startingToBeBusy();
        }
    }

    private void notifyBusyFinish() {
        if ( busyNotifier != null ) {
            busyNotifier.doneBeingBusy();
        }
    }

    public UiProgramGuideFilter getUiProgramGuideFilter() {
        return uiProgramGuideFilter;
    }

    public void setUiProgramGuideFilter(UiProgramGuideFilter uiProgramGuideFilter) {
        this.uiProgramGuideFilter = uiProgramGuideFilter;
    }




}
