/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.programguide;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.UiProgramGuideFilter;
import com.ericsson.cms.epgmgmt.client.model.UiProgramGuideResult;
import com.ericsson.cms.epgmgmt.client.model.UiSchedule;
import com.ericsson.cms.epgmgmt.client.model.UiStation;
import com.ericsson.cms.epgmgmt.client.model.enumeration.TimeEnum;
import com.ericsson.cms.epgmgmt.client.model.enumeration.TimeFractionEnum;
import com.ericsson.cms.epgmgmt.client.programguide.ProgramGuideDataProvider.IBusyNotifier;
import com.ericsson.cms.epgmgmt.client.utils.DateConvert;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.datepicker.client.CalendarUtil;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author amit.r.seth
 *
 */
public class ProgramGuideDisplayPanel extends Composite {

    private static final int DEFAULT_STATION_COUNT = 5;
    private static final int TABLE_SIZE = 1056;
    private static int COLUMN_RATIO = 0;
    private static final long BORDER_SIZE = 4;
    private static final String COLUMN_ONE = "140px";
    private static final String CELL_HEIGHT = "50px";
    private static int CMS_HEADER_MENU_SIZE_PX = 115;
    private static final String TABLE_HEADER_ROW = "epg-table-header-row";
    private static final String TABLE_NONSORTABLE_TEXT = "epg-table-header-nonSortable-text";
    private static final String TABLE_BOLD_TEXT = "epg-table-header-bold-text";
    private static final String TABLE_EVEN_ROW = "epg-table-data-even-row";
    private static final String TABLE_ODD_ROW = "epg-table-data-odd-row";
    private static final String TABLE_OVERLAPING = "epg-table-overlaping-row";
    private static final String PG_CELL_DATA = "epg-TableColumnPanel-dataCell-text";

    private static final String TAB_CONTAINER_STYLE = "epg-tabContainer";
    private static final String STYLE_NAME = "content-EPGPanel";
    private static final String BUTTON_PANEL_STYLE = "epg-tabContainer-buttonPanel";
    private static final int SHIFT_HOUR = 1;
    private static final long MILL_SECONDS = 1000;

    private ProgramGuideDataProvider dataProvider;
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private final VerticalPanel panel = new VerticalPanel();
    private HeaderPanel headerPanel;
    private final TabContainer tabContainer = new TabContainer();
    private VerticalContainer tabPanel;
    private FlexTable mainTable;
    private FlexTable tableBase;
    private FlexTable header;
    private Grid grid;
    private PageFeature pageFeature;
    private VerticalPanel verticalButtonPanel;
    private HorizontalContainer verticalButtonHorizontal;
    private HorizontalContainer horizontalButtonHorizontal;
    private final HorizontalContainer bottomButtonPanel = new HorizontalContainer();
    private final ScrollContainer guideContainer = new ScrollContainer();

    private final EPGComponentConstants constants = (EPGComponentConstants) GWT
            .create(EPGComponentConstants.class);

    private final SimpleContainer baseWidgetToReplace;

    private Image buttonVerticalNext;
    private Image buttonVerticalPrevious;
    private Image buttonHorizontalNext;
    private Image buttonHorizontalPrevious;

    private HandlerRegistration resizeHandlerRegistration;

    public ProgramGuideDisplayPanel(UiProgramGuideFilter filter, SimpleContainer baseWidget) {
        this.baseWidgetToReplace = baseWidget;
        initWidgets();
        Scheduler.get().scheduleDeferred(new ScheduledCommand() {
            @Override
            public void execute() {
                updateTableContainerSize();
            }
        });
        setFilter(filter);
        refresh();
    }

    private void initWidgets() {

        this.initWidget( panel );

        panel.setStylePrimaryName(STYLE_NAME);
        headerPanel = new HeaderPanel(constants.programGuide() + " : " + constants.programGuideData());
        pageFeature = new PageFeatureImpl();
        dataProvider = new ProgramGuideDataProvider(this);
        mainTable = new FlexTable();
        tableBase = new FlexTable();
        header = new FlexTable();
        buttonVerticalNext = new ImageWidget();
        buttonVerticalPrevious = new ImageWidget();
        buttonHorizontalNext = new ImageWidget();
        buttonHorizontalPrevious = new ImageWidget();
        buttonVerticalPrevious.setUrl("cms_epgmgmt_ui/images/GoUpDisabled.png");
        buttonHorizontalPrevious.setUrl("cms_epgmgmt_ui/images/GoToPrevEnabled.png");
        buttonVerticalNext.setUrl("cms_epgmgmt_ui/images/GoDownDisabled.png");
        buttonHorizontalNext.setUrl("cms_epgmgmt_ui/images/GoToNextEnabled.png");
        verticalButtonPanel = new VerticalPanel();
        verticalButtonHorizontal = new HorizontalContainer();
        horizontalButtonHorizontal = new HorizontalContainer();
        horizontalButtonHorizontal.setWidth(1218 + "px");

        buttonVerticalNext.addClickHandler(new ClickHandler(){

            @Override
            public void onClick(ClickEvent event) {
                if (isButtonEnabled(buttonVerticalNext)) {

                    if (pageFeature.getRecordCount() / pageFeature.getPageSize() > 2) {
                        buttonVerticalPrevious.setUrl("cms_epgmgmt_ui/images/GoUpEnabled.png");
                    }

                    pageFeature.setPageNumber(pageFeature.getPageNumber() + 1);

                    if (pageFeature.getRecordCount() / (pageFeature.getPageNumber() * pageFeature.getPageSize()) <= 1) {
                        buttonVerticalNext.setUrl("cms_epgmgmt_ui/images/GoDownDisabled.png");
                    }

                    refresh();
                }
            }

        });

        buttonHorizontalNext.addClickHandler(new ClickHandler(){

            @Override
            public void onClick(ClickEvent event) {

                String[] amPM = dataProvider.getUiProgramGuideFilter().getTime().split(" ");
                String[] time = amPM[0].split(":");
                Integer intTime = Integer.parseInt(time[0]);
                Integer enumTimeKey = Integer.parseInt(dataProvider.getUiProgramGuideFilter().getTimeKey());
                intTime = intTime + SHIFT_HOUR;
                enumTimeKey = enumTimeKey + SHIFT_HOUR;
                changeTime(amPM,intTime,enumTimeKey,true);
                refresh();
            }

        });

        buttonVerticalPrevious.addClickHandler(new ClickHandler(){

            @Override
            public void onClick(ClickEvent event) {
                if (isButtonEnabled(buttonVerticalPrevious)) {
                    pageFeature.setPageNumber(pageFeature.getPageNumber() - 1);
                    refresh();
                }
            }

        });

        buttonHorizontalPrevious.addClickHandler(new ClickHandler(){

            @Override
            public void onClick(ClickEvent event) {

                String[] amPM = dataProvider.getUiProgramGuideFilter().getTime().split(" ");
                String[] time = amPM[0].split(":");
                Integer intTime = Integer.parseInt(time[0]);
                Integer enumTimeKey = Integer.parseInt(dataProvider.getUiProgramGuideFilter().getTimeKey());
                intTime = intTime - SHIFT_HOUR;
                enumTimeKey = enumTimeKey - SHIFT_HOUR;
                changeTime(amPM,intTime,enumTimeKey,false);
                refresh();
            }

        });
        tabContainer.addStyleName(TAB_CONTAINER_STYLE);

        // page feature
        pageFeature = new PageFeatureImpl();
        pageFeature.setPageSize(DEFAULT_STATION_COUNT);
        dataProvider.setParentPageFeature(pageFeature);

        tabPanel = new VerticalContainer();
        guideContainer.add(tabPanel);
        tabContainer.add(guideContainer, constants.programGuideData());
        tabContainer.selectTab(0);

        // Bottom Button Panel
        createBottomButtonPanel();

        // Add panels
        panel.add(headerPanel);
        panel.add(tabContainer);
        panel.add(bottomButtonPanel);
    }

    private void createBottomButtonPanel() {
        bottomButtonPanel.setStyleName(BUTTON_PANEL_STYLE);

        // cancel button
        ButtonWidget cancelButton = new ButtonWidget(constants.buttonLabelCancel());
        cancelButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
        cancelButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                History.back();
            }
        });
        bottomButtonPanel.add(cancelButton);

        if (cancelButton != null) {
            bottomButtonPanel.setCellWidth(cancelButton, "99%");
        }
    }

    private void updateTableContainerSize() {
        int height = Window.getClientHeight()
                - CMS_HEADER_MENU_SIZE_PX
                - headerPanel.getOffsetHeight()
                - tabContainer.getTabBar().getOffsetHeight()
                - bottomButtonPanel.getOffsetHeight()
                - 14;	//adjustment for borders and spacing at the bottom
        guideContainer.setHeight(height + "px");
        resetVerticalButtonPanelHeight();
    }

    private void resetVerticalButtonPanelHeight() {
        if (tableBase.getOffsetHeight() > 50) {
            verticalButtonPanel.setHeight(tableBase.getOffsetHeight() + "px");
        }
    }

    private void changeTime(String[] time,Integer hour,Integer enumTimeKey, boolean sum){
        String[] hourMinute = time[0].split(":");
        long startDateInMilliSeconds = 0l;
        long endDateInMilliSeconds = 0l;
        UiProgramGuideFilter filter = dataProvider.getUiProgramGuideFilter();

        if (sum) {
            if (hour == 12) {
                if(time[1].equals("PM")){
                    CalendarUtil.addDaysToDate(filter.getStartDate(), 1);
                    filter.setTime(hour + ":" + hourMinute[1] + " " + "AM" );
                }
                else{
                    filter.setTime(hour + ":" + hourMinute[1] + " " + "PM" );
                }
            } else if (hour == 13){
                hourMinute[0] = "01";
                filter.setTime(hourMinute[0] + ":" + hourMinute[1] + " " + time[1] );
            }
            else{
                hourMinute[0] = hour > 9? hour.toString() : "0"+ hour.toString();
                filter.setTime(hourMinute[0] + ":" + hourMinute[1] + " " + time[1] );
            }


        } else {
            if (hour == 11) {
                if(time[1].equals("AM")){
                    CalendarUtil.addDaysToDate(dataProvider.getUiProgramGuideFilter().getStartDate(), -1);
                    filter.setTime(hour + ":" + hourMinute[1] + " " + "PM" );
                }
                else{
                    filter.setTime(hour + ":" + hourMinute[1] + " " + "AM" );
                }
            } else if (hour == 0){
                hourMinute[0] = "12";
                filter.setTime(hourMinute[0] + ":" + hourMinute[1] + " " + time[1] );
            }
            else{
                hourMinute[0] = hour > 9? hour.toString() : "0"+ hour.toString();
                filter.setTime(hourMinute[0] + ":" + hourMinute[1] + " " + time[1] );
            }

        }

        startDateInMilliSeconds = DateConvert.constructDateInMilliSeconds(filter.getStartDate(), filter.getTime());
        if (startDateInMilliSeconds != 0){
            filter.setStartDateInMilliSeconds(startDateInMilliSeconds);

            endDateInMilliSeconds = filter.getEndDateFromStartDate(startDateInMilliSeconds);
            filter.setEndDateInMilliSeconds(endDateInMilliSeconds);
        }

        //Adjust the new TimeEnum key value.
        if(enumTimeKey <0){
            filter.setTimeKey(String.valueOf(24 - Math.abs(enumTimeKey)));
        }
        else if(enumTimeKey > 23){
            filter.setTimeKey(String.valueOf(Math.abs(25 - enumTimeKey) -1));
        }
        else{
            filter.setTimeKey(enumTimeKey.toString());
        }

    }


    private boolean isButtonEnabled(Image button){

        if(button.getUrl().toUpperCase().contains("DISABLED")){
            return false;
        }

        return true;
    }

    private void setData(UiProgramGuideResult result){

        buildTableHeaders(result.getStartDate(),result.getStartTimeKey(),result.getDuration());
        buildBaseTable(result);
        mainTable.setWidget(0, 0, tableBase);


        verticalButtonPanel.add(buttonVerticalPrevious);
        verticalButtonPanel.add(buttonVerticalNext);
        verticalButtonPanel.setBorderWidth(0);
        int height = result.getGuide().size();
        height++;
        String buttonSize =height * 50 + height * 9.5  + "px";
        verticalButtonPanel.setHeight(buttonSize);
        verticalButtonPanel.setCellVerticalAlignment(buttonVerticalNext, HasVerticalAlignment.ALIGN_BOTTOM);
        verticalButtonHorizontal.add(mainTable);
        verticalButtonHorizontal.add(verticalButtonPanel);
        verticalButtonHorizontal.setBorderWidth(0);


        horizontalButtonHorizontal.add(buttonHorizontalPrevious);
        horizontalButtonHorizontal.add(buttonHorizontalNext);
        horizontalButtonHorizontal.setCellHorizontalAlignment(buttonHorizontalNext, HasHorizontalAlignment.ALIGN_RIGHT);

        tabPanel.add(verticalButtonHorizontal);
        tabPanel.add(horizontalButtonHorizontal);

    }



    private void buildBaseTable(UiProgramGuideResult result){

        if(tableBase != null){
            tableBase.removeAllRows();
            tableBase = null;
        }


        tableBase = new FlexTable();
        tableBase.setBorderWidth(1);
        tableBase.getFlexCellFormatter().setWidth(0, 1, TABLE_SIZE +"px");
        tableBase.getFlexCellFormatter().setWidth(0, 0, COLUMN_ONE);
        tableBase.getFlexCellFormatter().setStyleName(0, 0, TABLE_HEADER_ROW);
        LabelWidget label = new LabelWidget(constants.stationTimesHeaderLabel());
        label.setStyleName(TABLE_NONSORTABLE_TEXT);
        tableBase.setWidget(0, 0, label);
        tableBase.setWidget(0,1, header);
        tableBase.getFlexCellFormatter().setHeight(0, 0, CELL_HEIGHT);
        tableBase.getFlexCellFormatter().setHeight(0, 1, CELL_HEIGHT);

        Map<UiStation, List<UiSchedule>> map = result.getGuide();
        Iterator<Map.Entry<UiStation, List<UiSchedule>>> entries = map.entrySet().iterator();
        int rows = 1;
        boolean overlaping = false;

        while (entries.hasNext()) {
            Map.Entry<UiStation, List<UiSchedule>> entry = entries.next();
            UiStation station = entry.getKey();
            HTML labelW = new HTML((station.getStationName()!=null ? station.getStationName():"") + " <br>" + station.getCallSign() + " <br>" + station.getStationId() + " <br>" + station.getAffiliation());
            labelW.setStyleName(TABLE_NONSORTABLE_TEXT);
            tableBase.getFlexCellFormatter().setWidth(rows, 0, COLUMN_ONE);
            tableBase.getFlexCellFormatter().setHeight(rows, 0, CELL_HEIGHT);
            tableBase.getFlexCellFormatter().setStyleName(rows, 0,  TABLE_HEADER_ROW);
            tableBase.setWidget(rows, 0, labelW);

            Long gridRatio = 0L;
            int columns = 0;
            Long gridTotal = 0L;
            int gridSize = entry.getValue().size()==0 ? 1 : entry.getValue().size();
            grid = new Grid(1,gridSize);
            grid.setStyleName(PG_CELL_DATA);
            long width = TABLE_SIZE + Integer.parseInt(result.getDuration()) * 2 - BORDER_SIZE;
            grid.setWidth(width + "px");
            overlaping = false;
            List<UiSchedule> uiScheduleList = entry.getValue();
            boolean lastProgramPadding = false;
            long lastProgramPaddingRatio = 0L;
            Date startDate = result.getStartDate();

            overlap:
                for(int i = 0; i < uiScheduleList.size(); i++){
                    /*
                     *  COLUMN_RATIO ---- 30 Minutes
                     *  GRID_RATIO   ---- (DURATION /60)Minutes
                     * 
                     * 
                     *  ----------------------------------------------------
                     *  | prog 1 | Prog 2 |    | Prog 3                 |   |
                     *  ----------------------------------------------------
                     */
                    boolean programPadding = false;
                    long overlapTime = 0;
                    long overlapRatio = 0;
                    UiSchedule uiSchedule = uiScheduleList.get(i);
                    gridRatio = 0L;

                    // Check if needs Padding (gaps between times must be padded with empty space)
                    if(uiSchedule.getStartTime().after(startDate)){
                        programPadding = true;
                        long secondsBetween = Math.abs(startDate.getTime() - uiSchedule.getStartTime().getTime()) / MILL_SECONDS;
                        gridRatio = getRatio(secondsBetween);
                        gridRatio = gridRatio == 0 ? getRatio(uiSchedule.getDuration()) : gridRatio ;

                        if(columns >= 0){
                            grid.resizeColumns(grid.getColumnCount() + 1);
                        }
                        long borderFactor = gridRatio/COLUMN_RATIO;
                        borderFactor = borderFactor==0?1:borderFactor;
                        grid.getCellFormatter().setWidth(0, columns, gridRatio - BORDER_SIZE+"px");
                        grid.getCellFormatter().setHeight(0, columns, CELL_HEIGHT);
                        grid.setText(0, columns++, "  ");
                        gridTotal += gridRatio;
                    }
                    startDate = uiSchedule.getEndTime();

                    // For the first program check if it started before the initial time
                    if(i == 0 ){
                        programPadding = false;
                        if(uiSchedule.getStartTime().before(result.getStartDate())) {
                            long secondsBetween = getSecondsWithStartTime(result, uiSchedule);
                            gridRatio = getRatio(uiSchedule.getDuration() - secondsBetween);
                            gridRatio = gridRatio == 0 ? getRatio(uiSchedule.getDuration()) : gridRatio ;
                        }
                        else{
                            long secondsBetween = Math.abs(result.getEndDate().getTime()- uiSchedule.getStartTime().getTime()) / MILL_SECONDS;
                            if(uiSchedule.getDuration() > secondsBetween) {
                                gridRatio = getRatio(secondsBetween);
                            } else {
                                gridRatio = getRatio(uiSchedule.getDuration());
                            }
                        }

                        //only one programs for this station, add padding if schedule end time before result's endDate
                        if(uiScheduleList.size() == 1 && uiSchedule.getEndTime().before(result.getEndDate())) {
                            // check if it finish before the end time(in this case needs padding)
                            lastProgramPadding = true;
                            lastProgramPaddingRatio = extractLastPaddingRatio(result, uiSchedule);
                        }
                    }
                    // For the last program
                    else if(i == uiScheduleList.size() - 1){
                        //check if it finish after the end time
                        if(uiSchedule.getEndTime().after(result.getEndDate())){
                            programPadding = false;
                            long secondsBetween = getSecondsWithEndTime(result, uiSchedule);
                            gridRatio = getRatio(secondsBetween - uiSchedule.getDuration());
                            if(gridRatio == 0 && !result.getEndDate().equals(uiSchedule.getStartTime())){
                                gridRatio = getRatio(uiSchedule.getDuration());
                            }
                        }
                        // check if it finish before the end time(in this case needs padding)
                        else if(uiSchedule.getEndTime().before(result.getEndDate())){
                            lastProgramPadding = true;
                            gridRatio = getRatio(uiSchedule.getDuration());
                            Long borderFactor = gridRatio/COLUMN_RATIO;
                            borderFactor = borderFactor == 0?1:borderFactor;
                            lastProgramPaddingRatio = getRatio(getSecondsWithEndTime(result, uiSchedule));
                            lastProgramPaddingRatio = lastProgramPaddingRatio - BORDER_SIZE*2 * borderFactor;
                        }
                        else {
                            gridRatio = getRatio(uiSchedule.getDuration());
                        }
                        /**if it gets here as programPadding it means it gridRatio value is the one from padding
                         * it needs to update gridRatio with the correct value from schedule.
                         */
                        if(programPadding){
                            programPadding = false;
                            gridRatio = getRatio(uiSchedule.getDuration());
                        }
                        //Check Overlapping condition of last program
                        if(i > 0 && uiSchedule.getStartTime().before(uiScheduleList.get(i-1).getEndTime())){
                            overlapTime =  Math.abs(uiSchedule.getStartTime().getTime() - uiScheduleList.get(i-1).getEndTime().getTime()) / MILL_SECONDS;
                            overlaping = true;
                        }
                    }
                    else{
                        //Check Overlapping condition
                        if(i > 0 && uiSchedule.getStartTime().before(uiScheduleList.get(i-1).getEndTime())){
                            overlaping = true;

                        }
                        else{
                            gridRatio = getRatio(uiSchedule.getDuration());
                        }

                    }
                    if(overlaping){
                        overlapTime =  Math.abs(uiSchedule.getStartTime().getTime() - uiScheduleList.get(i-1).getEndTime().getTime()) / MILL_SECONDS;
                        overlapRatio = Math.abs((uiScheduleList.get(i-1).getEndTime().getTime() - uiSchedule.getEndTime().getTime())/MILL_SECONDS);
                        grid.getWidget(0, columns-1).addStyleName(TABLE_OVERLAPING);
                        if(overlapTime - uiSchedule.getDuration() == 0){
                            overlaping = false;
                            grid.resizeColumns(grid.getColumnCount() - 1);
                            continue overlap;

                        }
                        else{
                            gridRatio = getRatio(overlapRatio);
                            gridTotal += getRatio(overlapTime);
                        }

                    }

                    gridRatio = gridRatio - BORDER_SIZE;

                    gridRatio = gridRatio > 0 ? gridRatio :0;
                    gridRatio = gridRatio > TABLE_SIZE ? TABLE_SIZE :gridRatio;
                    gridTotal += gridRatio ;

                    grid.getCellFormatter().setWidth(0, columns, gridRatio.toString() + "px");
                    grid.getCellFormatter().setHeight(0, columns, CELL_HEIGHT);
                    ScheduleDispWidget text = new ScheduleDispWidget(uiSchedule, gridRatio, this.baseWidgetToReplace, this);
                    if (columns >= 0 && columns % 2 == 0) {
                        grid.getCellFormatter().setStyleName(0, columns, TABLE_EVEN_ROW);
                        if (overlaping) {
                            text.addStyleName(TABLE_OVERLAPING);
                            overlaping = false;
                        }
                    } else if (columns >= 0 && columns % 2 != 0) {
                        grid.getCellFormatter().setStyleName(0, columns, TABLE_ODD_ROW);
                        if (overlaping) {
                            text.addStyleName(TABLE_OVERLAPING);
                            overlaping = false;
                        }
                    }
                    grid.setWidget(0, columns, text);
                    columns = columns + 1;

                }

            if( new Long(TABLE_SIZE).longValue() - gridTotal >0 && lastProgramPadding || gridTotal ==0 ){

                if(columns > 0){
                    grid.resizeColumns(columns+1);
                }
                if(lastProgramPadding){
                    grid.getCellFormatter().setWidth(0, columns, lastProgramPaddingRatio+"px");
                }
                else{
                    grid.getCellFormatter().setWidth(0, columns, new Long(TABLE_SIZE) - gridTotal+"px");
                }

                grid.getCellFormatter().setHeight(0, columns, CELL_HEIGHT);
                grid.setText(0, columns, "  ");
            }
            columns = 0;
            tableBase.setWidget(rows++, 1, grid);

        }

    }

    private long getSecondsWithStartTime(UiProgramGuideResult result, UiSchedule uiSchedule) {
        return Math.abs(result.getStartDate().getTime() - uiSchedule.getStartTime().getTime()) / MILL_SECONDS;
    }

    private long getSecondsWithEndTime(UiProgramGuideResult result, UiSchedule uiSchedule) {
        return Math.abs(result.getEndDate().getTime() - uiSchedule.getEndTime().getTime()) / MILL_SECONDS;
    }

    private long getRatio(long seconds) {
        return COLUMN_RATIO * (Math.abs(seconds)/60) / 30;
    }

    private long extractLastPaddingRatio(UiProgramGuideResult result, UiSchedule uiSchedule) {
        long borderFactorForLast = getRatio(uiSchedule.getDuration())/COLUMN_RATIO;
        borderFactorForLast = borderFactorForLast == 0?1:borderFactorForLast;
        long lastProgramPaddingRatio = getRatio(getSecondsWithEndTime(result, uiSchedule));
        lastProgramPaddingRatio = lastProgramPaddingRatio - BORDER_SIZE*2 * borderFactorForLast;
        return lastProgramPaddingRatio;
    }


    private void buildTableHeaders(Date startDate, String startTimeKey,String duration){
        Date clonStartDate = new Date();
        clonStartDate.setTime(startDate.getTime());

        int columns = Integer.parseInt(duration);
        columns = columns * 2;

        String timeKey = startTimeKey;

        COLUMN_RATIO = TABLE_SIZE/columns;

        if(Integer.parseInt(startTimeKey) <0){
            timeKey = String.valueOf(24 - Math.abs(Integer.parseInt(startTimeKey)));
        }
        else if(Integer.parseInt(startTimeKey) > 23){
            timeKey = String.valueOf(Math.abs(25 - Integer.parseInt(startTimeKey)) - 1);
        }

        if(header != null){
            header.removeAllRows();
            header = null;
        }
        header = new FlexTable();
        header.setBorderWidth(1);
        header.getRowFormatter().setStyleName(0, TABLE_HEADER_ROW);
        header.getElement().getStyle().setProperty("margin", "0 auto");

        String enumName = TimeEnum.getEnumNameByValue(Integer.parseInt(timeKey));
        int timeValue = TimeFractionEnum.valueOf(enumName).getValue();
        for(int i = 0; i < columns;i++){
            timeValue = timeValue > 47 ? 0 : timeValue;
            HorizontalContainer dateTimePanel = createCellDatePanel(clonStartDate, timeValue++);

            header.setWidget(0, i, dateTimePanel);
            header.getFlexCellFormatter().setWidth(0, i, COLUMN_RATIO+"px");
            header.getCellFormatter().setHeight(0, i, CELL_HEIGHT);

            clonStartDate.setMinutes(clonStartDate.getMinutes() + 30);
        }

    }

    private HorizontalContainer createCellDatePanel(Date startDate, int timeValue) {
        LabelWidget dateLabel = new LabelWidget(DateTimeFormat.getFormat(constants.activityLogDateFormat()).format(startDate));
        dateLabel.setStyleName("epg-table-header-small-text");
        LabelWidget timeLabel = new LabelWidget(TimeFractionEnum.getTextByValue(timeValue).toString());
        timeLabel.setStyleName(TABLE_BOLD_TEXT);

        FlexTable container = new FlexTable();
        container.setCellSpacing(7);
        container.setWidget(0, 0, dateLabel);
        container.setWidget(1, 0, timeLabel);

        HorizontalContainer horiContainer = new HorizontalContainer();
        horiContainer.setWidth("100%");
        horiContainer.setHorizontalAlignment(HorizontalContainer.ALIGN_CENTER);
        horiContainer.add(container);

        return horiContainer;
    }

    private void refresh() {
        /* Clear the previous records, and request for the new records */
        dataProvider.getRecords(new AsyncCallback<UiProgramGuideResult>() {
            @Override
            public void onFailure(Throwable caught) {
                Window.alert(caught.getLocalizedMessage());

            }

            @Override
            public void onSuccess(UiProgramGuideResult result) {
                setData(result);
                int pagingSize = pageFeature.getRecordCount() / pageFeature.getPageSize();
                int pageSize = pageFeature.getRecordCount() % pageFeature.getPageSize() ==0? pagingSize: pagingSize+1;
                if( pageFeature.getPageNumber() < pageSize){

                    buttonVerticalNext.setUrl("cms_epgmgmt_ui/images/GoDownEnabled.png");
                }
                else{
                    buttonVerticalNext.setUrl("cms_epgmgmt_ui/images/GoDownDisabled.png");
                }
                if(pageFeature.getPageNumber() > 1){
                    buttonVerticalPrevious.setUrl("cms_epgmgmt_ui/images/GoUpEnabled.png");
                }
                else{
                    buttonVerticalPrevious.setUrl("cms_epgmgmt_ui/images/GoUpDisabled.png");
                }
                resetVerticalButtonPanelHeight();
            }
        });
    }

    private void setFilter(UiProgramGuideFilter filter){
        if(dataProvider == null){
            this.dataProvider = new ProgramGuideDataProvider( this );
        }

        dataProvider.setUiProgramGuideFilter(filter);

        dataProvider.setBusyNotifier( new IBusyNotifier() {
            @Override
            public void startingToBeBusy() {
                busyIndicator.center();
            }

            @Override
            public void doneBeingBusy() {
                busyIndicator.hide();
            }
        } );

    }

    @Override
    protected void onLoad() {
        super.onLoad();

        resizeHandlerRegistration = Window.addResizeHandler(new ResizeHandler() {
            @Override
            public void onResize(ResizeEvent event) {
                updateTableContainerSize();
            }
        });
    };

    @Override
    protected void onUnload() {
        resizeHandlerRegistration.removeHandler();
        resizeHandlerRegistration = null;
        super.onUnload();
    }
}
