package com.ericsson.cms.epgmgmt.client.programguide;

import java.util.Date;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentMessages;
import com.ericsson.cms.epgmgmt.client.model.UIPartner;
import com.ericsson.cms.epgmgmt.client.model.enumeration.DurationEnum;
import com.ericsson.cms.epgmgmt.client.model.enumeration.PGSortPropertyEnum;
import com.ericsson.cms.epgmgmt.client.model.enumeration.TimeEnum;
import com.ericsson.cms.epgmgmt.client.presenter.ProgramGuideFilterPresenter;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGPartnerService;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGPartnerServiceAsync;
import com.ericsson.cms.epgmgmt.client.utils.StringUtils;
import com.ericsson.cms.epgmgmt.client.widget.HeadendStationSelectorPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.RadioButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedDateBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.StringConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class ProgramGuideFilterView extends Composite implements ProgramGuideFilterPresenter.Display {

    private static final int HORIZ_PANEL_ROW_SPACING = 10;
    //Widgets used in this View
    private TypedDateBoxWidget startDate;
    private final TypedListBoxWidget<String> timeListBox;
    private final TypedListBoxWidget<Long> durationListBox;
    private final TypedListBoxWidget<String> sortBy;
    private final RadioButtonWidget rdbtnAscending;
    private final RadioButtonWidget rdbtnDescending;

    private final EPGComponentConstants constants = (EPGComponentConstants) GWT
            .create(EPGComponentConstants.class);
    private final EPGComponentMessages messages = (EPGComponentMessages) GWT
            .create(EPGComponentMessages.class);

    private static final String DATE_BOX_WIDTH = "75px";
    private static final String STYLE_NAME = "content-EPGPanel";
    private static final String TAB_CONTAINER_STYLE = "epg-tabContainer";

    private final IEPGPartnerServiceAsync partnerService = GWT.create(IEPGPartnerService.class);

    private TypedListBoxWidget<Long> providerListBox;

    private static final Long NONE_SELECTED_VALUE = -1L;
    private static final int LABEL_WIDTH = 60;// NOSONAR

    private final VerticalContainer mainContainer = new VerticalContainer();
    private final TabContainer tabContainer = new TabContainer();
    private final BusyIndicator busyIndicator = new BusyIndicator();

    private final HeadendStationSelectorPanel headendStationSelector;
    private HorizontalContainer firstRowContainer;
    private final FlexTableContainer filterContainer = new FlexTableContainer();

    public ProgramGuideFilterView() {
        mainContainer.setStylePrimaryName(STYLE_NAME);

        busyIndicator.center();

        // Headend and Station Filters
        headendStationSelector = new HeadendStationSelectorPanel();
        headendStationSelector.setHeadendFilterHelpIconTip(messages.programGuideHeadendHelpIconTip());
        headendStationSelector.setStationFilterHelpIconTip(messages.programGuideStationHelpIconTip());
        final long dummyProviderId = 1L;
        headendStationSelector.buildData(dummyProviderId, null, null);
        HorizontalContainer secondRowContainer = new HorizontalContainer();
        secondRowContainer.setSpacing(HORIZ_PANEL_ROW_SPACING);
        secondRowContainer.add(createLabel("", LABEL_WIDTH));
        secondRowContainer.add(createLabel(constants.programGuideHeadend(), LABEL_WIDTH));
        secondRowContainer.add(headendStationSelector.createHeadendHorizontalPanel());

        HorizontalContainer thirdRowContainer = new HorizontalContainer();
        thirdRowContainer.setSpacing(HORIZ_PANEL_ROW_SPACING);
        thirdRowContainer.add(createLabel("", LABEL_WIDTH));
        thirdRowContainer.add(createLabel(constants.programGuideStation(), LABEL_WIDTH));
        thirdRowContainer.add(headendStationSelector.createStationHorizontalPanel());


        HorizontalContainer fouthRowContainer = new HorizontalContainer();
        fouthRowContainer.setSpacing(HORIZ_PANEL_ROW_SPACING);
        // Date Filters
        fouthRowContainer.add(createLabel(constants.programGuideStartDate(), LABEL_WIDTH));
        startDate = new TypedDateBoxWidget(new DateConverter(constants.dateFormat(), constants.dateFormat()));
        setDefaultDate();
        startDate.setWidth(DATE_BOX_WIDTH);
        fouthRowContainer.add(startDate);
        LabelWidget startTimeLabel = new LabelWidget(constants.programGuideStartTime());
        fouthRowContainer.add(startTimeLabel);
        timeListBox = new TypedListBoxWidget<String>(new StringConverter());
        // TODO : move to the presenter
        fillTimeListBox(timeListBox);
        fouthRowContainer.add(timeListBox);
        fouthRowContainer.add(new LabelWidget(constants.programGuideDuration()));
        durationListBox = new TypedListBoxWidget<Long>(new IntegerConverter());
        // TODO: move to the presenter
        fillDurationListBox(durationListBox);
        fouthRowContainer.add(durationListBox);


        HorizontalContainer fifthRowContainer = new HorizontalContainer();
        fifthRowContainer.setSpacing(HORIZ_PANEL_ROW_SPACING);
        fifthRowContainer.add(createLabel(constants.programGuideSortBy(), LABEL_WIDTH));
        sortBy = new TypedListBoxWidget<String>(new StringConverter());
        // TODO: move to the presenter
        fillSortByListBox(sortBy);
        fifthRowContainer.add(sortBy);
        rdbtnAscending = new RadioButtonWidget("ascDesc", constants.programGuideAscending());
        fifthRowContainer.add(rdbtnAscending);
        rdbtnDescending = new RadioButtonWidget("ascDesc", constants.programGuideDescending());
        fifthRowContainer.add(rdbtnDescending);
        rdbtnAscending.setValue(true);

        HorizontalContainer sixthRowContainer = new HorizontalContainer();
        sixthRowContainer.setSpacing(HORIZ_PANEL_ROW_SPACING);
        ButtonWidget showSchedulesButton = new ButtonWidget(constants.programGuideShowSchedules());
        showSchedulesButton.addStyleDependentName(StyleNames.ACTION_BUTTON_STYLE);
        showSchedulesButton.addClickHandler(new ClickHandler(){
            @Override
            public void onClick(ClickEvent event) {
                if (validate()) {
                    String url = "EPGManager.ProgramGuide.GuideData?" + commit();
                    // TODO: Replace to call new window
                    History.newItem(url);
                } else {
                    if (providerListBox.getItemCount() == 0) {
                        Window.alert("No Provider can be selected, Provider is required field");
                    } else {
                        Window.alert("Please select a Provider");
                    }
                }
            }
        });
        sixthRowContainer.add(showSchedulesButton);

        tabContainer.addStyleName(TAB_CONTAINER_STYLE);
        mainContainer.add(tabContainer);

        VerticalContainer tabPanel = new VerticalContainer();
        tabContainer.add(tabPanel, constants.searchProgramGuide());
        tabContainer.selectTab(0);

        loadProviderListBox();
        filterContainer.setWidget(1, 1, firstRowContainer);
        filterContainer.setWidget(2, 1, secondRowContainer);
        filterContainer.setWidget(3, 1, thirdRowContainer); // NOSONAR
        filterContainer.setWidget(4, 1, fouthRowContainer); // NOSONAR
        filterContainer.setWidget(5, 1, fifthRowContainer); // NOSONAR
        filterContainer.setWidget(6, 1, sixthRowContainer); // NOSONAR
        tabPanel.add(filterContainer);

        initWidget(mainContainer);
        busyIndicator.hide();
    }

    public void loadProviderListBox() {
        createProviderListBox();
        firstRowContainer = new HorizontalContainer();
        firstRowContainer.add(createLabel(constants.programGuideProvider(), LABEL_WIDTH));
        firstRowContainer.add(providerListBox);
        firstRowContainer.setSpacing(HORIZ_PANEL_ROW_SPACING);
        filterContainer.setWidget(1, 1, firstRowContainer);
    }

    private void createProviderListBox() {
        providerListBox = new TypedListBoxWidget<Long>(new IntegerConverter());

        providerListBox.addValueChangeHandler(new ValueChangeHandler<Long>() {
            @Override
            public void onValueChange(ValueChangeEvent<Long> event) {
                headendStationSelector.setProviderId(providerListBox.getSelectedItem());
            }
        });

        // fill data to listBox
        partnerService.getProviders(new NeptuneAsyncCallback<List<UIPartner>>() {
            @Override
            public void onNeptuneFailure(Throwable caught) {
                Window.alert("Get ingest tasks failed!! \n " + caught);
            }

            @Override
            public void onNeptuneSuccess(List<UIPartner> result) {
                providerListBox.clear();
                if (result != null && result.size() > 0) {
                    providerListBox.addItem(" ", NONE_SELECTED_VALUE);
                    for (UIPartner t : result) {
                        providerListBox.addItem(t.getName(), t.getId());
                    }
                }
            }
        });
    }

    /**
     * 
     */
    private void setDefaultDate() {
        Date today = new Date();
        String dateString = DateTimeFormat.getFormat(constants.dateFormat()).format(today);
        startDate.setTextValue(dateString);
    }

    private void fillDurationListBox(TypedListBoxWidget<Long> durationListBox) {
        for (DurationEnum dur : DurationEnum.values()) {
            durationListBox.addItem(dur.toString(), dur.getKey());
        }
    }

    private void fillTimeListBox(TypedListBoxWidget<String> timeListBox) {
        for (TimeEnum time : TimeEnum.values()) {
            timeListBox.addItem(time.toString(), Integer.toString(time.getValue()));
        }
    }

    private void fillSortByListBox(TypedListBoxWidget<String> sortBy) {
        for (PGSortPropertyEnum property : PGSortPropertyEnum.values()) {
            sortBy.addItem(property.toString(), property.toString());
        }
    }

    public void reLoadProviderListBox() {
        loadProviderListBox();
    }

    @Override
    public HasClickHandlers getShowScheduleButton() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void setData(List<String> data) {
        // TODO Auto-generated method stub

    }

    @Override
    public Long getDuration() {
        return this.durationListBox.getValue();

    }

    @Override
    public String getHeadEndName() {
        // TODO Auto-generated method stub
        return "";
    }

    @Override
    public String getHeadEndId() {
        // TODO Auto-generated method stub
        return "";
    }

    @Override
    public PGSortPropertyEnum getSort() {
        if (this.sortBy.getValue().equalsIgnoreCase("Call Sign")) {
            return PGSortPropertyEnum.callSign;
        } else if (this.sortBy.getValue().equalsIgnoreCase("Channel Number")) {
            return PGSortPropertyEnum.stationId;
        } else if (this.sortBy.getValue().equalsIgnoreCase("Affiliation")) {
            return PGSortPropertyEnum.affiliation;
        }
        return PGSortPropertyEnum.callSign;
    }

    @Override
    public Date getStartDate() {
        // TODO Auto-generated method stub
        return this.startDate.getDatePicker().getValue();
    }

    @Override
    public String getTime() {
        // TODO Auto-generated method stub
        return this.timeListBox.getItemText(this.timeListBox.getSelectedIndex());

    }

    public String getTimeKey() {
        // TODO Auto-generated method stub
        return this.timeListBox.getValue();
    }

    @Override
    public Boolean isAscending() {
        // TODO Auto-generated method stub
        return this.rdbtnAscending.getValue();
    }


    public String commit() {
        // TODO: Replace with filter string parameters
        StringBuilder urlParams = new StringBuilder();
        urlParams.append("isAscending=").append(this.isAscending());
        urlParams.append("&duration=").append(this.getDuration());
        urlParams.append("&providerId=").append(this.providerListBox.getSelectedItem().longValue());
        urlParams.append("&headendIds=").append(this.getSelectedHeadendIdStr());
        urlParams.append("&headendExclude=").append(headendStationSelector.getHeadendFilterExcludeValue());
        urlParams.append("&stationIds=").append(this.getSelectedStationIdStr());
        urlParams.append("&stationExclude=").append(headendStationSelector.getStationFilterExcludeValue());
        urlParams.append("&sortBy=").append(this.getSort());
        urlParams.append("&startDate=").append(DateTimeFormat.getFormat("yyyy-MM-dd").format(this.getStartDate()));
        urlParams.append("&time=").append(this.getTime());
        urlParams.append("&timeKey=").append(this.getTimeKey());
        return urlParams.toString();
    }

    private String getSelectedHeadendIdStr() {
        List<String> selectedHeadendValueList = headendStationSelector.getHeadendSelectedFilterValuesList();
        if (selectedHeadendValueList == null || selectedHeadendValueList.size() == 0) {
            return "";
        }
        return StringUtils.join(selectedHeadendValueList.toArray(), ",");
    }

    private String getSelectedStationIdStr() {
        List<String> selectedStationValueList = headendStationSelector.getStationSelectedFilterValuesList();
        if (selectedStationValueList == null || selectedStationValueList.size() == 0) {
            return "";
        }
        return StringUtils.join(selectedStationValueList.toArray(), ",");
    }

    private boolean checkProvider() {
        if (this.providerListBox.getSelectedItem() != null
                && this.providerListBox.getSelectedItem() == NONE_SELECTED_VALUE) {
            return false;
        }
        return true;
    }

    private boolean validate(){
        return checkProvider();
    }

    public void setStartDate(TypedDateBoxWidget startDate) {
        this.startDate = startDate;
    }

    public TypedDateBoxWidget getStartDateBoxWidget(){
        return startDate;
    }

    private LabelWidget createLabel(String msg, int width) {
        LabelWidget label = new LabelWidget(msg);
        label.setWidth(width + "px");
        return label;
    }
}
