package com.ericsson.cms.epgmgmt.client.programguide;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class ProgramGuideViewPanel extends Composite {

    private static final String STYLE_NAME = "content-EPGPanel";

    private final EPGComponentConstants constants = (EPGComponentConstants) GWT
            .create(EPGComponentConstants.class);

    private ProgramGuideFilterView programGuideFiltersView;

    // widgets used in this view
    private HeaderPanel header;
    private final VerticalContainer mainContainer;
    public ProgramGuideViewPanel() {

        mainContainer = new VerticalContainer();
        mainContainer.setStylePrimaryName(STYLE_NAME);

        init();
        initWidget(mainContainer);
    }

    private void init() {
        header = new HeaderPanel(constants.programGuide());
        programGuideFiltersView = new ProgramGuideFilterView();

        mainContainer.add(header);
        mainContainer.add(programGuideFiltersView);
        VerticalContainer emptyContainer = new VerticalContainer();
        emptyContainer.setHeight("15px");
        mainContainer.add(emptyContainer);
    }

    public void reLoadFilterPanelProviderList() {
        programGuideFiltersView.reLoadProviderListBox();
    }

    public void reloadProviderListBox() {
        programGuideFiltersView.loadProviderListBox();
    }
}
