package com.ericsson.cms.epgmgmt.client.programguide;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.UiSchedule;
import com.ericsson.cms.epgmgmt.client.model.enumeration.LiveTapeDelayEnum;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.LongBox;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.datepicker.client.DateBox;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;

public class ScheduleDetailsPanel extends Composite {

	private static final String EPG_S_P_TABLE_BORDER_STYLE = "epg-s-p-table-border";
	private static final String HUNDRED_PER = "100%";

	private final EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class);

	// Audio fields
	private CheckBoxWidget chckbxStereo;
	private TextBoxWidget txtbxDolby;
	private CheckBoxWidget chckbxSap;
	// Rating fields
	private TextBoxWidget tvRatingSuggestBox;
	private CheckBoxWidget chckbxDialogRating;
	private CheckBoxWidget chckbxFvRating;
	private CheckBoxWidget chckbxLanguageRating;
	private CheckBoxWidget chckbxSexRating;
	private CheckBoxWidget chckbxViolenceRating;
	// Video fields
	private TextBoxWidget textBoxScheduleLanguage;
	private TypedListBoxWidget<LiveTapeDelayEnum> playModeListBox;
	private TypedTextBoxWidget<Long> longBoxDuration;
	private TextBoxWidget textBoxPremiereFinale;
	private DateBox dateBoxStartTime;
	private LongBox longBoxNoOfParts;
	private LongBox longBoxPartNo;
	private CheckBoxWidget chckbxThreeD;
	private CheckBoxWidget chckbxBlackout;
	private CheckBoxWidget chckbxCableInClassroom;
	private CheckBoxWidget chckbxCc;
	private CheckBoxWidget chckbxDvs;
	private CheckBoxWidget chckbxEnhanced;
	private CheckBoxWidget chckbxHd;
	private CheckBoxWidget chckbxJoinedInProgress;
	private CheckBoxWidget chckbxLetterbox;
	private CheckBoxWidget chckbxRepeat;
	private CheckBoxWidget chckbxRequestRecord;
	private CheckBoxWidget chckbxSubtitled;
	// User data fields
	private TextBoxWidget textBoxUserData1;
	private TextBoxWidget textBoxUserData2;
	private TextBoxWidget textBoxUserData3;
	private TextBoxWidget textBoxUserData4;
	private TextBoxWidget textBoxUserData5;
	private TextBoxWidget textBoxUserData6;
	private TextBoxWidget textBoxUserData7;
	private TextBoxWidget textBoxUserData8;
	private TextBoxWidget textBoxUserData9;
	private TextBoxWidget textBoxUserData10;
	private TextBoxWidget textBoxUserData11;

	public ScheduleDetailsPanel(UiSchedule schedule) {
		ScrollContainer thisPanel = new ScrollContainer();
		
		VerticalPanel mainPanel = new VerticalPanel();
		mainPanel.setSpacing(2);
		
		createDataPanel(mainPanel);
		
		createUserDataPanel(mainPanel);

		FormPanel formPanel = new FormPanel();
		formPanel.setWidget(mainPanel);
		thisPanel.add(formPanel);
		mainPanel.setWidth(HUNDRED_PER);
		
		if (schedule != null) {
			setData(schedule);
		}

		initWidget(thisPanel);
		
		disableFields();
	}

	/**
	 * @param mainPanel
	 */
	private void createUserDataPanel(VerticalPanel mainPanel) {
		VerticalPanel usrDataDisclosurePanel = new VerticalPanel();
		usrDataDisclosurePanel.setSpacing(2);
		usrDataDisclosurePanel.setStyleName(EPG_S_P_TABLE_BORDER_STYLE);
		
		RoundedDisclosureContainer disclosurePanel = new RoundedDisclosureContainer(constants.userDataLabel());
		ScrollPanel scrollPanel = new ScrollPanel(disclosurePanel);
		usrDataDisclosurePanel.add(scrollPanel);
		disclosurePanel.setWidth(HUNDRED_PER);
		disclosurePanel.setOpen(false);
		
		VerticalPanel userDataPanel = new VerticalPanel();
		userDataPanel.setSpacing(2);
		disclosurePanel.setContent(userDataPanel);
		userDataPanel.setWidth(HUNDRED_PER);
		
		Grid grid = new Grid(11, 2);
		userDataPanel.add(grid);
		grid.setWidth("98%");
		
		LabelWidget lblUserData1 = new LabelWidget(constants.userData1Label());
		grid.setWidget(0, 0, lblUserData1);
		
		textBoxUserData1 = new TextBoxWidget();
		grid.setWidget(0, 1, textBoxUserData1);
		textBoxUserData1.setWidth(HUNDRED_PER);
		
		LabelWidget lblUserData2 = new LabelWidget(constants.userData2Label());
		grid.setWidget(1, 0, lblUserData2);
		
		textBoxUserData2 = new TextBoxWidget();
		grid.setWidget(1, 1, textBoxUserData2);
		textBoxUserData2.setWidth(HUNDRED_PER);
		
		LabelWidget lblUserData3 = new LabelWidget(constants.userData3Label());
		grid.setWidget(2, 0, lblUserData3);
		
		textBoxUserData3 = new TextBoxWidget();
		grid.setWidget(2, 1, textBoxUserData3);
		textBoxUserData3.setWidth(HUNDRED_PER);
		
		LabelWidget lblUserData4 = new LabelWidget(constants.userData4Label());
		grid.setWidget(3, 0, lblUserData4);
		
		textBoxUserData4 = new TextBoxWidget();
		grid.setWidget(3, 1, textBoxUserData4);
		textBoxUserData4.setWidth(HUNDRED_PER);
		
		LabelWidget lblUserData5 = new LabelWidget(constants.userData5Label());
		grid.setWidget(4, 0, lblUserData5);
		
		textBoxUserData5 = new TextBoxWidget();
		grid.setWidget(4, 1, textBoxUserData5);
		textBoxUserData5.setWidth(HUNDRED_PER);
		
		LabelWidget lblUserData6 = new LabelWidget(constants.userData6Label());
		grid.setWidget(5, 0, lblUserData6);
		
		textBoxUserData6 = new TextBoxWidget();
		grid.setWidget(5, 1, textBoxUserData6);
		textBoxUserData6.setWidth(HUNDRED_PER);
		
		LabelWidget lblUserData7 = new LabelWidget(constants.userData7Label());
		grid.setWidget(6, 0, lblUserData7);
		
		textBoxUserData7 = new TextBoxWidget();
		grid.setWidget(6, 1, textBoxUserData7);
		textBoxUserData7.setWidth(HUNDRED_PER);
		
		LabelWidget lblUserData8 = new LabelWidget(constants.userData8Label());
		grid.setWidget(7, 0, lblUserData8);
		
		textBoxUserData8 = new TextBoxWidget();
		grid.setWidget(7, 1, textBoxUserData8);
		textBoxUserData8.setWidth(HUNDRED_PER);
		
		LabelWidget lblUserData9 = new LabelWidget(constants.userData9Label());
		grid.setWidget(8, 0, lblUserData9);
		
		textBoxUserData9 = new TextBoxWidget();
		grid.setWidget(8, 1, textBoxUserData9);
		textBoxUserData9.setWidth(HUNDRED_PER);
		
		LabelWidget lblUserData10 = new LabelWidget(constants.userData10Label());
		grid.setWidget(9, 0, lblUserData10);
		
		textBoxUserData10 = new TextBoxWidget();
		grid.setWidget(9, 1, textBoxUserData10);
		textBoxUserData10.setWidth(HUNDRED_PER);
		
		LabelWidget lblUserData11 = new LabelWidget(constants.userData11Label());
		grid.setWidget(10, 0, lblUserData11);
		
		textBoxUserData11 = new TextBoxWidget();
		grid.setWidget(10, 1, textBoxUserData11);
		textBoxUserData11.setWidth(HUNDRED_PER);

		mainPanel.add(usrDataDisclosurePanel);
	}

	/**
	 * @param mainPanel
	 */
	private void createDataPanel(VerticalPanel mainPanel) {
		
		HorizontalPanel dataPanel = new HorizontalPanel();
		dataPanel.setWidth(HUNDRED_PER);
		dataPanel.setSpacing(2);
		
		VerticalPanel audioRatingPanel = new VerticalPanel();
		audioRatingPanel.setSpacing(2);
		dataPanel.add(audioRatingPanel);
		audioRatingPanel.setSize(HUNDRED_PER, HUNDRED_PER);
		
		createAudioPanel(audioRatingPanel);
		
		createRatingsPanel(audioRatingPanel);
		
		createVideoPanel(dataPanel);

		mainPanel.add(dataPanel);
	}

	/**
	 * @param dataPanel
	 */
	private void createVideoPanel(HorizontalPanel dataPanel) {
		VerticalPanel videoPanel = new VerticalPanel();
		videoPanel.setSpacing(2);
		videoPanel.setStyleName(EPG_S_P_TABLE_BORDER_STYLE);
		dataPanel.add(videoPanel);
		
		EPGHeaderPanel lblVideo = new EPGHeaderPanel(constants.videoLabel());
		videoPanel.add(lblVideo);
		
		FlexTable videoFlexTable = new FlexTable();
		videoPanel.add(videoFlexTable);
		videoFlexTable.setWidth(HUNDRED_PER);
		
		LabelWidget lblScheduleLanguage = new LabelWidget(constants.scheduleLanguage());
		videoFlexTable.setWidget(0, 0, lblScheduleLanguage);
		
		textBoxScheduleLanguage = new TextBoxWidget();
		videoFlexTable.setWidget(0, 1, textBoxScheduleLanguage);
		
		VerticalPanel playModeVerticalPanel = new VerticalPanel();
		videoFlexTable.setWidget(0, 2, playModeVerticalPanel);
		playModeVerticalPanel.setHeight(HUNDRED_PER);
		videoFlexTable.getFlexCellFormatter().setRowSpan(0, 2, 2);
		playModeVerticalPanel.setBorderWidth(1);
		
		LabelWidget lblPlayMode = new LabelWidget(constants.playMode());
		playModeVerticalPanel.add(lblPlayMode);
		
		playModeListBox = new TypedListBoxWidget<LiveTapeDelayEnum>(null);
		for (LiveTapeDelayEnum mode : LiveTapeDelayEnum.values()) {
			playModeListBox.addItem(mode.toString(), mode);
		}
		playModeVerticalPanel.add(playModeListBox);
		
		LabelWidget lblDuration = new LabelWidget(constants.programGuideDuration());
		videoFlexTable.setWidget(1, 0, lblDuration);
		
		HorizontalPanel horizontalPanel3 = new HorizontalPanel();
		videoFlexTable.setWidget(1, 1, horizontalPanel3);
		horizontalPanel3.setSpacing(2);
		horizontalPanel3.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		
		longBoxDuration = new TypedTextBoxWidget<Long>(new IntegerConverter());
		horizontalPanel3.add(longBoxDuration);
		longBoxDuration.setWidth("100px");
		
		LabelWidget lblSeconds = new LabelWidget(constants.seconds());
		horizontalPanel3.add(lblSeconds);
		
		HorizontalPanel horizontalPanel4 = new HorizontalPanel();
		videoFlexTable.setWidget(2, 0, horizontalPanel4);
		horizontalPanel4.setSpacing(2);
		horizontalPanel4.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		
		LabelWidget lblPremiereFinale = new LabelWidget(constants.premiereFinale());
		horizontalPanel4.add(lblPremiereFinale);
		
		textBoxPremiereFinale = new TextBoxWidget();
		videoFlexTable.setWidget(2, 1, textBoxPremiereFinale);
		
		HorizontalPanel horizontalPanel5 = new HorizontalPanel();
		videoFlexTable.setWidget(3, 0, horizontalPanel5);
		horizontalPanel5.setSpacing(2);
		horizontalPanel5.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		
		LabelWidget lblStartTime = new LabelWidget(constants.startTime());
		horizontalPanel5.add(lblStartTime);
		
		dateBoxStartTime = new DateBox();
		videoFlexTable.setWidget(3, 1, dateBoxStartTime);
		
		HorizontalPanel horizontalPanel6 = new HorizontalPanel();
		horizontalPanel6.setWidth(HUNDRED_PER);
		horizontalPanel6.setSpacing(2);
		horizontalPanel6.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		videoPanel.add(horizontalPanel6);
		
		LabelWidget lblNumberOfParts = new LabelWidget(constants.numberOfParts());
		horizontalPanel6.add(lblNumberOfParts);
		
		longBoxNoOfParts = new LongBox();
		horizontalPanel6.add(longBoxNoOfParts);
		longBoxNoOfParts.setWidth("50px");
		
		LabelWidget lblPartNumber = new LabelWidget(constants.partNumber());
		horizontalPanel6.add(lblPartNumber);
		
		longBoxPartNo = new LongBox();
		horizontalPanel6.add(longBoxPartNo);
		longBoxPartNo.setWidth("50px");
		
		Grid grid = new Grid(4, 3);
		videoPanel.add(grid);
		grid.setWidth(HUNDRED_PER);
		
		chckbxThreeD = new CheckBoxWidget(constants.threeD());
		grid.setWidget(0, 0, chckbxThreeD);
		
		chckbxBlackout = new CheckBoxWidget(constants.blackout());
		grid.setWidget(0, 1, chckbxBlackout);
		
		chckbxCableInClassroom = new CheckBoxWidget(constants.cableInClassroom());
		grid.setWidget(0, 2, chckbxCableInClassroom);
		
		chckbxCc = new CheckBoxWidget(constants.cc());
		grid.setWidget(1, 0, chckbxCc);
		
		chckbxDvs = new CheckBoxWidget(constants.dvs());
		grid.setWidget(1, 1, chckbxDvs);
		
		chckbxEnhanced = new CheckBoxWidget(constants.enhanced());
		grid.setWidget(1, 2, chckbxEnhanced);
		
		chckbxHd = new CheckBoxWidget(constants.hd());
		grid.setWidget(2, 0, chckbxHd);
		
		chckbxJoinedInProgress = new CheckBoxWidget(constants.joinedInProgress());
		grid.setWidget(2, 1, chckbxJoinedInProgress);
		
		chckbxLetterbox = new CheckBoxWidget(constants.letterBox());
		grid.setWidget(2, 2, chckbxLetterbox);
		
		chckbxRepeat = new CheckBoxWidget(constants.repeat());
		grid.setWidget(3, 0, chckbxRepeat);
		
		chckbxRequestRecord = new CheckBoxWidget(constants.requestRecord());
		grid.setWidget(3, 1, chckbxRequestRecord);
		
		chckbxSubtitled = new CheckBoxWidget(constants.subtitled());
		grid.setWidget(3, 2, chckbxSubtitled);
	}

	/**
	 * @param audioRatingPanel
	 */
	private void createRatingsPanel(VerticalPanel audioRatingPanel) {
		VerticalPanel ratingPanel = new VerticalPanel();
		ratingPanel.setSpacing(2);
		ratingPanel.setStyleName(EPG_S_P_TABLE_BORDER_STYLE);
		audioRatingPanel.add(ratingPanel);
		
		EPGHeaderPanel lblRating = new EPGHeaderPanel(constants.ratingLabel());
		ratingPanel.add(lblRating);
		
		HorizontalPanel horizontalPanel1 = new HorizontalPanel();
		horizontalPanel1.setWidth(HUNDRED_PER);
		horizontalPanel1.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		horizontalPanel1.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
		ratingPanel.add(horizontalPanel1);
		
		LabelWidget lblTvRating = new LabelWidget(constants.tvRating());
		horizontalPanel1.add(lblTvRating);
		
		tvRatingSuggestBox = new TextBoxWidget();
		horizontalPanel1.add(tvRatingSuggestBox);
		tvRatingSuggestBox.setWidth("125px");
		
		chckbxDialogRating = new CheckBoxWidget(constants.dialogRating());
		ratingPanel.add(chckbxDialogRating);
		
		chckbxFvRating = new CheckBoxWidget(constants.fvRating());
		ratingPanel.add(chckbxFvRating);
		
		chckbxLanguageRating = new CheckBoxWidget(constants.languageRating());
		ratingPanel.add(chckbxLanguageRating);
		
		chckbxSexRating = new CheckBoxWidget(constants.sexRating());
		ratingPanel.add(chckbxSexRating);

		chckbxViolenceRating = new CheckBoxWidget(constants.violenceRating());
		ratingPanel.add(chckbxViolenceRating);
	}

	/**
	 * @param audioRatingPanel
	 */
	private void createAudioPanel(VerticalPanel audioRatingPanel) {
		VerticalPanel audioPanel = new VerticalPanel();
		audioPanel.setSpacing(2);
		audioPanel.setStyleName(EPG_S_P_TABLE_BORDER_STYLE);
		audioRatingPanel.add(audioPanel);
		
		EPGHeaderPanel audioLabel = new EPGHeaderPanel(constants.audioLabel());
		audioPanel.add(audioLabel);
		
		Grid grid = new Grid(2, 2);
		audioPanel.add(grid);
		grid.setWidth(HUNDRED_PER);
		
		chckbxStereo = new CheckBoxWidget(constants.stereo());
		grid.setWidget(0, 0, chckbxStereo);
		
		HorizontalPanel horizontalPanel = new HorizontalPanel();
		grid.setWidget(0, 1, horizontalPanel);
		horizontalPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		horizontalPanel.setSpacing(3);
		
		LabelWidget lblDolby = new LabelWidget(constants.dolby());
		horizontalPanel.add(lblDolby);
		
		txtbxDolby = new TextBoxWidget();
		horizontalPanel.add(txtbxDolby);
		txtbxDolby.setWidth("100px");
		
		chckbxSap = new CheckBoxWidget(constants.sap());
		grid.setWidget(1, 0, chckbxSap);
	}
	
	/**
	 * @param schedule
	 */
	private void setData(UiSchedule schedule) {
		// Get the object and set the data against the widgets...
		// Audio fields
		if (schedule.getStereo() != null) {
			chckbxStereo.setValue(schedule.getStereo());
		}
		txtbxDolby.setValue(schedule.getDolby());
		if (schedule.getSap() != null) {
			chckbxSap.setValue(schedule.getSap());
		}
		// Rating fields
		tvRatingSuggestBox.setValue(schedule.getTvRating());
		if (schedule.getDialogRating() != null) {
			chckbxDialogRating.setValue(schedule.getDialogRating());
		}
		if (schedule.getFvRating() != null) {
			chckbxFvRating.setValue(schedule.getFvRating());
		}
		if (schedule.getLanguageRating() != null) {
			chckbxLanguageRating.setValue(schedule.getLanguageRating());
		}
		if (schedule.getSexRating() != null) {
			chckbxSexRating.setValue(schedule.getSexRating());
		}
		if (schedule.getViolenceRating() != null) {
			chckbxViolenceRating.setValue(schedule.getViolenceRating());
		}
		// Video fields
		textBoxScheduleLanguage.setValue(schedule.getScheduleLanguage());
		if (schedule.getLiveTapeDelay() != null) {
			playModeListBox.setSelectedItem(schedule.getLiveTapeDelay());
		}
		longBoxDuration.setValue(schedule.getDuration());
		textBoxPremiereFinale.setValue(schedule.getPremiereFinale());
		dateBoxStartTime.setValue(schedule.getStartTime());
		longBoxNoOfParts.setValue(schedule.getNoOfParts());
		longBoxPartNo.setValue(schedule.getPartNumber());
		if (schedule.getThreeD() != null) {
			chckbxThreeD.setValue(schedule.getThreeD());
		}
		if (schedule.getBlackout() != null) {
			chckbxBlackout.setValue(schedule.getBlackout());
		}
		if (schedule.getCableInClassroom() != null) {
			chckbxCableInClassroom.setValue(schedule.getCableInClassroom());
		}
		if (schedule.getCc() != null) {
			chckbxCc.setValue(schedule.getCc());
		}
		if (schedule.getDvs() != null) {
			chckbxDvs.setValue(schedule.getDvs());
		}
		if (schedule.getEnhanced() != null) {
			chckbxEnhanced.setValue(schedule.getEnhanced());
		}
		if (schedule.getHdTv() != null) {
			chckbxHd.setValue(schedule.getHdTv());
		}
		if (schedule.getJoinedInProgress() != null) {
			chckbxJoinedInProgress.setValue(schedule.getJoinedInProgress());
		}
		if (schedule.getLetterbox() != null) {
			chckbxLetterbox.setValue(schedule.getLetterbox());
		}
		if (schedule.getRepeat() != null) {
			chckbxRepeat.setValue(schedule.getRepeat());
		}
		if (schedule.getRequestRecord() != null) {
			chckbxRequestRecord.setValue(schedule.getRequestRecord());
		}
		if (schedule.getSubtitled() != null) {
			chckbxSubtitled.setValue(schedule.getSubtitled());
		}
		// User data fields
		textBoxUserData1.setValue(schedule.getUserData1());
		textBoxUserData2.setValue(schedule.getUserData2());
		textBoxUserData3.setValue(schedule.getUserData3());
		textBoxUserData4.setValue(schedule.getUserData4());
		textBoxUserData5.setValue(schedule.getUserData5());
		textBoxUserData6.setValue(schedule.getUserData6());
		textBoxUserData7.setValue(schedule.getUserData7());
		textBoxUserData8.setValue(schedule.getUserData8());
		textBoxUserData9.setValue(schedule.getUserData9());
		textBoxUserData10.setValue(schedule.getUserData10());
		textBoxUserData11.setValue(schedule.getUserData11());

	}
	
	private void disableFields() {
		boolean editable = false;
		// Audio fields
		chckbxStereo.setEnabled(editable);
		txtbxDolby.setEnabled(editable);
		chckbxSap.setEnabled(editable);
		// Rating fields
		tvRatingSuggestBox.setEnabled(editable);
		chckbxDialogRating.setEnabled(editable);
		chckbxFvRating.setEnabled(editable);
		chckbxLanguageRating.setEnabled(editable);
		chckbxSexRating.setEnabled(editable);
		chckbxViolenceRating.setEnabled(editable);
		// Video fields
		textBoxScheduleLanguage.setEnabled(editable);
		playModeListBox.setEnabled(editable);
		longBoxDuration.setEnabled(editable);
		textBoxPremiereFinale.setEnabled(editable);
		dateBoxStartTime.setEnabled(editable);
		longBoxNoOfParts.setEnabled(editable);
		longBoxPartNo.setEnabled(editable);
		chckbxThreeD.setEnabled(editable);
		chckbxBlackout.setEnabled(editable);
		chckbxCableInClassroom.setEnabled(editable);
		chckbxCc.setEnabled(editable);
		chckbxDvs.setEnabled(editable);
		chckbxEnhanced.setEnabled(editable);
		chckbxHd.setEnabled(editable);
		chckbxJoinedInProgress.setEnabled(editable);
		chckbxLetterbox.setEnabled(editable);
		chckbxRepeat.setEnabled(editable);
		chckbxRequestRecord.setEnabled(editable);
		chckbxSubtitled.setEnabled(editable);
		// User data fields
		textBoxUserData1.setEnabled(editable);
		textBoxUserData2.setEnabled(editable);
		textBoxUserData3.setEnabled(editable);
		textBoxUserData4.setEnabled(editable);
		textBoxUserData5.setEnabled(editable);
		textBoxUserData6.setEnabled(editable);
		textBoxUserData7.setEnabled(editable);
		textBoxUserData8.setEnabled(editable);
		textBoxUserData9.setEnabled(editable);
		textBoxUserData10.setEnabled(editable);
		textBoxUserData11.setEnabled(editable);

	}

}
