/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.programguide;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.UiSchedule;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author amit.r.seth
 *
 */
public class ScheduleDetailsTabbedPanel extends Composite {

    private static final int CMS_HEADER_MENU_SIZE_PX = 115;
    private static final String TAB_CONTAINER_STYLE = "epg-tabContainer";
    private static final String STYLE_NAME = "content-EPGPanel";
    private static final String BUTTON_PANEL_STYLE = "epg-tabContainer-buttonPanel";

    private VerticalContainer mainContainer;
    private HeaderPanel header;

    private final TabContainer tabContainer = new TabContainer();

    private final List<Composite> tabs = new ArrayList<Composite>();

    private final MessageArea messageArea = new MessageArea();
    private final HorizontalContainer buttonPanel = new HorizontalContainer();

    private HandlerRegistration resizeHandlerRegistration;

    private final EPGComponentConstants constants = (EPGComponentConstants) GWT
            .create(EPGComponentConstants.class);

    public ScheduleDetailsTabbedPanel(UiSchedule schedule, SimpleContainer widgetToReplace, ProgramGuideDisplayPanel programGuideDisplayPanel) {
        initWidgets(schedule, widgetToReplace, programGuideDisplayPanel);
        Scheduler.get().scheduleDeferred(new ScheduledCommand() {
            @Override
            public void execute() {
                updateTableContainerSize(getSelectedTab());
            }
        });
    }

    private void initWidgets(UiSchedule schedule, SimpleContainer widgetToReplace, ProgramGuideDisplayPanel programGuideDisplayPanel) {
        mainContainer = new VerticalContainer();
        mainContainer.setStylePrimaryName(STYLE_NAME);
        this.initWidget(mainContainer);

        header = new HeaderPanel(constants.scheduleWithProgLabel());

        createTabs(schedule);
        createButtonPanel(widgetToReplace, programGuideDisplayPanel);

        // Add widgets to the main container
        mainContainer.add(header);
        messageArea.reset();
        mainContainer.add(messageArea);
        mainContainer.add(tabContainer);
        mainContainer.add(buttonPanel);

    }

    /**
     * @param schedule
     * 
     */
    private void createTabs(UiSchedule schedule) {
        tabContainer.addStyleName(TAB_CONTAINER_STYLE);

        tabContainer.addSelectionHandler(new SelectionHandler<Integer>() {
            @Override
            public void onSelection(SelectionEvent<Integer> event) {
                if (tabs.size() > 0) {
                    updateTableContainerSize(event.getSelectedItem());
                }
            }
        });

        ScheduleDetailsPanel schDetails = new ScheduleDetailsPanel(schedule);
        tabContainer.add(schDetails, constants.scheduleLabel());
        tabs.add(schDetails);

        ProgramDetailsPanel progDetails = new ProgramDetailsPanel(schedule.getUiProgram());
        tabContainer.add(progDetails, constants.programLabel());
        tabs.add(progDetails);

        tabContainer.selectTab(0);
    }

    private void createButtonPanel(final SimpleContainer widgetToReplace, final ProgramGuideDisplayPanel programGuideDisplayPanel) {
        buttonPanel.setStyleName(BUTTON_PANEL_STYLE);

        // cancel button
        ButtonWidget cancelButton = new ButtonWidget(constants.buttonLabelCancel());
        cancelButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
        cancelButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                widgetToReplace.setWidget(programGuideDisplayPanel);
            }
        });
        buttonPanel.add(cancelButton);

        if (cancelButton != null) {
            buttonPanel.setCellWidth(cancelButton, "99%");
        }
    }

    private void updateTableContainerSize(int selected) {
        if(selected >= 0){
            int height = Window.getClientHeight()
                    - CMS_HEADER_MENU_SIZE_PX
                    - header.getOffsetHeight()
                    - messageArea.getOffsetHeight()
                    - tabContainer.getTabBar().getOffsetHeight()
                    - buttonPanel.getOffsetHeight()
                    - 14;	//adjustment for borders and spacing at the bottom
            tabs.get(selected).setHeight(height + "px");
        }

    }

    protected int getSelectedTab() {
        return tabContainer.getTabBar().getSelectedTab();
    }

    @Override
    protected void onLoad() {
        super.onLoad();

        resizeHandlerRegistration = Window.addResizeHandler(new ResizeHandler() {
            @Override
            public void onResize(ResizeEvent event) {
                updateTableContainerSize(getSelectedTab());
            }
        });
    };

    @Override
    protected void onUnload() {
        resizeHandlerRegistration.removeHandler();
        resizeHandlerRegistration = null;
        super.onUnload();
    }
}
