/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.programguide;

import com.ericsson.cms.epgmgmt.client.model.UiSchedule;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.DateTimeFormat.PredefinedFormat;
import com.google.gwt.user.client.ui.Label;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

/**
 * @author amit.r.seth
 *
 */
class ScheduleDispWidget extends Label {

    private static final String PG_CELL_DATA_LINK = "epg-table-data-link";
    private static final String PG_CELL_ELLIPSIS = "epg-programguide-ellipsis-text";
    private static final boolean DEBUG_ON = false;

    private final UiSchedule schedule;

    /**
     * @param schedule
     * @param gridRatio
     * @param programGuideDisplayPanel
     */
    public ScheduleDispWidget(final UiSchedule schedule, Long gridRatio, final SimpleContainer widgetToReplace, final ProgramGuideDisplayPanel programGuideDisplayPanel) {
        super(schedule.getUiProgram().getTitle());
        this.schedule = schedule;
        Long ratio = gridRatio < 0 ? 0 : gridRatio;

        this.setWidth(ratio + "px");
        this.addStyleDependentName(PG_CELL_ELLIPSIS);
        this.addStyleName(PG_CELL_DATA_LINK);
        updateText(ratio);
        super.addClickHandler(new ClickHandler() {

            @Override
            public void onClick(ClickEvent event) {
                widgetToReplace.setWidget(new ScheduleDetailsTabbedPanel(schedule, widgetToReplace, programGuideDisplayPanel));
            }
        });
    }

    /**
     * @param gridRatio
     */
    private void updateText(Long gridRatio) {
        String toolTip = schedule.getUiProgram().getTitle()
                + "\nStart: "
                + DateTimeFormat.getFormat(PredefinedFormat.HOUR24_MINUTE).format(schedule.getStartTime())
                + "\nEnd: "
                + DateTimeFormat.getFormat(PredefinedFormat.HOUR24_MINUTE).format(schedule.getEndTime())
                + "\nDuration: "
                + schedule.getDuration();
        if (DEBUG_ON) {
            toolTip	+= " - " + gridRatio;
        }
        this.setTitle(toolTip);
    }

}
