package com.ericsson.cms.epgmgmt.client.provider;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.EPGFormContainer;
import com.ericsson.cms.epgmgmt.client.model.UIEndPoint;
import com.ericsson.cms.epgmgmt.client.model.UIPartner;
import com.ericsson.cms.epgmgmt.client.model.UIProvider;
import com.ericsson.cms.epgmgmt.client.model.UITask;
import com.ericsson.cms.epgmgmt.client.model.enumeration.JobType;
import com.ericsson.cms.epgmgmt.client.model.enumeration.PartnerType;
import com.ericsson.cms.epgmgmt.client.partner.AbstractPartnerCreateTab;
import com.ericsson.cms.epgmgmt.client.partner.AbstractPartnerTabContainer;
import com.ericsson.cms.epgmgmt.client.partner.PartnerBasicSettingForm;
import com.ericsson.cms.epgmgmt.client.task.TaskBasicSettingForm;
import com.ericsson.cms.epgmgmt.client.task.TaskTriggerSettingForm;
import com.ericsson.cms.epgmgmt.client.widget.EPGNoIconRoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class ProviderCreateTab extends AbstractPartnerCreateTab {

    private EPGNoIconRoundedDisclosureContainer basicInfoDisclosure;
    private EPGNoIconRoundedDisclosureContainer taskDisclosure;
    private EPGNoIconRoundedDisclosureContainer taskBasicDisclosure;
    private PartnerBasicSettingForm basicInfoForm;
    private TaskBasicSettingForm taskBasicForm;
    private TaskTriggerSettingForm triggerForm;
    private long existingProviderId = 0L;
    private long existingEndPointID = 0L;
    private Long existingFormatId = 0L;
    private static final String STYLE_DISCLOSURE_CONTAINER = "epg-basicTab-disclosureContainer";
    private UITask taskModel;
    private UIProvider providerModel;

    public ProviderCreateTab(AbstractPartnerTabContainer parentTabContainer) {
        super(parentTabContainer);
        NeptuneApplication.getApplication().getSecurity();
        providerModel = createEmptyProviderModel();
        taskModel = createEmptyTaskModel();
        
        initForm();
        updateScrollPanelSize();
    }

    @Override
    protected void initForm() {
        initBasicDisclosure();
        initTaskDisclosure();
        
        super.initForm();
    }

    private void initBasicDisclosure() {
        basicInfoForm = new PartnerBasicSettingForm(new UIProvider());
        basicInfoDisclosure = new EPGNoIconRoundedDisclosureContainer(new LabelWidget(constants.basicTab()), true);
        basicInfoDisclosure.setWidth(A_HUNDRED_PERCENT);
        basicInfoDisclosure.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        basicInfoDisclosure.setContent(basicInfoForm);
        mainPanel.add(basicInfoDisclosure);
    }

    private void initTaskDisclosure() {
        taskDisclosure = new EPGNoIconRoundedDisclosureContainer(new LabelWidget(constants.providerDefaultTaskTitle()), true);
        taskDisclosure.setWidth(A_HUNDRED_PERCENT);
        taskDisclosure.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        VerticalContainer vc = new VerticalContainer();
        vc.setWidth(A_HUNDRED_PERCENT);

        initTaskBasicDisclosure(vc);
        initTriggerDisclosure(vc);

        taskDisclosure.setContent(vc);
        mainPanel.add(taskDisclosure);
    }


    private void initTaskBasicDisclosure(VerticalContainer vc) {
        taskBasicForm = new TaskBasicSettingForm(JobType.INGEST, taskModel);

        taskBasicDisclosure = new EPGNoIconRoundedDisclosureContainer(new LabelWidget(constants.basicTab()), true);
        taskBasicDisclosure.setWidth(A_HUNDRED_PERCENT);
        taskBasicDisclosure.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        taskBasicDisclosure.setContent(taskBasicForm);

        vc.add(taskBasicDisclosure);
    }

    private void initTriggerDisclosure(VerticalContainer vc) {
        triggerForm = new TaskTriggerSettingForm(JobType.INGEST, taskModel);

        EPGNoIconRoundedDisclosureContainer triggerInfoDisclosure = new EPGNoIconRoundedDisclosureContainer(new LabelWidget(constants.triggerSetting()), true);
        triggerInfoDisclosure.setWidth(A_HUNDRED_PERCENT);
        triggerInfoDisclosure.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        triggerInfoDisclosure.setContent(triggerForm);
        vc.add(triggerInfoDisclosure);
    }

    @Override
    public UIPartner populatePartner() {
        return basicInfoForm.populateModel();
    }

    @Override
    public UITask populateTask() {
        triggerForm.populateModel();
        taskBasicForm.populateModel();
        return taskModel;
    }

    @Override
    public String getName() {
        return "CreateProvider";
    }

    @Override
    public void setSelected(boolean selected) {
        if (!selected) {
            return;
        }

        messageArea.reset();
    }

    @Override
    public String getDisplayName() {
        return constants.createNewProviderLabel();
    }

    @Override
    public void clear() {
        if (basicInfoForm != null) {
            basicInfoForm.clearAllValidationErrors();
        }
        if (taskBasicForm != null) {
            taskBasicForm.clearAllValidationErrors();
        }
    }

    public long getExistingEndPointID() {
        return existingEndPointID;
    }

    public void setExistingEndPointID(long existingEndPointID) {
        this.existingEndPointID = existingEndPointID;
    }

    public long getExistingProviderId() {
        return existingProviderId;
    }

    public void setExistingProviderId(long existingProviderId) {
        this.existingProviderId = existingProviderId;
    }

    public Long getExistingFormatId() {
        return existingFormatId;
    }

    public void setExistingFormatId(Long existingFormatId) {
        this.existingFormatId = existingFormatId;
    }

    @Override
    public List<String> validate() {

        List<String> validationMessages = new ArrayList<String>();

        validationMessages.addAll(basicInfoForm.validateField());
        validationMessages.addAll(taskBasicForm.validateField());
        validationMessages.addAll(triggerForm.validateField());

        if (!basicInfoForm.getIsEnabled().getValue() && taskBasicForm.getIsTaskEnabled().getValue()) {
            validationMessages.add(constantsMsg.enableTaskWhilePartnerIsDisabled());
        }

        return validationMessages;
    }

    public EPGFormContainer getFormContainer() {
        return basicInfoForm;
    }

    @Override
    public void reload() {
        providerModel = createEmptyProviderModel();
        taskModel = createEmptyTaskModel();
        messageArea.reset();
        loadProvider(providerModel);
        loadTask(taskModel);
        updateScrollPanelSize();
    }

    private void loadProvider(UIProvider model) {
        basicInfoForm.loadModel(model);
    }

    private void loadTask(UITask model) {
        taskBasicForm.loadModel(model);
        triggerForm.loadModel(model);
    }

    private UIProvider createEmptyProviderModel() {
        UIProvider p = new UIProvider();
        p.setPartnerType(PartnerType.Provider);
        p.setActive(true);
        return p;
    }

    private UITask createEmptyTaskModel() {
        UITask t = new UITask();
        t.setType(JobType.INGEST.toString());
        t.setEnabled(true);
        UIEndPoint ep = new UIEndPoint();
        t.setEndpoint(ep);
        return t;
    }
}
