package com.ericsson.cms.epgmgmt.client.provider;

import java.util.List;

import com.ericsson.cms.epgmgmt.client.model.PartnerConstantUtils;
import com.ericsson.cms.epgmgmt.client.model.ProviderTaskStatus;
import com.ericsson.cms.epgmgmt.client.model.SubscribersAndExportTaks;
import com.ericsson.cms.epgmgmt.client.model.UIConstants;
import com.ericsson.cms.epgmgmt.client.model.UIPartner;
import com.ericsson.cms.epgmgmt.client.model.UIProvider;
import com.ericsson.cms.epgmgmt.client.model.UITask;
import com.ericsson.cms.epgmgmt.client.partner.AbstractPartnerCreateTab;
import com.ericsson.cms.epgmgmt.client.partner.AbstractPartnerTabContainer;
import com.ericsson.cms.epgmgmt.client.partner.PartnerBasicTab;
import com.ericsson.cms.epgmgmt.client.partner.PartnerListPanel;
import com.ericsson.cms.epgmgmt.client.task.AbstractTaskTab;
import com.ericsson.cms.epgmgmt.client.task.IngestTaskTab;
import com.ericsson.cms.epgmgmt.client.utils.DefaultAsyncCallback;
import com.ericsson.cms.epgmgmt.client.utils.MessageAreaUtils;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;

public class ProviderTabContainer extends AbstractPartnerTabContainer {

    public ProviderTabContainer(PartnerListPanel partnerList, MessageArea messageArea) {
        super(partnerList, messageArea);
    }

    @Override
    protected String getAnchorName() {
        return UIConstants.EPG_MANAGER + "." + UIConstants.EPG_PROVIDER;
    }

    @Override
    protected AbstractPartnerCreateTab getCreateTab() {
        return new ProviderCreateTab(this);
    }

    @Override
    protected AbstractTaskTab getTaskTab(UIPartner partner) {
        return new IngestTaskTab(partner);
    }

    @Override
    protected UIPartner getEmptyPartner() {
        return new UIProvider();
    }

    @Override
    protected void onDelete() {
        final boolean checkSubscribers = true;
        final boolean checkExportTasks = true;
        partnerService.getSubscribersAndExportTasks(getPartnerId(), checkSubscribers, checkExportTasks, new DefaultAsyncCallback<SubscribersAndExportTaks>(null) {
            @Override
            public void onNeptuneSuccess(SubscribersAndExportTaks subscribersAndExportTaks){
                List<UITask> subscribers = subscribersAndExportTaks.getSubscribers();
                List<UITask> exportTasks = subscribersAndExportTaks.getExportTask();

                String info = "";
                if(subscribers.size() != 0) {
                    String subscribersStr = tasks2String(subscribers);
                    info = constantsMsg.subscriberTasksMessage("provider", subscribersStr) + "\n\n";
                }
                if(exportTasks.size() !=0) {
                    String exportTasksStr = tasks2String(subscribers);
                    info += constantsMsg.partnerWithExportTasksMessage(exportTasksStr) + "\n\n";
                }
                info += constantsMsg.deletePartnerConfirmation(PartnerConstantUtils.getPartnerType(partner), partner.getName());

                boolean deleteConfirm = Window.confirm(info);
                if(!deleteConfirm) {
                    return;
                }

                busyIndicator.center();

                partnerService.removePartnerById(getPartnerId(), new NeptuneAsyncCallback<Void>() {
                    @Override
                    public void onNeptuneFailure(Throwable caught) {
                        MessageAreaUtils.handleException(caught, messageArea);
                        busyIndicator.hide();
                    }

                    @Override
                    public void onNeptuneSuccess(Void result) {
                        partner = getEmptyPartner();
                        updateTab.getLogTab().refreshData(partner);
                        partnerList.selectFirst(false);
                        busyIndicator.hide();
                    }
                });
            }
        });
    }

    @Override
    protected void onCommitUpdate() {
        // before updating need to check route status and give confirmation message to the user
        busyIndicator.center();
        partnerService.getPartner(partnerId, new AsyncCallback<UIPartner>() {
            @Override
            public void onFailure(Throwable caught) {
            }

            @Override
            public void onSuccess(final UIPartner partnerInDb) {
                boolean isActiveOld = partnerInDb.isActive();
                final PartnerBasicTab partnerBasicTab = updateTab.getBasicTab();
                partner = partnerBasicTab.populatePartner();
                boolean isActiveNew = partner.isActive();
                final boolean active2Deactive = isActiveOld && !isActiveNew;

                partnerService.checkProviderTaskStatus(partnerId, new NeptuneAsyncCallback<ProviderTaskStatus>() {
                    @Override
                    public void onNeptuneFailure(Throwable caught) {
                        MessageAreaUtils.handleException(caught, messageArea);
                        busyIndicator.hide();
                    }

                    @Override
                    public void onNeptuneSuccess(ProviderTaskStatus result) {
                        busyIndicator.hide();

                        boolean hasJobRunning = result.isHasTaskRunning();
                        List<UITask> registedPublisherTasks = result.getRegistedPublisherTasks();
                        String warningInfo = "";
                        boolean needConfirm = false;
                        if(hasJobRunning) {
                            warningInfo = saveWarningMessage();
                            needConfirm = true;
                        }

                        if(active2Deactive && !registedPublisherTasks.isEmpty()) {
                            String exportTasksStr = tasks2String(registedPublisherTasks);
                            warningInfo += constantsMsg.partnerWithExportTasksMessage(exportTasksStr);
                            needConfirm = true;
                        }
                        warningInfo += "Continue?";

                        boolean updateConfirmed = needConfirm? Window.confirm(warningInfo): true;
                        if (updateConfirmed) {
                            busyIndicator.center();
                            partnerService.update(partner, new NeptuneAsyncCallback<Void>() {
                                @Override
                                public void onNeptuneFailure(Throwable caught) {
                                    MessageAreaUtils.handleException(caught, messageArea);
                                    updateTabSize();
                                    busyIndicator.hide();
                                }

                                @Override
                                public void onNeptuneSuccess(Void result) {
                                    setConfirmationMessage(constantsMsg.partnerUpdatedSuccess(PartnerConstantUtils.getPartnerType(partner)));
                                    partnerList.reload(partner.getId(), null);
                                    updateTab.getTaskTab().reload();
                                    busyIndicator.hide();
                                    updateTab.saveSuccess();
                                }
                            });
                        }
                        else {
                            updateTab.refreshPartner(partnerInDb);
                        }
                    }//neptuneSucess
                });//checkProviderTaskStatus
            } //onSucess
        });
    }

    private String tasks2String(List<UITask> tasks) {
        StringBuilder sb = new StringBuilder("[");

        for(UITask task: tasks) {
            sb.append(task.getPartnerName() + ":" + task.getName()+", ");
        }
        String str = sb.toString();
        str = str.substring(0, str.length()-2);
        str += "]";

        return str;
    }
}
