package com.ericsson.cms.epgmgmt.client.publisher;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.Range;

public class LocalSimplePager extends SimplePager {

    public LocalSimplePager(TextLocation location, Resources resources, boolean showFastForwardButton,
            final int fastForwardRows, boolean showLastPageButton) {
        super(location, resources, showFastForwardButton, fastForwardRows, showLastPageButton, GWT
                .<ImageButtonsConstants> create(ImageButtonsConstants.class));
    }

    private Label rowInfoLabel;

    /**
     * Get the text to display in the pager that reflects the state of the pager.
     * 
     * @return the text
     */
    @Override
    protected String createText() {
        // Default text is 1 based.
        NumberFormat formatter = NumberFormat.getFormat("#,###");
        HasRows display = getDisplay();
        Range range = display.getVisibleRange();
        int pageStart = range.getStart() + 1;
        int pageSize = range.getLength();
        int dataSize = display.getRowCount();
        int endIndex = Math.min(dataSize, pageStart + pageSize - 1);
        endIndex = Math.max(pageStart, endIndex);
        String info = "Total records " + formatter.format(dataSize);
        if (rowInfoLabel != null) {
            rowInfoLabel.setText(info);
        }
        return super.getPage() + 1 + " / " + super.getPageCount();
    }

    public Label getRowInfoLabel() {
        return rowInfoLabel;
    }

    public void setRowInfoLabel(Label rowInfoLabel) {
        this.rowInfoLabel = rowInfoLabel;
    }

}
