package com.ericsson.cms.epgmgmt.client.publisher;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.model.UIFilterEntity;
import com.ericsson.cms.epgmgmt.client.utils.StringUtils;
import com.google.gwt.i18n.client.Constants;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;

public class PaginationDataProvider {
    /**
     * The constants used in this Content Widget.
     */
    static interface DatabaseConstants extends Constants {
        String[] contactDatabaseCategories();
    }

    /**
     * The provider that holds the list of contacts in the database.
     */
    private final ListDataProvider<UIFilterEntity> listDataProvider = new ListDataProvider<UIFilterEntity>();

    public PaginationDataProvider() {

    }

    public PaginationDataProvider(List<UIFilterEntity> dbDatas, boolean append) {
        if (dbDatas == null || dbDatas.size() == 0) {
            return;
        }
        List<UIFilterEntity> cacheData = listDataProvider.getList();
        if (!append) {
            cacheData.clear();
        }
        cacheData.addAll(0, dbDatas);
    }


    public void addData(List<UIFilterEntity> dbDatas, boolean append) {
        if (dbDatas == null) {
            return;
        }
        List<UIFilterEntity> cacheData = listDataProvider.getList();
        if (!append) {
            cacheData.clear();
        }
        cacheData.addAll(0, dbDatas);
    }

    public void removeData(List<UIFilterEntity> removeList) {
        if (removeList == null || removeList.size() == 0) {
            return;
        }
        /** make sure the id not contains double comma **/
        String removeIdString = dataIdToStrJoinComma(removeList);
        List<UIFilterEntity> cacheData = listDataProvider.getList();
        Iterator<UIFilterEntity> it = cacheData.iterator();
        while (it.hasNext()) {
            UIFilterEntity fe = it.next();
            if (removeIdString.contains("," + fe.getFilterId() + ",")) {
                it.remove();
            }
            /*
             * if (dbDatas.contains(fe)) { it.remove(); }
             */
        }
    }

    public String getDataAsSymbolString() {
        List<UIFilterEntity> cacheData = listDataProvider.getList();
        if (cacheData == null || cacheData.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        String symbol = "";
        for (UIFilterEntity fe : cacheData) {
            sb.append(symbol);
            sb.append(fe.getFilterName());
            symbol = "|";
        }
        return sb.toString();
    }


    public List<UIFilterEntity> searchByIdOrName(String primarySearchFilter, String secondarySearchFilter) {
        List<UIFilterEntity> cacheData = listDataProvider.getList();
        List<UIFilterEntity> searchData = new ArrayList<UIFilterEntity>();

        boolean isPrimaryFilterEmpty = StringUtils.isEmpty(primarySearchFilter);
        boolean isSecondaryFilterEmpty = StringUtils.isEmpty(secondarySearchFilter);
        for (UIFilterEntity fe : cacheData) {
            boolean isPrimaryFilterMatch = true;
            boolean isSecondaryFilterMatch = true;

            if (!isPrimaryFilterEmpty) {
                isPrimaryFilterMatch = fe.getFilterId().equals(primarySearchFilter)
                        || fe.getFilterName().toUpperCase().contains(primarySearchFilter.toUpperCase());
            }

            if (!isSecondaryFilterEmpty) {
                isSecondaryFilterMatch = fe.getTheSecondaryFilter().toUpperCase()
                        .contains(secondarySearchFilter.toUpperCase());

            }

            if (isPrimaryFilterMatch && isSecondaryFilterMatch) {
                searchData.add(fe);
            }
        }

        return searchData;
    }

    /**
     * Add a display to the database. The current range of interest of the display will be populated with data.
     * 
     * @param display
     *            a {@Link HasData}.
     */
    public void addDataDisplay(final HasData<UIFilterEntity> display) {
        listDataProvider.addDataDisplay(display);
    }


    public String dataIdToStrJoinComma(List<UIFilterEntity> dataList) {
        StringBuffer sb = new StringBuffer();
        for (UIFilterEntity fe : dataList) {
            sb.append(",").append(fe.getFilterId()).append(",");
        }
        return sb.toString();
    }

    public ListDataProvider<UIFilterEntity> getDataProvider() {
        return listDataProvider;
    }

    /**
     * Refresh all displays.
     */
    public void refreshDisplays() {
        listDataProvider.refresh();
    }


}