package com.ericsson.cms.epgmgmt.client.publisher;


import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.UIPluginProperty;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGPluginManagerService;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGPluginManagerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.gwtext.client.widgets.form.Hidden;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.MultiTaskBusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class PluginPropertiesPanel extends Composite{


    private static final String STYLE_HEAD = "epg-channels-properties-head";
    private static final String STYLE_BODY = "epg-channels-properties-body";
    private static final String STYLE_TEXTBOX = "epg-channels-properties-textbox";
    private FlexTableContainer table ;
    private final VerticalContainer mainPanel;
    private final EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class);
    private final IEPGPluginManagerServiceAsync pluginManagerService = GWT.create( IEPGPluginManagerService.class );
    private final EPGComponentConstants providerConstants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class);
    private final MultiTaskBusyIndicator busyIndicator = new MultiTaskBusyIndicator();
    private Long formatID=0L;

    public PluginPropertiesPanel() {

        mainPanel = new VerticalContainer();
        mainPanel.clear();
        initWidget(mainPanel);
    }


    public void setPluginPropertie(Long formatid){

        getPluginRecords(formatid);

    }







    public void initializeProperties(List<UIPluginProperty> props) {

        mainPanel.clear();

        table = new FlexTableContainer();
        table.removeAllRows();
        table.setWidget(0, 0, new LabelWidget(constants.pluginFieldName()));
        table.setWidget(0, 1, new LabelWidget(constants.pluginDefaultFieldValue()));
        table.setWidget(0, 2, new LabelWidget(constants.pluginFieldValue()));
        table.setWidget(0, 3, new LabelWidget(constants.pluginUseDefaultDisplayMsg()));
        table.getRowFormatter().addStyleName(0, STYLE_HEAD);
        for(UIPluginProperty p : props){
            addPluginProperties(p.getPropertyName(), p.getPropertyDefaultValue(),p.getPropertyValue());
        }

        mainPanel.add(table);



    }



    private void addPluginProperties(String name,  String defaultValue,String actualValue) {

        int rowIndex = table.getRowCount();
        table.getRowFormatter().addStyleName(rowIndex, STYLE_BODY);
        TextBoxWidget propertyNameWidget = new TextBoxWidget(name);
        propertyNameWidget.addStyleName(STYLE_TEXTBOX);
        propertyNameWidget.setEnabled(false);
        table.setWidget(rowIndex, 0, propertyNameWidget);
        TextBoxWidget defaultValueWidget = new TextBoxWidget(defaultValue);
        defaultValueWidget.addStyleName(STYLE_TEXTBOX);
        defaultValueWidget.setEnabled(false);
        table.setWidget(rowIndex, 1, defaultValueWidget);
        final TextBoxWidget actualValueWidget = new TextBoxWidget(actualValue);
        actualValueWidget.setMaxLength(255);
        actualValueWidget.addStyleName(STYLE_TEXTBOX);
        final CheckBoxWidget checkboxWidget = new CheckBoxWidget();


        if(!defaultValue.isEmpty() && defaultValue.equalsIgnoreCase(actualValue)){

            actualValueWidget.setEnabled(false);
            checkboxWidget.setValue(true);
        }else{
            actualValueWidget.setEnabled(true);
            checkboxWidget.setValue(false);
        }

        checkboxWidget.addValueChangeHandler(new ValueChangeHandler<Boolean>() {

            @Override
            public void onValueChange(ValueChangeEvent<Boolean> event) {

                if(!checkboxWidget.getValue()){
                    actualValueWidget.setEnabled(true);
                }else{
                    actualValueWidget.setEnabled(false);

                }
            }
        });

        table.setWidget(rowIndex, 2, actualValueWidget);
        table.setWidget(rowIndex, 3, checkboxWidget);

    }



    public List<UIPluginProperty> setPluginPropertiesForm(){


        List<UIPluginProperty> props = new ArrayList<UIPluginProperty>();
        for(int i=1; i<table.getRowCount(); ++i) {
            String fieldname = getFieldName(i);
            String defaultvalue = getDefaultValue(i);
            String configvalue = getConfigValue(i);
            boolean checkboxValue = getCheckBoxValue(i);
            String uiPropertyName = getUIPropertyName(i);
            String uiTooltip = getUIToolTip(i);
            //use confiured value if checkbox is selected
            if(checkboxValue){
                configvalue = defaultvalue;
            }
            props.add(new UIPluginProperty(fieldname,configvalue,defaultvalue,uiPropertyName,uiTooltip));
        }

        return props;
    }




    private String getFieldName(int rowIndex) {
        TextBoxWidget nameWidget = (TextBoxWidget) table.getWidget(rowIndex, 0);
        String name = nameWidget.getText();
        if(name != null) {
            name = name.trim();
        }
        return name;
    }

    private String getDefaultValue(int rowIndex) {
        TextBoxWidget valueWidget = (TextBoxWidget) table.getWidget(rowIndex, 1);
        String value = valueWidget.getText();
        if(value != null) {
            value = value.trim();
        }
        return value;
    }

    private String getUIPropertyName(int rowIndex) {
        Hidden propertyNameWidget = (Hidden) table.getWidget(rowIndex, 4);
        String value = propertyNameWidget.getValueAsString();
        if(value != null) {
            value = value.trim();
        }
        return value;
    }

    private String getUIToolTip(int rowIndex) {
        Hidden uiToolTipWidget = (Hidden) table.getWidget(rowIndex, 5);
        String value = uiToolTipWidget.getValueAsString();
        if(value != null) {
            value = value.trim();
        }
        return value;
    }


    private String getConfigValue(int rowIndex) {
        TextBoxWidget valueWidget = (TextBoxWidget) table.getWidget(rowIndex, 2);
        String value = valueWidget.getText();
        if(value != null) {
            value = value.trim();
        }
        return value;
    }

    private boolean getCheckBoxValue(int rowIndex) {

        CheckBoxWidget valueWidget = (CheckBoxWidget) table.getWidget(rowIndex, 3);
        return valueWidget.getValue();
    }


    public void getPluginRecords(Long formatid) {

        mainPanel.clear();
        busyIndicator.center();
        pluginManagerService.getPluginProperties(formatid ,new NeptuneAsyncCallback<List<UIPluginProperty>>(){

            @Override
            public void onNeptuneFailure( Throwable caught ) {

                Window.alert(providerConstants.loadingError() + " | " + providerConstants.reason() + ": " + (caught != null ? caught.getLocalizedMessage() : ""));
                busyIndicator.hide();
            }

            @Override
            public void onNeptuneSuccess(List<UIPluginProperty> result) {

                initializeProperties(result);
                busyIndicator.hide();

            }
        } );

    }


    public Long getFormatID() {
        return formatID;
    }


    public void setFormatID(Long formatID) {
        this.formatID = formatID;
    }





}
