package com.ericsson.cms.epgmgmt.client.publisher;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.EPGFormContainer;
import com.ericsson.cms.epgmgmt.client.ErrorPanel;
import com.ericsson.cms.epgmgmt.client.SuccessPanel;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentMessages;
import com.ericsson.cms.epgmgmt.client.model.UIEndPoint;
import com.ericsson.cms.epgmgmt.client.model.UIPartner;
import com.ericsson.cms.epgmgmt.client.model.UIPublisher;
import com.ericsson.cms.epgmgmt.client.model.UITask;
import com.ericsson.cms.epgmgmt.client.model.enumeration.JobType;
import com.ericsson.cms.epgmgmt.client.model.enumeration.PartnerType;
import com.ericsson.cms.epgmgmt.client.partner.AbstractPartnerCreateTab;
import com.ericsson.cms.epgmgmt.client.partner.AbstractPartnerTabContainer;
import com.ericsson.cms.epgmgmt.client.partner.PartnerBasicSettingForm;
import com.ericsson.cms.epgmgmt.client.task.ExportSettingPanel;
import com.ericsson.cms.epgmgmt.client.task.TaskBasicSettingForm;
import com.ericsson.cms.epgmgmt.client.task.TaskTriggerSettingForm;
import com.ericsson.cms.epgmgmt.client.widget.EPGNoIconRoundedDisclosureContainer;
import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class PublisherCreateTab extends AbstractPartnerCreateTab {

    private UIPublisher publisherModel;
    private UITask taskModel;
    private final EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class);
    private static final String STYLE_DISCLOSURE_CONTAINER = "epg-basicTab-disclosureContainer";
    private TaskTriggerSettingForm triggerForm;
    private EPGNoIconRoundedDisclosureContainer taskBasicDisclosure;
    private RoundedDisclosureContainer filterDisclosure;
    private PartnerBasicSettingForm basicForm;
    private TaskBasicSettingForm taskBasicForm;
    private final EPGFormContainer subscriptionForm = new EPGFormContainer(HorizontalContainer.ALIGN_LEFT);
    private final EPGFormContainer filterForm = new EPGFormContainer(HorizontalContainer.ALIGN_LEFT);
    private final EPGComponentMessages constantsMsg = (EPGComponentMessages) GWT.create(EPGComponentMessages.class);
    private ExportSettingPanel exportSettingPanel;
    private Long existingFormatId = 0L;
    private final SuccessPanel successPanel;
    private final ErrorPanel errorPanel;
    private EPGNoIconRoundedDisclosureContainer triggerInfoDisclosure;

    public PublisherCreateTab(AbstractPartnerTabContainer parentTabContainer) {
        super(parentTabContainer);
        NeptuneApplication.getApplication().getSecurity();
        publisherModel = createEmptyPublisherModel();
        taskModel = createEmptyTaskModel();

        successPanel = new SuccessPanel();
        errorPanel = new ErrorPanel();
        initForm();
        updateScrollPanelSize();
    }

    @Override
    protected void initForm() {
        initBasicDisclosure();
        initTaskDisclosure();
        super.initForm();
    }

    private void initBasicDisclosure() {
        basicForm = new PartnerBasicSettingForm(publisherModel);

        EPGNoIconRoundedDisclosureContainer basicInfoDisclosure = new EPGNoIconRoundedDisclosureContainer(new LabelWidget(constants.basicTab()), true);
        basicInfoDisclosure.setWidth(A_HUNDRED_PERCENT);
        basicInfoDisclosure.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        basicInfoDisclosure.setContent(basicForm);
        mainPanel.add(basicInfoDisclosure);
    }

    private void initTaskDisclosure() {

        triggerForm = new TaskTriggerSettingForm(JobType.EXPORT, taskModel);
        exportSettingPanel = new ExportSettingPanel();
        taskBasicForm = new TaskBasicSettingForm(JobType.EXPORT, taskModel);
        taskBasicForm.setExportSettingPanel(exportSettingPanel);
        taskBasicForm.setTriggerForm(triggerForm);

        EPGNoIconRoundedDisclosureContainer taskDisclosure = new EPGNoIconRoundedDisclosureContainer(new LabelWidget(constants.providerDefaultTaskTitle()), true);
        taskDisclosure.setWidth(A_HUNDRED_PERCENT);
        taskDisclosure.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        VerticalContainer vc = new VerticalContainer();
        vc.setWidth(A_HUNDRED_PERCENT);
        vc.setWidth("100%");

        initTaskBasicDisclosure();
        initTriggerDisclosure();
        initFilterDisclosure();

        vc.add(taskBasicDisclosure);
        vc.add(triggerInfoDisclosure);
        vc.add(filterDisclosure);

        taskDisclosure.setContent(vc);
        mainPanel.add(taskDisclosure);
    }

    private void initTriggerDisclosure() {

        triggerInfoDisclosure = new EPGNoIconRoundedDisclosureContainer(new LabelWidget(
                constants.triggerSetting()), true);
        triggerInfoDisclosure.setWidth(A_HUNDRED_PERCENT);
        triggerInfoDisclosure.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        triggerInfoDisclosure.setContent(triggerForm);
    }

    private void initTaskBasicDisclosure() {
        // exportSettingPanel.buildData(taskModel);

        taskBasicDisclosure = new EPGNoIconRoundedDisclosureContainer(new LabelWidget(constants.publisherBasicDisplayName()), true);
        taskBasicDisclosure.setWidth(A_HUNDRED_PERCENT);
        taskBasicDisclosure.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        taskBasicDisclosure.setContent(taskBasicForm);

    }

    private void initFilterDisclosure() {
        filterDisclosure = new RoundedDisclosureContainer(new LabelWidget(constants.exportFilters()), true);
        filterDisclosure.setWidth(A_HUNDRED_PERCENT);
        filterDisclosure.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        filterDisclosure.setContent(exportSettingPanel);
        filterDisclosure.setOpen(false);
    }

    @Override
    public UIPartner populatePartner() {
        return basicForm.populateModel();
    }

    @Override
    public UITask populateTask() {
        exportSettingPanel.populateModel();
        triggerForm.populateModel();
        taskBasicForm.populateModel();
        return taskModel;
    }

    @Override
    public String getName() {
        return "CreatePublisher";
    }

    @Override
    public String getDisplayName() {
        return constants.createNewReceiverLabel();
    }

    @Override
    public void setSelected(boolean selected) {
        if (!selected) {
            return;
        }
        messageArea.reset();
        updateScrollPanelSize();
    }

    @Override
    public List<String> validate() {
        List<String> validationMessages = new ArrayList<String>();

        validationMessages.addAll(basicForm.validateField());
        validationMessages.addAll(taskBasicForm.validateField());
        validationMessages.addAll(triggerForm.validateField());

        if (!basicForm.getIsEnabled().getValue() && taskBasicForm.getIsTaskEnabled().getValue()) {
            validationMessages.add(constantsMsg.enableTaskWhilePartnerIsDisabled());
        }

        // Validate provider filter
        if (exportSettingPanel.getProviderFilterValues() <= 0) {
            validationMessages.add(constantsMsg.requiredProviderFilter());
        }

        return validationMessages;
    }

    public SuccessPanel getSuccessPanel() {
        return successPanel;
    }

    public ErrorPanel getErrorPanel() {
        return errorPanel;
    }

    @Override
    public void clear() {
        basicForm.clearAllValidationErrors();
        taskBasicForm.clearAllValidationErrors();
        subscriptionForm.clearAllValidationErrors();
        filterForm.clearAllValidationErrors();
    }

    public Long getExistingFormatId() {
        return existingFormatId;
    }

    public void setExistingFormatId(Long existingFormatId) {
        this.existingFormatId = existingFormatId;
    }

    @Override
    public void reload() {
        publisherModel = createEmptyPublisherModel();
        taskModel = createEmptyTaskModel();
        messageArea.reset();
        loadPublisher(publisherModel);
        loadTask(taskModel);
        updateScrollPanelSize();
    }

    private UIPublisher createEmptyPublisherModel() {
        UIPublisher p = new UIPublisher();
        p.setPartnerType(PartnerType.Receiver);
        p.setActive(true);
        return p;
    }

    private UITask createEmptyTaskModel() {
        UITask t = new UITask();
        t.setType(JobType.EXPORT.toString());
        t.setEnabled(true);
        UIEndPoint ep = new UIEndPoint();
        t.setEndpoint(ep);
        return t;
    }

    private void loadPublisher(UIPublisher model) {
        basicForm.loadModel(model);
    }

    private void loadTask(UITask model) {
        exportSettingPanel.buildData(taskModel);
        taskBasicForm.loadModel(model);
        triggerForm.loadModel(model);
    }
}
