package com.ericsson.cms.epgmgmt.client.publisher;

import static com.ericsson.cms.epgmgmt.client.model.UIConstants.EPG_RECEIVER;

import com.ericsson.cms.epgmgmt.client.model.PartnerConstantUtils;
import com.ericsson.cms.epgmgmt.client.model.UIConstants;
import com.ericsson.cms.epgmgmt.client.model.UIPartner;
import com.ericsson.cms.epgmgmt.client.model.UIPublisher;
import com.ericsson.cms.epgmgmt.client.partner.AbstractPartnerCreateTab;
import com.ericsson.cms.epgmgmt.client.partner.AbstractPartnerTabContainer;
import com.ericsson.cms.epgmgmt.client.partner.PartnerListPanel;
import com.ericsson.cms.epgmgmt.client.task.AbstractTaskTab;
import com.ericsson.cms.epgmgmt.client.task.ExportTaskTab;
import com.ericsson.cms.epgmgmt.client.utils.MessageAreaUtils;
import com.google.gwt.user.client.Window;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;

public class PublisherTabContainer extends AbstractPartnerTabContainer {

    public PublisherTabContainer(PartnerListPanel partnerList, MessageArea messageArea) {
        super(partnerList, messageArea);
    }

    @Override
    protected AbstractPartnerCreateTab getCreateTab() {
        return new PublisherCreateTab(this);
    }

    @Override
    protected AbstractTaskTab getTaskTab(UIPartner partner) {
        return new ExportTaskTab(partner);
    }

    @Override
    protected UIPartner getEmptyPartner() {
        return new UIPublisher();
    }

    @Override
    protected String getAnchorName() {
        return UIConstants.EPG_MANAGER + "." + EPG_RECEIVER;
    }

    @Override
    protected void onDelete() {
        if (Window.confirm(constantsMsg.deletePartnerConfirmation(PartnerConstantUtils.getPartnerType(partner), partner.getName()))) {
            busyIndicator.center();
            partnerService.removePartnerById(this.getPartnerId(), new NeptuneAsyncCallback<Void>() {

                @Override
                public void onNeptuneFailure(Throwable caught) {
                    MessageAreaUtils.handleException(caught, messageArea);
                    busyIndicator.hide();
                }

                @Override
                public void onNeptuneSuccess(Void result) {
                    partner = getEmptyPartner();
                    updateTab.getLogTab().refreshData(partner);
                    partnerList.selectFirst(false);
                    busyIndicator.hide();
                }
            });
        }
    }

    @Override
    protected void onCommitUpdate() {
        busyIndicator.center();
        partner = updateTab.getBasicTab().populatePartner();
        partnerService.isPartnerTasksRunning(partnerId, new NeptuneAsyncCallback<Boolean>() {

            @Override
            public void onNeptuneFailure(Throwable caught) {
                MessageAreaUtils.handleException(caught, messageArea);
                busyIndicator.hide();
            }

            @Override
            public void onNeptuneSuccess(Boolean hasTaskRunning) {
                busyIndicator.hide();
                boolean updateConfirmed = true;
                if (hasTaskRunning) {
                    updateConfirmed = Window.confirm(saveWarningMessage());
                }

                if (updateConfirmed) {
                    busyIndicator.center();
                    partnerService.update(partner, new NeptuneAsyncCallback<Void>() {
                        @Override
                        public void onNeptuneFailure(Throwable caught) {
                            MessageAreaUtils.handleException(caught, messageArea);
                            updateTabSize();
                            busyIndicator.hide();
                        }

                        @Override
                        public void onNeptuneSuccess(Void result) {
                            setConfirmationMessage(constantsMsg.partnerUpdatedSuccess(PartnerConstantUtils.getPartnerType(partner)));
                            partnerList.reload(partner.getId(), null);
                            updateTab.getTaskTab().reload();
                            busyIndicator.hide();
                            updateTab.saveSuccess();
                        }
                    });
                }
            }
        });
    }
}
