package com.ericsson.cms.epgmgmt.client.publisher;

import com.google.gwt.cell.client.TextCell;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;

/**
 * Create a TitleTextCell Override the render method, just add title
 * 
 * @author Kevin.zhao
 */

public class TitleTextCell extends TextCell {
    public TitleTextCell() {
        super();
    }

    @Override
    public void render(Context context, SafeHtml value, SafeHtmlBuilder sb) {
        if (value != null) {
            sb.appendHtmlConstant("<div title=\"" + value.asString() + "\">");
            sb.append(value);
            sb.appendHtmlConstant("</div>");
        }
    }
}
