package com.ericsson.cms.epgmgmt.client.rpc;

import java.util.List;

import com.ericsson.cms.epgmgmt.client.model.ProviderTaskStatus;
import com.ericsson.cms.epgmgmt.client.model.SubscribersAndExportTaks;
import com.ericsson.cms.epgmgmt.client.model.UIPartner;
import com.ericsson.cms.epgmgmt.client.model.UITask;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

@RemoteServiceRelativePath("service/epgmgmt/IEPGPartnerService")
public interface IEPGPartnerService extends RemoteService {

    List<UIPartner> getProviders() throws NeptuneException;

    List<UIPartner> getPublishers() throws NeptuneException;

    Long createPartner(UIPartner partner) throws NeptuneException;

    UIPartner getPartner(long id) throws NeptuneException;

    void update(UIPartner partner) throws NeptuneException;

    void removePartnerById(long id) throws NeptuneException;

    /**
     * Return true if any one of the provider's tasks is running. Otherwise false.
     *
     * @param providerId
     * @return
     * @throws NeptuneException
     */
    boolean isPartnerTasksRunning(long id) throws NeptuneException;

    ProviderTaskStatus checkProviderTaskStatus(long id) throws NeptuneException;

    List<UITask> getEnableExportTasksForProvider(long providerId) throws NeptuneException;

    SubscribersAndExportTaks getSubscribersAndExportTasks(long providerId, boolean checkSubscribers, boolean checkExportTasks) throws NeptuneException;
}
