package com.ericsson.cms.epgmgmt.client.rpc;

import java.util.List;

import com.ericsson.cms.epgmgmt.client.model.ProviderTaskStatus;
import com.ericsson.cms.epgmgmt.client.model.SubscribersAndExportTaks;
import com.ericsson.cms.epgmgmt.client.model.UIPartner;
import com.ericsson.cms.epgmgmt.client.model.UITask;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

public interface IEPGPartnerServiceAsync {

    void getProviders(AsyncCallback<List<UIPartner>> callback);

    void getPublishers(AsyncCallback<List<UIPartner>> callback);

    void createPartner(UIPartner partner, AsyncCallback<Long> callback);

    void getPartner(long id, AsyncCallback<UIPartner> callback);

    void update(UIPartner partner, AsyncCallback<Void> callback);

    void removePartnerById(long id, AsyncCallback<Void> callback);

    /**
     * Return true if any one of the provider's tasks is running. Otherwise false.
     *
     * @param providerId
     * @return
     * @throws NeptuneException
     */
    void isPartnerTasksRunning(long id, AsyncCallback<Boolean> callback);

    void checkProviderTaskStatus(long id, AsyncCallback<ProviderTaskStatus> callback);

    void getEnableExportTasksForProvider(long providerId, AsyncCallback<List<UITask>> defaultAsyncCallback);

    void  getSubscribersAndExportTasks(long providerId,boolean checkSubscribers,boolean checkExportTasks,AsyncCallback<SubscribersAndExportTaks> callback);
}
