package com.ericsson.cms.epgmgmt.client.rpc;

import java.util.List;

import com.ericsson.cms.epgmgmt.client.model.UIEpgFormat;
import com.ericsson.cms.epgmgmt.client.model.UIPluginProperty;
import com.ericsson.cms.epgmgmt.client.model.enumeration.JobType;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;


@RemoteServiceRelativePath("service/epgmgmt/IEPGPluginManagerService")
public interface IEPGPluginManagerService extends RemoteService{

    List<UIPluginProperty> getPluginProperties(Long formatId) throws NeptuneException;

    List<String> savePluginProperties(Long formatId,List<UIPluginProperty> uiPluginProperty) throws NeptuneException;

    /**
     * Get all the plugin types base on the ingest/export.
     * 
     * @param type
     * @return
     * @throws NeptuneException
     */
    List<UIEpgFormat> getPlugins(JobType type) throws NeptuneException;

    /**
     * Return true if the plugin is active.
     * 
     * @param id
     * @return
     * @throws NeptuneException
     */
    boolean isPluginActive(long id) throws NeptuneException;
}
