package com.ericsson.cms.epgmgmt.client.rpc;

import java.util.List;
import java.util.Set;

import com.ericsson.cms.epgmgmt.client.model.UIPartner;
import com.ericsson.cms.epgmgmt.client.model.UITask;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

@RemoteServiceRelativePath("service/epgmgmt/IEPGTaskService")
public interface IEPGTaskService extends RemoteService {

    /**
     * Get all the tasks for the given partner.
     *
     * @param partnerId
     * @return
     * @throws NeptuneException
     */
    List<UITask> getTasks(long partnerId) throws NeptuneException;

    /**
     * Get all the tasks
     *
     * @param partnerId
     * @return
     * @throws NeptuneException
     */
    List<UITask> getAllTasks() throws NeptuneException;


    /**
     * Activate or deactivate the task with the given ID.
     *
     * @param id
     * @param value
     *            true to activate the task, false to deactivate
     * @throws NeptuneException
     */
    void activateTask(long id, Boolean value) throws NeptuneException;

    /**
     * Validate the plugin properties for a task.
     *
     * @param task
     * @return
     * @throws NeptuneException
     */
    List<String> validateTask(UITask task) throws NeptuneException;

    /**
     * Create a task.
     *
     * @param task
     * @return
     * @throws NeptuneException
     */
    long createTask(UITask task) throws NeptuneException;

    /**
     * Update a task.
     *
     * @param task
     * @throws NeptuneException
     */
    void updateTask(UITask task) throws NeptuneException;

    /**
     * Delete the task with the given ID.
     *
     * @param id
     * @throws NeptuneException
     */
    void deleteTask(long id) throws NeptuneException;

    /**
     * Get all the ingest tasks.
     *
     * @return
     * @throws NeptuneException
     */
    List<UITask> getIngestTasks() throws NeptuneException;

    /**
     * Get all the export tasks.
     *
     * @return
     * @throws NeptuneException
     */
    List<UITask> getExportTasks() throws NeptuneException;

    /**
     * Get all tasks under a partner.
     *
     * @return
     * @throws NeptuneException
     */
    List<UITask> getTasksByPartnerId(long partnerId) throws NeptuneException;

    UITask getTask(long taskId);

    UITask getConflictEndpoint(UITask task) throws NeptuneException;
    /**
     * Get all export tasks that triggered by the specified ingestion task completion
     * @param providerTaskId
     * @return
     */
    Set<UITask> getEnabledSubscribedTasks(long providerTaskId);
    boolean isTaskEnableInDb(UITask task);

    UIPartner getProviderForExportTask(long exportTaskId) ;
    UITask getSubscribedTask(long exportTaskId);
}

