package com.ericsson.cms.epgmgmt.client.rpc;

import java.util.List;
import java.util.Set;

import com.ericsson.cms.epgmgmt.client.model.UIPartner;
import com.ericsson.cms.epgmgmt.client.model.UITask;
import com.google.gwt.user.client.rpc.AsyncCallback;

public interface IEPGTaskServiceAsync {

    /**
     * get all the tasks for the given provider.
     *
     * @param callback
     */
    void getTasks(long id, AsyncCallback<List<UITask>> callback);

    void getAllTasks(AsyncCallback<List<UITask>> callback);

    void activateTask(long id, Boolean value, AsyncCallback<Void> callback);

    void validateTask(UITask task, AsyncCallback<List<String>> callback);

    void createTask(UITask task, AsyncCallback<Long> callback);

    void updateTask(UITask task, AsyncCallback<Void> callback);

    void deleteTask(long id, AsyncCallback<Void> callback);

    void getIngestTasks(AsyncCallback<List<UITask>> callback);

    void getExportTasks(AsyncCallback<List<UITask>> callback);

    void getTasksByPartnerId(long partnerId, AsyncCallback<List<UITask>> callback);

    void getTask(long taskId, AsyncCallback<UITask> callback);

    void getConflictEndpoint(UITask task, AsyncCallback<UITask> callback);

    void getEnabledSubscribedTasks(long providerTaskId, AsyncCallback<Set<UITask>> callback);

    void isTaskEnableInDb(UITask task, AsyncCallback<Boolean> callback);

    void getProviderForExportTask(long exportTaskId, AsyncCallback<UIPartner> callback);
    void getSubscribedTask(long exportTaskId, AsyncCallback<UITask> callback);
}
