package com.ericsson.cms.epgmgmt.client.rpc;

import java.io.IOException;

import com.ericsson.cms.epgmgmt.client.model.UIEpgFormat;
import com.ericsson.cms.epgmgmt.client.model.UIPluginMgmtResult;
import com.ericsson.cms.epgmgmt.client.model.UIPluginResult;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * GWT EPG format management service. <br>
 * <ul>
 * <li>List the EPG formats and plug-ins <br>
 * <li>Delete one of the EPG format's plugin
 * </ul>
 * 
 * @author Jack Tang
 */
@RemoteServiceRelativePath("epgManagerService")
public interface IPluginMgmtService extends RemoteService {
    /**
     * List all EPG formats and plug-ins.
     * 
     * @return
     * @throws NeptuneException
     */
    UIPluginResult listPlugin() throws NeptuneException;

    /**
     * Remove the EPG format's plug-in, if any providers or publishers depends on the EPG format return
     * 
     * @param id
     *            the EPG format's id
     * @return
     * @throws NeptuneException
     */
    UIPluginMgmtResult uninstallPlugin(long id) throws NeptuneException;


    /**
     * Activate the format
     * 
     * @param id
     * @return
     * @throws NeptuneException
     */
    UIPluginMgmtResult activiatePlugin(long id) throws NeptuneException;

    /**
     * Deactivate the format ,if any providers or publishers depend on the format.
     * 
     * @param id
     * @return
     * @throws NeptuneException
     */
    UIPluginMgmtResult deactivatePlugin(long id) throws NeptuneException;

    /**
     * 
     */
    UIPluginMgmtResult checkPlugin(long id) throws NeptuneException;
    /**
     * Get uploaded the plug-in information
     * @param formatId
     * @return
     * @throws IOException 
     */
    UIEpgFormat getPluginInfo(long formatId) throws IOException;
    /**
     * Install the upload plug-in
     * @param formatId
     * @return the install message
     */
    String installPlugin(long formatId, String zipFile, UIEpgFormat format);
    
    UIEpgFormat getPluginFormat(String formatName);
}
