package com.ericsson.cms.epgmgmt.client.rpc;

import com.ericsson.cms.epgmgmt.client.model.UIEpgFormat;
import com.ericsson.cms.epgmgmt.client.model.UIPluginMgmtResult;
import com.ericsson.cms.epgmgmt.client.model.UIPluginResult;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * GWT EPG format management service. <br>
 * <ul>
 * <li>List the EPG formats and plug-ins <br>
 * <li>Delete one of the EPG format's plugin
 * </ul>
 * 
 * @author Jack Tang
 */
public interface IPluginMgmtServiceAsync {
    /**
     * List all EPG formats and plug-ins.
     * 
     * @return
     */
    void listPlugin(AsyncCallback<UIPluginResult> callback);

    /**
     * Mark the EPG format deleted, if any providers or publishers depends on the EPG format
     * 
     * @param id
     *            the EPG format's id
     * @return
     */
    void uninstallPlugin(long id, AsyncCallback<UIPluginMgmtResult> callback);


    /**
     * Activate the EPG format .
     * 
     * @param id
     * @param callback
     */
    void activiatePlugin(long id, AsyncCallback<UIPluginMgmtResult> callback);

    /**
     * Deactivate the EPG format and related providers and publishers.If any publishers or providers using the format ,
     * a confirm message is returned.
     * 
     * @param id
     * @param callback
     */
    void deactivatePlugin(long id, AsyncCallback<UIPluginMgmtResult> callback);

    void checkPlugin(long id, AsyncCallback<UIPluginMgmtResult> callback);
    /**
     * Get uploaded the plug-in information
     * @param formatId
     * @return
     */
    void getPluginInfo(long formatId, AsyncCallback<UIEpgFormat> callback);
    /**
     * Install the upload plug-in
     * @param formatId
     */
    void installPlugin(long formatId, String zipFile, UIEpgFormat format, AsyncCallback<String> callback);
    
    void getPluginFormat(String formatName, AsyncCallback<UIEpgFormat> callback);
}
