/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.rpc;

import java.util.List;

import com.ericsson.cms.epgmgmt.client.model.UiEntityMapping;
import com.ericsson.cms.epgmgmt.client.model.UiNormalizationGroup;
import com.ericsson.cms.epgmgmt.client.model.UiValidationGroup;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * @author amit.r.seth
 * 
 */
@RemoteServiceRelativePath("service/epgmgmt/IRulesService")
public interface IRulesService extends RemoteService {

	/**
	 * Return the list of validation groups for listing.
	 * 
	 * @return the list of validation groups.
	 * @throws NeptuneException
	 */
	List<UiValidationGroup> getValidationGroups(String sortProperty, boolean isAscending) throws NeptuneException;

	/**
	 * Returns the validation group for the given key.
	 * 
	 * @param key
	 * @return
	 * @throws NeptuneException
	 */
	UiValidationGroup getValidationGroup(long key) throws NeptuneException;

	/**
	 * Return the list of normalization groups for listing.
	 * 
	 * @return the list of normalization groups.
	 * @throws NeptuneException
	 */
	List<UiNormalizationGroup> getNormalizationGroups(String sortProperty, boolean isAscending) throws NeptuneException;

	/**
	 * Returns the normalization group for the given key.
	 * 
	 * @param key
	 * @return
	 * @throws NeptuneException
	 */
	UiNormalizationGroup getNormalizationGroup(long key) throws NeptuneException;

	/**
	 * Enables the list of validation group.
	 * 
	 * @param list
	 * @throws NeptuneException
	 */
	void enableValidationGroups(List<UiValidationGroup> list) throws NeptuneException;

	/**
	 * Disables the list of validation group.
	 * 
	 * @param list
	 * @throws NeptuneException
	 */
	void disableValidationGroups(List<UiValidationGroup> list) throws NeptuneException;

	/**
	 * Enables the list of normalization group.
	 * 
	 * @param list
	 * @throws NeptuneException
	 */
	void enableNormalizationGroups(List<UiNormalizationGroup> list) throws NeptuneException;

	/**
	 * Disables the list of normalization group.
	 * 
	 * @param list
	 * @throws NeptuneException
	 */
	void disableNormalizationGroups(List<UiNormalizationGroup> list) throws NeptuneException;

	/**
	 * Deletes the list of normalization group.
	 * 
	 * @param list
	 * @throws NeptuneException
	 */
	void deleteNormalizationGroups(List<UiNormalizationGroup> list) throws NeptuneException;

	/**
	 * Deletes the list of validation group.
	 * 
	 * @param list
	 * @throws NeptuneException
	 */
	void deleteValidationGroups(List<UiValidationGroup> list) throws NeptuneException;

	/**
	 * Return the list of entity mappings.
	 * 
	 * @return the list of entity mappings.
	 * @throws NeptuneException
	 */
	List<UiEntityMapping> getEntityMappings() throws NeptuneException;

	/**
	 * Saves the validation group.
	 * 
	 * @param validationGroup
	 * @throws NeptuneException
	 */
	void saveValidationGroup(UiValidationGroup validationGroup) throws NeptuneException;
	
	/**
	 * Saves the validation group.
	 * 
	 * @param validationGroup
	 * @throws NeptuneException
	 */
	void saveNormalizationGroup(UiNormalizationGroup normalizationGroup) throws NeptuneException;
	
	
}
