/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.rpc;

import java.util.List;

import com.ericsson.cms.epgmgmt.client.model.UiEntityMapping;
import com.ericsson.cms.epgmgmt.client.model.UiNormalizationGroup;
import com.ericsson.cms.epgmgmt.client.model.UiValidationGroup;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * @author amit.r.seth
 * 
 */
public interface IRulesServiceAsync {

	void getValidationGroups(String sortProperty, boolean isAscending, AsyncCallback<List<UiValidationGroup>> callback);

	void getValidationGroup(long key, AsyncCallback<UiValidationGroup> callback);

	void getNormalizationGroups(String sortProperty, boolean isAscending, AsyncCallback<List<UiNormalizationGroup>> callback);

	void getNormalizationGroup(long key, AsyncCallback<UiNormalizationGroup> callback);
	
	void enableValidationGroups(List<UiValidationGroup> list, AsyncCallback<Void> callback);
	
	void disableValidationGroups(List<UiValidationGroup> list, AsyncCallback<Void> callback);

	void enableNormalizationGroups(List<UiNormalizationGroup> list, AsyncCallback<Void> callback);
	
	void disableNormalizationGroups(List<UiNormalizationGroup> list, AsyncCallback<Void> callback);

	void deleteNormalizationGroups(List<UiNormalizationGroup> selectedRecords, AsyncCallback<Void> asyncCallback);

	void deleteValidationGroups(List<UiValidationGroup> selectedRecords, AsyncCallback<Void> asyncCallback);

	void getEntityMappings(AsyncCallback<List<UiEntityMapping>> asyncCallback);
	
	void saveValidationGroup(UiValidationGroup validationGroup, AsyncCallback<Void> asyncCallback);
	
	void saveNormalizationGroup(UiNormalizationGroup normalizationGroup, AsyncCallback<Void> asyncCallback);
}
