/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.rules;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.Permissions;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.rpc.IRulesService;
import com.ericsson.cms.epgmgmt.client.rpc.IRulesServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author amit.r.seth
 *
 */
public abstract class AbstractRulesDetailView extends Composite {
    // widgets used in this view
    private VerticalContainer mainContainer;

    private HeaderPanel header;
    public TabContainer tabContainer = new TabContainer(); // NOSONAR

    public List<Composite> tabs = new ArrayList<Composite>(); // NOSONAR

    private final MessageArea messageArea = new MessageArea();
    private final HorizontalContainer buttonPanel = new HorizontalContainer();

    private HandlerRegistration resizeHandlerRegistration;

    public EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class); // NOSONAR
    public IRulesServiceAsync rpcService = GWT.create(IRulesService.class); // NOSONAR

    // spacing between the table and message panel
    private static final int SPACING = 2;
    private static int CMS_HEADER_MENU_SIZE_PX = 115;
    private static final String STYLE_NAME = "content-EPGPanel";
    private static final String TAB_CONTAINER_STYLE = "epg-tabContainer";
    private static final String BUTTON_PANEL_STYLE = "epg-tabContainer-buttonPanel";

    private Long ruleId = null;

    public Record<Long> ruleRecord; // NOSONAR

    public BusyIndicator busyIndicator = new BusyIndicator(); // NOSONAR

    public AbstractRulesDetailView() {
    }

    public void addHeader(String headingLabel) {
        mainContainer = new VerticalContainer();
        mainContainer.setSpacing(SPACING);
        mainContainer.setStylePrimaryName(STYLE_NAME);
        this.initWidget(mainContainer);

        header = new HeaderPanel(headingLabel);

        // Add widgets to the main container
        mainContainer.add(header);
        messageArea.reset();
        mainContainer.add(messageArea);
    }

    /**
     * 
     */
    private void init() {
        createTabs();

        createButtonPanel();

        Scheduler.get().scheduleDeferred(new ScheduledCommand() {
            @Override
            public void execute() {
                updateTableContainerSize(getSelectedTab());
            }
        });
    }

    public AbstractRulesDetailView(String headingLabel, Long record) {
        addHeader(headingLabel);
        this.ruleId = record;
        if (this.ruleId != null) {
            busyIndicator.center();
            loadRecord(this.ruleId);
        }
        init();
    }

    protected abstract void loadRecord(Long ruleId);

    /**
     * 
     */
    private void createTabs() {
        tabContainer.addStyleName(TAB_CONTAINER_STYLE);
        mainContainer.add(tabContainer);

        tabContainer.addSelectionHandler(new SelectionHandler<Integer>() {
            @Override
            public void onSelection(SelectionEvent<Integer> event) {
                if (tabs.size() > 0) {
                    updateTableContainerSize(event.getSelectedItem());
                }
            }
        });

        // TODO: Add Panels
        // Create option
        if (ruleId == null) {
            addTabPanels();

            tabContainer.selectTab(0);
        }
    }

    protected abstract void addTabPanels();

    private void createButtonPanel() {
        buttonPanel.setStyleName(BUTTON_PANEL_STYLE);
        // save button
        if(ClientAuthorizationManager.isAuthorized(Permissions.EPG_MODIFY) ||
                ClientAuthorizationManager.isAuthorized(Permissions.EPG_CREATE) && ruleId == null) {
            ButtonWidget saveButton = new ButtonWidget(constants.buttonLabelSave());
            saveButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
            saveButton.addClickHandler(new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {
                    // Handle save
                    messageArea.reset();
                    if (!validate()) {
                        return;
                    }
                    handleSave();
                }});
            buttonPanel.add(saveButton);
        }

        // cancel button
        ButtonWidget cancelButton = new ButtonWidget(constants.buttonLabelCancel());
        cancelButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
        cancelButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                handleCancel();
            }
        });
        buttonPanel.add(cancelButton);

        if (cancelButton != null) {
            buttonPanel.setCellWidth(cancelButton, "99%");
        }
        mainContainer.add(buttonPanel);
    }

    protected abstract boolean validate();

    protected abstract void handleSave();

    protected abstract void handleCancel();

    private void updateTableContainerSize(int selected) {
        if(selected >= 0){
            int height = Window.getClientHeight()
                    - CMS_HEADER_MENU_SIZE_PX
                    - header.getOffsetHeight()
                    - messageArea.getOffsetHeight()
                    - tabContainer.getTabBar().getOffsetHeight()
                    - buttonPanel.getOffsetHeight()
                    - 20;	//adjustment for borders and spacing at the bottom
            tabs.get(selected).setHeight(height + "px");
        }

    }

    protected int getSelectedTab() {
        return tabContainer.getTabBar().getSelectedTab();
    }

    public void setInfoMessage(String message) {
        messageArea.setInfoMessage(message);
        updateTableContainerSize(getSelectedTab());
    }

    public void setErrorMessage(String message) {
        messageArea.setErrorMessage(message);
        updateTableContainerSize(getSelectedTab());
    }

    public void setErrorHTML(String message) {
        messageArea.setErrorHTML(message);
        updateTableContainerSize(getSelectedTab());
    }

    @Override
    protected void onLoad() {
        super.onLoad();

        resizeHandlerRegistration = Window.addResizeHandler(new ResizeHandler() {
            @Override
            public void onResize(ResizeEvent event) {
                updateTableContainerSize(getSelectedTab());
            }
        });
    };

    @Override
    protected void onUnload() {
        resizeHandlerRegistration.removeHandler();
        resizeHandlerRegistration = null;
        super.onUnload();
    }
}
