/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.rules;

import com.ericsson.cms.epgmgmt.client.Permissions;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentMessages;
import com.ericsson.cms.epgmgmt.client.rpc.IRulesService;
import com.ericsson.cms.epgmgmt.client.rpc.IRulesServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author amit.r.seth
 *
 */
public abstract class AbstractRulesTabPanel extends VerticalContainer {

    private static final String BUTTON_PANEL_STYLE = "epg-tabContainer-buttonPanel";
    // widgets used in this view
    private final ScrollContainer tableContainer = new ScrollContainer();
    private final HorizontalContainer buttonPanel = new HorizontalContainer();
    private Table<Long, Record<Long>> table;

    public RulesListViewPanel parentPanel; // NOSONAR

    public HeaderPanel header; // NOSONAR
    public BookmarkFeature bookmarkFeature;  // NOSONAR
    public BusyIndicator busyIndicator = new BusyIndicator(); // NOSONAR

    public IRulesServiceAsync rpcService = GWT.create(IRulesService.class); // NOSONAR

    public EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class); // NOSONAR

    public EPGComponentMessages messages = (EPGComponentMessages) GWT.create(EPGComponentMessages.class); // NOSONAR

    public AbstractRulesTabPanel(HeaderPanel header, RulesListViewPanel parentPanel) {
        if (!ClientAuthorizationManager.isAuthorized(Permissions.EPG_VIEW)) {
            Window.alert("You do not have permissions to view this page...");
            return;
        }
        this.header = header;
        this.parentPanel = parentPanel;
        init();
    }

    private void init() {
        createButtonPanel();
        this.table = (Table<Long, Record<Long>>) createTable();
        tableContainer.setWidget(this.table);
        this.add(tableContainer);
        refreshTable();
    }

    void refreshTable() {
        if (!this.table.isInitialized()) {
            this.table.initialize(new NeptuneAsyncCallback<Void>() {
                @Override
                public void onNeptuneFailure(Throwable caught) {
                }

                @Override
                public void onNeptuneSuccess(Void result) {
                    table.refresh();
                }
            });
        } else {
            this.table.refresh();
        }
    }

    private void createButtonPanel() {
        buttonPanel.setStyleName(BUTTON_PANEL_STYLE);
        ButtonWidget lastButtonAdded = null;
        //enable button
        if(ClientAuthorizationManager.isAuthorized(Permissions.EPG_MODIFY)) {
            ButtonWidget enableButton = new ButtonWidget(constants.buttonLabelEnable());
            enableButton.addStyleDependentName(StyleNames.DO_BUTTON_STYLE);
            enableButton.addClickHandler(new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {
                    // Handle enable
                    handleEnable();
                }});
            buttonPanel.add(enableButton);
            lastButtonAdded = enableButton;
        }

        //create button
        if(ClientAuthorizationManager.isAuthorized(Permissions.EPG_CREATE)) {
            ButtonWidget createButton = new ButtonWidget(constants.buttonLabelCreate());
            createButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
            createButton.addClickHandler(new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {
                    handleCreate();
                }});
            buttonPanel.add(createButton);
            lastButtonAdded = createButton;
        }

        //disable button
        if(ClientAuthorizationManager.isAuthorized(Permissions.EPG_MODIFY)) {
            ButtonWidget disableButton = new ButtonWidget(constants.buttonLabelDisable());
            disableButton.addStyleDependentName(StyleNames.CAUTION_BUTTON_STYLE);
            disableButton.addClickHandler(new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {
                    // Handle Disable
                    handleDisable();
                }});
            buttonPanel.add(disableButton);
            lastButtonAdded = disableButton;
        }

        //delete button
        if(ClientAuthorizationManager.isAuthorized(Permissions.EPG_DELETE)) {
            ButtonWidget deleteButton = new ButtonWidget(constants.buttonLabelDelete());
            deleteButton.addStyleDependentName("dataloss-button");
            deleteButton.addClickHandler(new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {
                    // Handle Delete
                    handleDelete();
                }});
            buttonPanel.add(deleteButton);
            lastButtonAdded = deleteButton;
        }
        if (lastButtonAdded != null) {
            buttonPanel.setCellWidth(lastButtonAdded, "99%");
        }
    }

    protected abstract void handleDelete();

    protected abstract void handleDisable();

    protected abstract void handleEnable();

    protected abstract void handleCreate();
    /**
     * @return
     * 
     */
    protected abstract IsWidget createTable();

    public int getButtonPanelOffsetHeight() {
        return buttonPanel.getOffsetHeight();
    }

    public void setTableContainerHeight(int height) {
        tableContainer.setHeight(height + "px");
    }

    protected void setHeaderLabel(String label) {
        header.setLabel(label);
    }

    public HorizontalContainer getButtonPanel() {
        return buttonPanel;
    }
}
