/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.rules;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.Permissions;
import com.ericsson.cms.epgmgmt.client.events.RuleDeleteEvent;
import com.ericsson.cms.epgmgmt.client.events.RuleDeleteHandler;
import com.ericsson.cms.epgmgmt.client.events.RuleReorderEvent;
import com.ericsson.cms.epgmgmt.client.events.RuleReorderHandler;
import com.ericsson.cms.epgmgmt.client.model.UiNormalizationGroup;
import com.ericsson.cms.epgmgmt.client.model.UiNormalizationRule;
import com.ericsson.cms.epgmgmt.client.rules.extend.EPGNormalizationRule;
import com.ericsson.cms.epgmgmt.client.rules.extend.IEPGNormalizationRuleForm;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;



/**
 * @author amit.r.seth
 *
 */
public class DataModificationContainer extends RulesContentContainer {

	
	private List<EPGNormalizationRule> normalizationRulePanels;
	private boolean reorderEnabled;
	
	/**
	 * 
	 */
	public DataModificationContainer(AbstractRulesDetailView parent, boolean isNormalization) {
		super(parent, isNormalization);
	}

	@Override
	protected void addWidgets() {
		
		normalizationRulePanels = new ArrayList<EPGNormalizationRule>();
		if (parent.ruleRecord != null) {
			UiNormalizationGroup group =(UiNormalizationGroup) parent.ruleRecord;
			if (isNormalization) {
				if(group != null && group.getRules()!= null && group.getRules().size()>0){
					for(UiNormalizationRule rule: group.getRules()){
						EPGNormalizationRule ruleWidget = new EPGNormalizationRule(rule
								, rulesContainer.getWidgetCount(), false);
						ruleWidget.addDeleteHandler(buildRuleDeleteHander());
						ruleWidget.addReorderHandler(buildReorderHandler());
						normalizationRulePanels.add(ruleWidget);
						rulesContainer.add(ruleWidget);
					}
				} else {
					createEmptyRule();
				}
			}
		} else {
			createEmptyRule();
		}
		
		mainContainer.add(buildButtons());
	}

	private Widget buildButtons() {
		HorizontalPanel container = new HorizontalPanel();
		ButtonWidget reorderButton = buildReorderButton();
		if (reorderButton != null) {
			container.add(reorderButton);
		}
		ButtonWidget createButton = addCreateButton();
		if (createButton != null) {
			container.add(createButton);
		}
		return container;
	}

	private ButtonWidget buildReorderButton() {
		reorderEnabled = false;
		if ((ClientAuthorizationManager.isAuthorized(Permissions.EPG_CREATE) && parent.ruleRecord == null)
				|| ClientAuthorizationManager.isAuthorized(Permissions.EPG_MODIFY)) {
			final ButtonWidget reorderButton = new ButtonWidget(constants.enableReorder());
			reorderButton.addClickHandler(new ClickHandler() {
						@Override
                        public void onClick(ClickEvent event) {
							reorderEnabled = !reorderEnabled;
							String text = reorderEnabled ? constants
									.disableReorder() : constants
									.enableReorder();
							reorderButton.setText(text);
							for (Widget w : rulesContainer) {
								IEPGNormalizationRuleForm rule = (IEPGNormalizationRuleForm) w;
								rule.enableReorder(reorderEnabled);
							}
						}
					});
			reorderButton.addStyleDependentName(StyleNames.DO_BUTTON_STYLE);
			return reorderButton;
		}
		return null;
	}

	/**
	 * 
	 */
	private ButtonWidget addCreateButton() {
		//create button
		if((ClientAuthorizationManager.isAuthorized(Permissions.EPG_CREATE) && parent.ruleRecord == null)
				|| ClientAuthorizationManager.isAuthorized(Permissions.EPG_MODIFY)) {
			ButtonWidget createButton = new ButtonWidget(constants.buttonLabelCreate());
			createButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
			createButton.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					createEmptyRule();
				}});
			return createButton;
		}
		return null;
	}
	
	private void createEmptyRule() {
		EPGNormalizationRule ruleWidget = new EPGNormalizationRule(rulesContainer.getWidgetCount(), reorderEnabled);
		ruleWidget.addDeleteHandler(buildRuleDeleteHander());
		ruleWidget.addReorderHandler(buildReorderHandler());
		normalizationRulePanels.add(ruleWidget);
		rulesContainer.add(ruleWidget);
	}
	
	public List<UiNormalizationRule> getRules() {
		List<UiNormalizationRule> rules = new ArrayList<UiNormalizationRule>();
		for (EPGNormalizationRule rulePanel : normalizationRulePanels) {
			rules.add((UiNormalizationRule) rulePanel.getRule());
		}
		return rules;
	}

	@Override
	protected boolean validate() {
		boolean valid = true;
		for (EPGNormalizationRule rulePanel : normalizationRulePanels) {
			if (!rulePanel.validate()) {
				valid = false;
			}
		}
		if (!valid) {
			parent.setErrorMessage(messages.ruleGroupDataModificationFix());
		}
		return valid;
	}

	/**
	 * Builds the handler to remove a rule from the rule panel
	 * 
	 * @return
	 */
	private RuleDeleteHandler buildRuleDeleteHander() {
		return new RuleDeleteHandler() {

			@Override
			public void ruleDeleted(RuleDeleteEvent event) {
				IEPGNormalizationRuleForm rule = (IEPGNormalizationRuleForm) event
						.getRule();
				int ruleIndex = rule.getIndex();
				rulesContainer.remove((Widget) rule);
				normalizationRulePanels.remove(rule);
				if (ruleIndex < rulesContainer.getWidgetCount()) {
					for(int i = ruleIndex; i < rulesContainer.getWidgetCount(); i ++) {
						IEPGNormalizationRuleForm currRule = (IEPGNormalizationRuleForm) rulesContainer
								.getWidget(i);
						currRule.setCurrentIndex(i);
					}
				}
			}

		};
	}

	private RuleReorderHandler buildReorderHandler() {
		return new RuleReorderHandler() {

			@Override
			public void reorder(RuleReorderEvent event) {
				IEPGNormalizationRuleForm rule = event.getRule();
				int newPos = event.getNewIndex();
				if (newPos == rule.getIndex()) {
					return;
				}

				// Trim the new pos
				if (newPos < 0) {
					newPos = 0;
				} else if (newPos > rulesContainer.getWidgetCount() - 1) {
					newPos = rulesContainer.getWidgetCount() - 1;
				}

				int containerPos = newPos;
				if (newPos > rule.getIndex()) {
					containerPos++;
				}
				rulesContainer.insert((Widget) rule, containerPos);

				// update indexes of affected rules
				int i = rule.getIndex() < newPos ? rule.getIndex() : newPos;

				while (i < rulesContainer.getWidgetCount()) {
					((IEPGNormalizationRuleForm)rulesContainer.getWidget(i)).setCurrentIndex(i);
					i++;
				}
			}

		};
	}
}
