/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.rules;

import static com.ericsson.cms.epgmgmt.client.model.UIConstants.EPG_MANAGER;
import static com.ericsson.cms.epgmgmt.client.model.UIConstants.EPG_NORMALIZATION_RULES;
import static com.ericsson.cms.epgmgmt.client.model.UIConstants.RULE_ENGINE;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.model.UIProvider;
import com.ericsson.cms.epgmgmt.client.model.UIPublisher;
import com.ericsson.cms.epgmgmt.client.model.UiNormalizationGroup;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;


/**
 * @author amit.r.seth
 *
 */
public class NormalizationDetailsView extends AbstractRulesDetailView implements DetailView<Long, UiNormalizationGroup> {

    private static final String EPG_MANAGER_EPG_NORMALIZATION_RULES = EPG_MANAGER + "." + RULE_ENGINE + "." + EPG_NORMALIZATION_RULES;

    private ProvidersListContainer providers;
    private PublishersListContainer publishers;
    private DataModificationContainer dataModification;
    private RulesPropertiesContainer properties;
    private UiNormalizationGroup normalizationRecord;


    public NormalizationDetailsView(Long recordId) {
        super("EPG Normalization Rule Set", recordId);
    }

    /* (non-Javadoc)
     * @see com.ericsson.cms.epgmgmt.client.rules.AbstractRulesDetailView#addTabPanels()
     */
    @Override
    protected void addTabPanels() {
        // TODO: Refine to replace with widgets
        providers = new ProvidersListContainer(this, true);
        tabContainer.add(providers, "EPG Providers");
        tabs.add(providers);
        publishers = new PublishersListContainer(this, true);
        tabContainer.add(publishers, "EPG Receivers");
        tabs.add(publishers);
        WhenToRunContainer whenToRun = new WhenToRunContainer(this, true);
        tabContainer.add(whenToRun, "When to run");
        tabs.add(whenToRun);
        ProgramFilterContainer programFilter = new ProgramFilterContainer(this, true);
        tabContainer.add(programFilter, "Program Filter");
        tabs.add(programFilter);
        dataModification = new DataModificationContainer(this, true);
        tabContainer.add(dataModification, "Data Modification");
        tabs.add(dataModification);
        properties = new RulesPropertiesContainer(this, true);
        tabContainer.add(properties, "Properties");
        tabs.add(properties);
    }

    @Override
    protected void handleCancel() {
        // Handle cancel. Go back to list screen...
        History.newItem(EPG_MANAGER_EPG_NORMALIZATION_RULES);
    }

    @Override
    public void release() {
    }

    @Override
    public void revert() {
    }

    @Override
    public void commit() {
    }

    @Override
    public UiNormalizationGroup getRecord() {
        return null;
    }

    @Override
    public void saveFailed(Throwable throwable) {
    }

    @Override
    public Widget getWidget() {
        return this;
    }

    @Override
    protected void loadRecord(Long recordId) {
        busyIndicator.center();
        rpcService.getNormalizationGroup(recordId, new AsyncCallback<UiNormalizationGroup>() {

            @Override
            public void onFailure(Throwable caught) {
                busyIndicator.hide();
                setErrorMessage("Could not get the normalization group record. " + caught.getLocalizedMessage());
            }

            @Override
            public void onSuccess(UiNormalizationGroup result) {
                normalizationRecord = result;
                ruleRecord = normalizationRecord;
                addTabPanels();

                tabContainer.selectTab(0);
                busyIndicator.hide();
            }
        });
    }

    @Override
    protected void handleSave() {
        if (normalizationRecord == null) {
            normalizationRecord = new UiNormalizationGroup();
        }
        // Get selected Providers
        if (providers.isGlobalSelected()) {
            normalizationRecord.setIsGlobalForProviders(true);
            normalizationRecord.setProviders(null);
        } else {
            normalizationRecord.setIsGlobalForProviders(false);
            List<UIProvider> providersList = new ArrayList<UIProvider>();
            for (Long providerId : providers.getSelectedProviders()) {
                UIProvider p = new UIProvider();
                p.setId(providerId);
                providersList.add(p);
            }
            normalizationRecord.setProviders(providersList);
        }
        // Get selected Publishers
        if (publishers.isGlobalSelected()) {
            normalizationRecord.setIsGlobalForPublishers(true);
            normalizationRecord.setPublishers(null);
        } else {
            normalizationRecord.setIsGlobalForPublishers(false);
            List<UIPublisher> publisherList = new ArrayList<UIPublisher>();
            for (Long publisherId : publishers.getSelectedPublishers()) {
                UIPublisher p = new UIPublisher();
                p.setId(publisherId);
                publisherList.add(p);
            }
            normalizationRecord.setPublishers(publisherList);
        }
        // Get the normalization Rules to be associated
        normalizationRecord.setRules(dataModification.getRules());

        // Get the properties
        normalizationRecord.setName(properties.getRuleGroupName());
        normalizationRecord.setEnabled(properties.isEnabled());
        rpcService.saveNormalizationGroup(normalizationRecord, new AsyncCallback<Void>() {

            @Override
            public void onFailure(Throwable caught) {
                String validationMessage = constants.normalizationRuleSetSaveFailure();
                if (caught instanceof ValidationException ) {
                    ValidationException ve = (ValidationException) caught;
                    for (String message : ve.getValidationMessages()) {
                        validationMessage += "<br>" + message;
                    }
                } else {
                    validationMessage += "<br>" + caught.getLocalizedMessage();
                }
                setErrorHTML(validationMessage);
            }

            @Override
            public void onSuccess(Void result) {
                setInfoMessage(constants.normalizationRuleSetSaveSuccess());
                Timer redirectTimer = new Timer() {
                    @Override
                    public void run() {
                        History.newItem(EPG_MANAGER_EPG_NORMALIZATION_RULES);
                    };
                };
                redirectTimer.schedule(5000);
            }
        });

    }

    @Override
    protected boolean validate() {
        if (!properties.validate()) {
            tabContainer.selectTab(5);
            return false;
        }
        if (!dataModification.validate()) {
            tabContainer.selectTab(4);
            return false;
        }
        return true;
    }

}
