/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.rules;

import java.util.List;

import com.ericsson.cms.epgmgmt.client.Permissions;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.UiLongKeySerializer;
import com.ericsson.cms.epgmgmt.client.model.UiNormalizationGroup;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AbstractDetailFeature;

/**
 * @author amit.r.seth
 *
 */
public class NormalizationRulesDetailFeature extends AbstractDetailFeature<Long, UiNormalizationGroup> {

    private final EPGComponentConstants constants = (EPGComponentConstants) GWT
            .create(EPGComponentConstants.class);

    public NormalizationRulesDetailFeature(NormalizationRulesTabPanel rulesListViewPanel) {
        super(new UiLongKeySerializer());
    }

    @Override
    public DetailView<Long, UiNormalizationGroup> getView(
            UiNormalizationGroup record,
            DetailViewCallback<Long, UiNormalizationGroup> callback) {
        // TODO Auto-generated method stub
        return new DummyNormalizationDetailView();
    }

    @Override
    public boolean hasDetailLink(Column<?, UiNormalizationGroup> column) {
        return column.getDisplayName().equals(constants.ruleIdColumn())
                && ClientAuthorizationManager.isAuthorized(Permissions.EPG_VIEW);
    }

    @Override
    public void getNew(AsyncCallback<UiNormalizationGroup> callback) {
        // TODO Auto-generated method stub
        callback.onSuccess(new UiNormalizationGroup());
    }

    @Override
    public void save(UiNormalizationGroup record, AsyncCallback<Void> callback) {
        // TODO Auto-generated method stub

    }

    @Override
    public void delete(List<UiNormalizationGroup> records,
            AsyncCallback<Void> callback) {
        // TODO Auto-generated method stub

    }

    /**
     * This is useless while the buttons need to be displayed at the bottom of the screen...
     * Should always return false.
     */
    @Override
    public boolean showCreateButton() {
        return false;
    }

    /**
     * This is useless while the buttons need to be displayed at the bottom of the screen...
     * Should always return false.
     */
    @Override
    public boolean showDeleteButton() {
        return false;
    }

}
