/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.rules;

import static com.ericsson.cms.epgmgmt.client.model.UIConstants.EPG_MANAGER;
import static com.ericsson.cms.epgmgmt.client.model.UIConstants.EPG_NORMALIZATION_RULES;
import static com.ericsson.cms.epgmgmt.client.model.UIConstants.RULE_ENGINE;

import java.util.List;

import com.ericsson.cms.epgmgmt.client.model.UiNormalizationGroup;
import com.ericsson.cms.epgmgmt.client.rules.NormalizationRulesDataProvider.IBusyNotifier;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;

/**
 * @author amit.r.seth
 * 
 */
public class NormalizationRulesTabPanel extends AbstractRulesTabPanel {
	
	private static final String EPG_NORMALIZATION_RULES_CREATE = EPG_MANAGER + "."+ RULE_ENGINE + "." + EPG_NORMALIZATION_RULES + ".Create";
	private static final String EPG_NORMALIZATION_RULES_EDIT = EPG_MANAGER + "." + RULE_ENGINE + "." + EPG_NORMALIZATION_RULES + ".Edit?id=";
	// table related
	private NormalizationRulesDataProvider dataProvider;
	private SortFeatureImpl<Long, UiNormalizationGroup> sortFeature;
	private NormalizationRulesDetailFeature detailFeature;
	private Table<Long, UiNormalizationGroup> table;

	public NormalizationRulesTabPanel(HeaderPanel header, RulesListViewPanel parentPanel) {
		super(header, parentPanel);
	}

	/**
	 * @return 
	 * 
	 */
	@Override
    protected Table<Long, UiNormalizationGroup> createTable() {
		this.dataProvider = new NormalizationRulesDataProvider(this);
		dataProvider.setBusyNotifier(new IBusyNotifier() {
			@Override
			public void startingToBeBusy() {
				busyIndicator.center();
			}

			@Override
			public void doneBeingBusy() {
				busyIndicator.hide();
			}
		});
		this.table = new Table<Long, UiNormalizationGroup>(dataProvider);
		table.addTableViewChangeHandler(new TableViewChangeHandler<Long, UiNormalizationGroup>() {
			@Override
			public void onShowDetailView(
					TableDetailViewEvent<Long, UiNormalizationGroup> event) {
				if (event.isCreateView()) {
					header.setLabel(constants.ruleCreateHeading());
				} else {
					header.setLabel(constants.ruleViewEditHeading() + " "
							+ event.getRecord().getName());
					History.newItem(EPG_NORMALIZATION_RULES_EDIT + event.getRecord().getKey());
				}
			}

			@Override
			public void onShowListView(TableViewEvent event) {
				header.setLabel(constants.ruleListHeading());
			}
		});

		// sort feature
		sortFeature = new SortFeatureImpl<Long, UiNormalizationGroup>(
				dataProvider.getDefaultSortColumn(), SortOrder.ASCENDING);
		for (Column<?, UiNormalizationGroup> col : dataProvider.getSortColumns()) {
			sortFeature.addSortableColumn(col);
		}
		dataProvider.setParentSortFeature(sortFeature);

		// detail feature
		detailFeature = new NormalizationRulesDetailFeature(this);

		// bookmark feature
		bookmarkFeature = new BookmarkFeatureImpl();

		table.addSortFeature(sortFeature);
		table.addDetailFeature(detailFeature);
		table.addBookmarkFeature(bookmarkFeature);

		return table;
	}

	public void showBusyIndicator() {
		busyIndicator.center();
	}

	public void hideBusyIndicator() {
		busyIndicator.hide();
	}

	@Override
	protected void handleCreate() {
		History.newItem(EPG_NORMALIZATION_RULES_CREATE);
	}

	@Override
	protected void handleDisable() {
		List<UiNormalizationGroup> selectedRecords = table.getSelectedRecords();
		if (selectedRecords.size() > 0) {
			showBusyIndicator();
			rpcService.disableNormalizationGroups(selectedRecords, new AsyncCallback<Void>() {
				
				@Override
				public void onSuccess(Void result) {
					refreshTable();
					hideBusyIndicator();
				}
				
				@Override
				public void onFailure(Throwable caught) {
                	refreshTable();
                    parentPanel.setErrorMessage(messages.disableRuleSetError());
                    hideBusyIndicator();
				}
			});
		} else {
			Window.alert(constants.noRuleSelected());
		}
	}

	@Override
	protected void handleEnable() {
		List<UiNormalizationGroup> selectedRecords = table.getSelectedRecords();
		if (selectedRecords.size() > 0) {
			showBusyIndicator();
			rpcService.enableNormalizationGroups(selectedRecords, new AsyncCallback<Void>() {
				
				@Override
				public void onSuccess(Void result) {
					refreshTable();
					hideBusyIndicator();
				}
				
				@Override
				public void onFailure(Throwable caught) {
                	refreshTable();
                    parentPanel.setErrorMessage(messages.enableRuleSetError());
                    hideBusyIndicator();
				}
			});
		} else {
			Window.alert(constants.noRuleSelected());
		}
	}

	@Override
	protected void handleDelete() {
		List<UiNormalizationGroup> selectedRecords = table.getSelectedRecords();
		if (selectedRecords.size() > 0) {
			if (Window.confirm(messages.deleteRuleSetConfirmation())) {
				showBusyIndicator();
				rpcService.deleteNormalizationGroups(selectedRecords, new AsyncCallback<Void>() {
					
					@Override
					public void onSuccess(Void result) {
						refreshTable();
						parentPanel.setInfoMessage(messages.deleteRuleSetSuccess());
						hideBusyIndicator();
					}
					
					@Override
					public void onFailure(Throwable caught) {
	                	refreshTable();
	                    parentPanel.setErrorMessage(messages.deleteRuleSetError());
	                    hideBusyIndicator();
					}
				});
			}
		} else {
			Window.alert(constants.noRuleSelected());
		}
	}

}
