/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.rules;

import java.util.List;

import com.ericsson.cms.epgmgmt.client.model.UIPartner;
import com.ericsson.cms.epgmgmt.client.model.UiNormalizationGroup;
import com.ericsson.cms.epgmgmt.client.model.UiValidationGroup;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGPartnerService;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGPartnerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.RadioButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * @author amit.r.seth
 *
 */
public class ProvidersListContainer extends RulesContentContainer {

    private UiNormalizationGroup normalizationGroup;
    private UiValidationGroup validationGroup;

    private RadioButtonWidget globalRadio;
    private RadioButtonWidget providersRadio;
    private VerticalContainer tableContainer;
    private FlexTableContainer table;

    private final IEPGPartnerServiceAsync providerService = GWT.create(IEPGPartnerService.class);

    /**
     * 
     */
    public ProvidersListContainer(AbstractRulesDetailView parent, boolean isNormalization) {
        super(parent, isNormalization);
        initializeValues();
    }

    private void initializeValues() {
        // TODO Auto-generated method stub
        globalRadio.setValue(isGlobal());
        if (!isGlobal()) {
            providersRadio.setValue(true);
            enableProvidersView();
        }
    }

    @Override
    protected void addWidgets() {
        HorizontalContainer radioButtons = new HorizontalContainer();
        radioButtons.setSpacing(10);
        mainContainer.add(radioButtons);
        if (parent.ruleRecord != null) {
            if (isNormalization) {
                normalizationGroup = (UiNormalizationGroup) parent.ruleRecord;
            } else {
                validationGroup = (UiValidationGroup) parent.ruleRecord;
            }
        }
        globalRadio = new RadioButtonWidget("EPG Providers", constants.global());
        globalRadio.setValue(true);
        globalRadio.addValueChangeHandler(new ValueChangeHandler<Boolean>() {


            @Override
            public void onValueChange(ValueChangeEvent<Boolean> event) {
                // TODO Auto-generated method stub
                disableProvidersView();

            }
        });
        radioButtons.add(globalRadio);
        providersRadio = new RadioButtonWidget("EPG Providers", constants.selectProviders());

        providersRadio.addValueChangeHandler(new ValueChangeHandler<Boolean>() {


            @Override
            public void onValueChange(ValueChangeEvent<Boolean> event) {
                // TODO Auto-generated method stub
                enableProvidersView();

            }
        });
        radioButtons.add(providersRadio);

    }

    private Boolean isGlobal() {
        if (isNormalization) {
            return normalizationGroup != null ? normalizationGroup.isGlobalForProviders() : true;
        } else {
            return validationGroup != null ? validationGroup.isGlobal() : true;
        }
    }

    private boolean hasSelectedProvider(long id) {
        if (isNormalization) {
            return normalizationGroup != null ? normalizationGroup.hasProvider(id) : false;
        } else {
            return validationGroup != null ? validationGroup.hasProvider(id) : false;
        }
    }

    private void enableProvidersView() {
        final BusyIndicator busyIndicator = new BusyIndicator();
        tableContainer = new VerticalContainer();
        mainContainer.add(tableContainer);
        tableContainer.setStyleName(STYLE_NAME);
        table = new FlexTableContainer();
        tableContainer.add(table);

        createTableHeaderRow(table);
        addHeading(constants.providerTreeLabel(), table);

        busyIndicator.center();
        providerService.getProviders(new NeptuneAsyncCallback<List<UIPartner>>() {

            @Override
            public void onNeptuneFailure(Throwable caught) {
                busyIndicator.hide();
                parent.setErrorMessage(constants.loadingError() + " | "
                        + constants.reason() + ": "
                        + (caught != null ? caught.getLocalizedMessage() : ""));
            }

            @Override
            public void onNeptuneSuccess(List<UIPartner> result) {
                busyIndicator.hide();
                for (UIPartner provider : result) {
                    addRow(table, provider, hasSelectedProvider(provider.getId()));
                }
                addCheckBoxHeader(table);
            }
        });
    }

    private void disableProvidersView() {
        // TODO Auto-generated method stub
        mainContainer.remove(tableContainer);
    }

    public Boolean isGlobalSelected() {
        return globalRadio.getValue();
    }

    public List<Long> getSelectedProviders() {
        return getSelected(table);
    }

    private void addRow(FlexTableContainer table, UIPartner provider, boolean selected) {
        int rowIndex = addRow(table);

        // adds the row checkbox
        CheckBoxWidget check = new CheckBoxWidget();
        check.setValue(selected);
        check.setFormValue(provider.getId().toString());
        table.getCellFormatter().setHorizontalAlignment(rowIndex, 0, HasHorizontalAlignment.ALIGN_CENTER);
        table.setWidget(rowIndex, 0, check);

        Label label = new Label(provider.getName());
        table.setWidget(rowIndex, 1, label);
    }

    @Override
    protected boolean validate() {
        // TODO Auto-generated method stub
        return true;
    }

}
