/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.rules;

import java.util.List;

import com.ericsson.cms.epgmgmt.client.model.UIPartner;
import com.ericsson.cms.epgmgmt.client.model.UiNormalizationGroup;
import com.ericsson.cms.epgmgmt.client.model.UiValidationGroup;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGPartnerService;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGPartnerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.RadioButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * @author amit.r.seth
 *
 */
public class PublishersListContainer extends RulesContentContainer {

    private UiNormalizationGroup normalizationGroup;
    private UiValidationGroup validationGroup;

    private RadioButtonWidget globalRadio;
    private RadioButtonWidget publishersRadio;
    private FlexTableContainer table;
    private final VerticalContainer tableContainer = new VerticalContainer();
    private final IEPGPartnerServiceAsync publisherService = GWT.create(IEPGPartnerService.class);

    /**
     * 
     */
    public PublishersListContainer(AbstractRulesDetailView parent, boolean isNormalization) {
        super(parent, isNormalization);
        initializeValues();
    }

    public Boolean isGlobalSelected() {
        return globalRadio.getValue();
    }

    public List<Long> getSelectedPublishers() {
        return getSelected(table);
    }

    @Override
    protected void addWidgets() {
        // TODO Auto-generated method stub
        HorizontalContainer radioButtonsContainer = new HorizontalContainer();
        radioButtonsContainer.setSpacing(10);
        mainContainer.add(radioButtonsContainer);
        if (parent.ruleRecord != null) {
            if (isNormalization) {
                normalizationGroup = (UiNormalizationGroup) parent.ruleRecord;
            } else {
                validationGroup = (UiValidationGroup) parent.ruleRecord;
            }
        }
        globalRadio = new RadioButtonWidget("EPG receivers", constants.global());
        globalRadio.addValueChangeHandler(new ValueChangeHandler<Boolean>() {

            @Override
            public void onValueChange(ValueChangeEvent<Boolean> event) {
                tableContainer.setVisible(publishersRadio.getValue());
            }

        });

        publishersRadio = new RadioButtonWidget("EPG receivers", constants.selectPublishers());
        publishersRadio.addValueChangeHandler(new ValueChangeHandler<Boolean>() {

            @Override
            public void onValueChange(ValueChangeEvent<Boolean> event) {
                enablePublishersView();
                tableContainer.setVisible(event.getValue());

            }

        });
        radioButtonsContainer.add(globalRadio);
        radioButtonsContainer.add(publishersRadio);

    }

    private void initializeValues() {
        // TODO Auto-generated method stub
        globalRadio.setValue(isGlobal());
        if (!isGlobal()) {
            publishersRadio.setValue(true);
            enablePublishersView();
        }

    }

    private Boolean isGlobal() {
        if (isNormalization) {
            return normalizationGroup != null ? normalizationGroup.isGlobalForPublishers() : true;
        } else {
            return validationGroup != null ? validationGroup.isGlobal() : true;
        }

    }

    private boolean hasSelectedProvider(long id) {
        if (isNormalization) {
            return normalizationGroup != null ? normalizationGroup.hasPublisher(id) : false;
        }
        return false;
    }

    private void enablePublishersView() {
        final BusyIndicator busyIndicator = new BusyIndicator();
        if(mainContainer.getWidgetIndex(tableContainer) == -1){
            tableContainer.setStyleName(STYLE_NAME);
            table = new FlexTableContainer();
            tableContainer.add(table);
            createTableHeaderRow(table);
            addHeading(constants.publisherTreeLabel(), table);
            mainContainer.add(tableContainer);

            busyIndicator.center();
            publisherService.getPublishers(new NeptuneAsyncCallback<List<UIPartner>>() {

                @Override
                public void onNeptuneFailure(Throwable caught) {
                    busyIndicator.hide();
                    parent.setErrorMessage(constants.loadingError() + " | "
                            + constants.reason() + ": "
                            + (caught != null ? caught.getLocalizedMessage() : ""));
                }

                @Override
                public void onNeptuneSuccess(List<UIPartner> result) {
                    busyIndicator.hide();
                    for (UIPartner publisher : result) {
                        addRow(table, publisher, hasSelectedProvider(publisher.getId()));
                    }
                    addCheckBoxHeader(table);
                    tableContainer.setVisible(true);
                }
            });

        }
        else{
            tableContainer.setVisible(true);
        }

    }

    private void addRow(FlexTableContainer table, UIPartner publisher, boolean selected) {
        int rowIndex = addRow(table);

        // adds the row checkbox
        CheckBoxWidget check = new CheckBoxWidget();
        check.setValue(selected);
        check.setFormValue(String.valueOf(publisher.getId()));
        table.getCellFormatter().setHorizontalAlignment(rowIndex, 0, HasHorizontalAlignment.ALIGN_CENTER);
        table.setWidget(rowIndex, 0, check);

        Label label = new Label(publisher.getName());
        table.setWidget(rowIndex, 1, label);
    }

    @Override
    protected boolean validate() {
        // TODO Auto-generated method stub
        return true;
    }



}
