/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.rules;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.TreeCreator;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIBooleanFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIComplexFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIDateFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIIntegerFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UISimpleFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.UIStringFieldDefinition;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentMessages;
import com.ericsson.cms.epgmgmt.client.model.UIConstants;
import com.ericsson.cms.epgmgmt.client.model.UiEntityMapping;
import com.ericsson.cms.epgmgmt.client.rpc.IRulesService;
import com.ericsson.cms.epgmgmt.client.rpc.IRulesServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * @author amit.r.seth
 *
 */
public abstract class RulesContentContainer extends Composite {

    public static final String STYLE_NAME = "epg-content-data";
    private static final String CELL_STYLE = "epg-table-cell";
    private static final String ROW_HEADER_STYLE = "epg-table-header-row";
    private static final String CELL_HEADER_STYE = "epg-table-header-nonSortable-text";
    private static final String CELL_BODY_STYLE = "epg-TableColumnPanel-dataCell-text";
    private final BusyIndicator busyIndicator = new BusyIndicator();

    public EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class); // NOSONAR
    public EPGComponentMessages messages = (EPGComponentMessages) GWT.create(EPGComponentMessages.class); // NOSONAR
    public VerticalContainer mainContainer = new VerticalContainer(); // NOSONAR
    public VerticalContainer rulesContainer = new VerticalContainer(); // NOSONAR
    public AbstractRulesDetailView parent; // NOSONAR
    public boolean isNormalization = false; // NOSONAR

    private boolean isTreeLoaded = false;
    private final IRulesServiceAsync rulesRpcService = GWT.create(IRulesService.class);
    /**
     * 
     */
    public RulesContentContainer(AbstractRulesDetailView parent, boolean isNormalization) {
        super();
        this.parent = parent;
        this.isNormalization = isNormalization;
        ScrollContainer scrollContainer = new ScrollContainer();
        scrollContainer.add(mainContainer);
        mainContainer.add(rulesContainer);

        this.initWidget(scrollContainer);

        if (!(this instanceof DataModificationContainer || this instanceof ValidationCriteriaContainer)) {
            addWidgets();
        } else {
            createTreeDefinitions(this);
        }
    }

    protected abstract void addWidgets();

    protected abstract boolean validate();

    private void createTreeDefinitions(final RulesContentContainer rulesContentContainer) {
        if (!isTreeLoaded) {
            busyIndicator.center();
            rulesRpcService.getEntityMappings(
                    new AsyncCallback<List<UiEntityMapping>>() {

                        @Override
                        public void onSuccess(List<UiEntityMapping> result) {
                            busyIndicator.hide();
                            TreeCreator.setEpgData(getEPGRoot(result));
                            isTreeLoaded = true;
                            if (rulesContentContainer instanceof DataModificationContainer || rulesContentContainer instanceof ValidationCriteriaContainer) {
                                addWidgets();
                            }
                        }

                        @Override
                        public void onFailure(Throwable caught) {
                            busyIndicator.hide();
                            Window.alert(caught.getLocalizedMessage());
                        }
                    });

        }
    }

    public UIFieldDefinition getEPGRoot(List<UiEntityMapping> fields) {
        UIComplexFieldDefinition root = new UIComplexFieldDefinition();
        root.setDisplayName("EPG");
        root.setXPath("Rules_EPG");
        root.setName("Rules_EPG");
        for (UiEntityMapping field : fields) {
            String[] path = field.getDisplayName().split("/");
            String displayName = path[path.length-1];
            UISimpleFieldDefinition simpleDef = convertField(field, displayName);
            addField(root, path, 0, simpleDef);
        }
        return root;
    }

    private UISimpleFieldDefinition convertField(UiEntityMapping rlf, String displayName) {
        UISimpleFieldDefinition def;
        switch (rlf.getDataType()) {
        case String:
            def = new UIStringFieldDefinition();
            break;
        case Int:
            def = new UIIntegerFieldDefinition();
            break;
        case DateTime:
            def = new UIDateFieldDefinition();
            break;
        case Boolean:
            def = new UIBooleanFieldDefinition();
            break;
        default:
            return null;
        }
        def.setName(rlf.getDisplayName());
        def.setDisplayName(displayName);
        def.setXPath(String.valueOf(rlf.getId()));
        //include additional attributes that distinguish tree in criteria and predicate.
        List<UIValueOption> epgTreeAttribs = new ArrayList<UIValueOption>(2);
        epgTreeAttribs.add(new UIValueOption(UIConstants.IS_ALLOW_AS_CRITERIA, Boolean.toString(rlf.isAllowAsCriteria())));
        epgTreeAttribs.add(new UIValueOption(UIConstants.IS_ALLOW_AS_PREDICATE, Boolean.toString(rlf.isAllowAsPredicate())));
        def.setSuggestedValues(epgTreeAttribs);
        return def;
    }

    private void addField(UIComplexFieldDefinition node, String[] path,
            int pos, UISimpleFieldDefinition def) {
        if (pos + 1 == path.length) {
            node.addChild(def);
            return;
        }
        for (UIFieldDefinition child : node.getChildren()) {
            if (child.getName().equals(path[pos])
                    && child instanceof UIComplexFieldDefinition) {
                addField((UIComplexFieldDefinition) child, path, pos + 1, def);
                return;
            }
        }
        UIComplexFieldDefinition pointer = node;
        for(int i=pos; i < path.length-1;i++) {
            UIComplexFieldDefinition child = new UIComplexFieldDefinition();
            child.setDisplayName(path[pos]);
            child.setName(path[pos]);
            child.setXPath("");
            pointer.addChild(child);
            pointer = child;
        }
        pointer.addChild(def);
    }

    protected void createTableHeaderRow(FlexTableContainer table) {
        /* Create the header row */
        table.insertRow(0);
        table.getRowFormatter().addStyleName(0, ROW_HEADER_STYLE);
    }

    protected int addRow(FlexTableContainer table) {
        table.insertRow(table.getRowCount());
        table.getRowFormatter().addStyleName(getRowIndex(table), CELL_BODY_STYLE);
        return getRowIndex(table);
    }

    /*
     * Returns the last index of the rows
     */
    private int getRowIndex(FlexTableContainer table) {
        return table.getRowCount() - 1;
    }

    protected void addCheckBoxHeader(final FlexTableContainer table) {
        final CheckBoxWidget check = new CheckBoxWidget();
        check.addClickHandler(new ClickHandler() {

            @Override
            public void onClick(ClickEvent event) {
                if (check.getValue()) {
                    checkAll(table);
                } else {
                    uncheckAll(table);
                }
            }
        });

        table.insertCell(0, 0);
        table.getCellFormatter().addStyleName(0, 0, CELL_STYLE);
        table.getCellFormatter().addStyleName(0, 0, ROW_HEADER_STYLE);
        table.setWidget(0, 0, check);
    }

    private void checkAll(FlexTableContainer table) {
        for (int i = 0; i < table.getRowCount(); i++) {
            ((CheckBoxWidget) table.getWidget(i, 0)).setValue(true);
        }
    }

    private void uncheckAll(FlexTableContainer table) {
        for (int i = 0; i < table.getRowCount(); i++) {
            ((CheckBoxWidget) table.getWidget(i, 0)).setValue(false);
        }
    }

    protected List<Long> getSelected(FlexTableContainer table) {
        List<Long> selectedList = new ArrayList<Long>();
        for (int i = 1; i < table.getRowCount(); i++) {
            if (((CheckBoxWidget) table.getWidget(i, 0)).getValue()) {
                selectedList.add(Long.parseLong(((CheckBoxWidget)table.getWidget(i, 0)).getFormValue()));
            }
        }
        return selectedList;
    }

    protected void addHeading(String heading, FlexTableContainer table) {
        /* Add the column to the header row */
        int column = table.getCellCount(0);
        table.insertCell(0, column);

        /* Create new label widget or update existing widget */
        LabelWidget label = getHeadingWidget(table, column);
        if (label == null) {
            /* Update the widget displayed as the column header */
            label = new LabelWidget(heading);
            table.getCellFormatter().addStyleName(0, column, CELL_HEADER_STYE);
            table.setWidget(0, column, label);
        } else {
            label.setText(heading);
        }
    }

    protected LabelWidget getHeadingWidget(FlexTableContainer table, int column) {
        Widget widget = table.getWidget(0, column);
        return widget instanceof LabelWidget ? (LabelWidget) widget : null;
    }
}
