/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.rules;

import com.ericsson.cms.epgmgmt.client.Permissions;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * @author amit.r.seth
 *
 */
public class RulesListViewPanel extends Composite {

    // widgets used in this view
    private VerticalContainer mainContainer;

    private HeaderPanel header;
    private final TabContainer tabContainer = new TabContainer();

    private AbstractRulesTabPanel listTabPanel;

    private final MessageArea messageArea = new MessageArea();

    private HandlerRegistration resizeHandlerRegistration;

    private final EPGComponentConstants constants = (EPGComponentConstants) GWT
            .create(EPGComponentConstants.class);

    // spacing between the table and message panel
    private static final int SPACING = 2;
    private static final int CMS_HEADER_MENU_SIZE_PX = 115;
    private static final String STYLE_NAME = "content-EPGPanel";
    private static final String TAB_CONTAINER_STYLE = "epg-tabContainer";

    public RulesListViewPanel(boolean isNormalization) {
        if (!ClientAuthorizationManager.isAuthorized(Permissions.EPG_VIEW)) {
            Window.alert("You do not have permissions to view this page...");
            return;
        }
        init(isNormalization);
    }

    private void init(boolean isNormalization) {
        mainContainer = new VerticalContainer();
        mainContainer.setSpacing(SPACING);
        mainContainer.setStylePrimaryName(STYLE_NAME);
        this.initWidget(mainContainer);

        header = new HeaderPanel("");

        // Add widgets to the main container
        mainContainer.add(header);
        messageArea.reset();
        mainContainer.add(messageArea);
        if (isNormalization) {
            createNormalizationTab();
        } else {
            createValidationTab();
        }

        Scheduler.get().scheduleDeferred(new ScheduledCommand() {
            @Override
            public void execute() {
                updateTableContainerSize();
            }
        });
    }

    /**
     * 
     */
    private void createNormalizationTab() {
        tabContainer.addStyleName(TAB_CONTAINER_STYLE);
        mainContainer.add(tabContainer);

        listTabPanel = new NormalizationRulesTabPanel(header, this);
        tabContainer.add(listTabPanel, constants.normalizationRuleListHeading());
        // Adding the button panel after the tab panel has created the relevant buttons
        mainContainer.add(listTabPanel.getButtonPanel());

        tabContainer.selectTab(0);
    }

    /**
     * 
     */
    private void createValidationTab() {
        tabContainer.addStyleName(TAB_CONTAINER_STYLE);
        mainContainer.add(tabContainer);

        listTabPanel = new ValidationRulesTabPanel(header, this);
        tabContainer.add(listTabPanel, constants.validationRuleListHeading());
        // Adding the button panel after the tab panel has created the relevant buttons
        mainContainer.add(listTabPanel.getButtonPanel());

        tabContainer.selectTab(0);
    }

    private void updateTableContainerSize() {
        int height = Window.getClientHeight()
                - CMS_HEADER_MENU_SIZE_PX
                - header.getOffsetHeight()
                - messageArea.getOffsetHeight()
                - tabContainer.getTabBar().getOffsetHeight()
                - listTabPanel.getButtonPanelOffsetHeight()
                - 20;	//adjustment for borders and spacing at the bottom
        listTabPanel.setTableContainerHeight(height);
    }

    public void setInfoMessage(String message) {
        messageArea.setInfoMessage(message);
        updateTableContainerSize();
    }

    public void setErrorMessage(String message) {
        messageArea.setErrorMessage(message);
        updateTableContainerSize();
    }

    @Override
    protected void onLoad() {
        super.onLoad();

        resizeHandlerRegistration = Window.addResizeHandler(new ResizeHandler() {
            @Override
            public void onResize(ResizeEvent event) {
                updateTableContainerSize();
            }
        });
    };

    @Override
    protected void onUnload() {
        resizeHandlerRegistration.removeHandler();
        resizeHandlerRegistration = null;
        super.onUnload();
    }
}
