/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.rules;

import com.ericsson.cms.epgmgmt.client.model.UiNormalizationGroup;
import com.ericsson.cms.epgmgmt.client.model.UiValidationGroup;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;


/**
 * @author amit.r.seth
 *
 */
public class RulesPropertiesContainer extends RulesContentContainer {
	
	private TextBoxWidget ruleNameTxtBox;
	private CheckBoxWidget chkEnabled;

	/**
	 * 
	 */
	public RulesPropertiesContainer(AbstractRulesDetailView parent, boolean isNormalization) {
		super(parent, isNormalization);
		initializeValues();
	}

	@Override
	protected void addWidgets() {
		// TODO Auto-generated method stub
		HorizontalContainer nameContainer = new HorizontalContainer();
		nameContainer.setSpacing(10);
		LabelWidget ruleNameLbl = new LabelWidget("Rule Set Name");
		nameContainer.add(ruleNameLbl);
		ruleNameTxtBox = new TextBoxWidget();
		nameContainer.add(ruleNameTxtBox);
		chkEnabled = new CheckBoxWidget("Enabled");
		nameContainer.add(chkEnabled);
		
		mainContainer.add(nameContainer);
	}

	private void initializeValues() {
		// TODO Auto-generated method stub
		if (parent.ruleRecord != null) {
			if (isNormalization) {
				UiNormalizationGroup group = (UiNormalizationGroup) parent.ruleRecord;
				ruleNameTxtBox.setValue(group.getName());
				chkEnabled.setValue(group.getEnabled());
			} else {
				UiValidationGroup group = (UiValidationGroup) parent.ruleRecord;
				ruleNameTxtBox.setValue(group.getName());
				chkEnabled.setValue(group.getEnabled());
			}
		}
	}
	
	public String getRuleGroupName() {
		return ruleNameTxtBox.getValue();
	}

	public Boolean isEnabled() {
		return chkEnabled.getValue();
	}

	@Override
	public boolean validate() {
		if (getRuleGroupName() == null) {
			parent.setErrorMessage(messages.ruleGroupNameRequired());
			return false;
		}
		if (getRuleGroupName().isEmpty() || getRuleGroupName().trim().isEmpty()) {
			parent.setErrorMessage(messages.ruleGroupNameRequired());
			return false;
		}
		return true;
	}
}
