/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.rules;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.Permissions;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.ericsson.cms.epgmgmt.client.events.RuleDeleteEvent;
import com.ericsson.cms.epgmgmt.client.events.RuleDeleteHandler;
import com.ericsson.cms.epgmgmt.client.model.UiValidationGroup;
import com.ericsson.cms.epgmgmt.client.model.UiValidationRule;
import com.ericsson.cms.epgmgmt.client.model.enumeration.UiRuleErrorLevelEnum;
import com.ericsson.cms.epgmgmt.client.rules.extend.EPGUIAction;
import com.ericsson.cms.epgmgmt.client.rules.extend.EPGValidationRule;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;



/**
 * @author amit.r.seth
 *
 */
public class ValidationCriteriaContainer extends RulesContentContainer {

	private List<EPGValidationRule> validationRulePanels;

	/**
	 * 
	 */
	public ValidationCriteriaContainer(AbstractRulesDetailView parent, boolean isNormalization) {
		super(parent, isNormalization);
	}

	@Override
	protected void addWidgets() {
		validationRulePanels = new ArrayList<EPGValidationRule>();
		if (EPGValidationRule.getCachedActions() == null) {
			List<EPGUIAction> cachedActions = new ArrayList<EPGUIAction>();
			for (UiRuleErrorLevelEnum ruleActions : UiRuleErrorLevelEnum.values()) {
				cachedActions.add(new EPGUIAction(ruleActions.toString()));
			}
			
			EPGValidationRule.setCachedActions(cachedActions);
		}
		createRuleUI();
	}

	/**
	 * 
	 */
	private void createRuleUI() {
		EPGValidationRule ruleWidget;
		if (parent.ruleRecord == null) {
			createEmptyRule();
		} else {
			for (UiValidationRule rule : ((UiValidationGroup) parent.ruleRecord).getRules()) {
				ruleWidget = new EPGValidationRule(UiCriteriaMode.EPISODE, rule);
				ruleWidget.addDeleteHandler(getRuleDeleteHandler());
				validationRulePanels.add(ruleWidget);
				mainContainer.add(ruleWidget);
			}
		}
		
		addCreateButton();
	}

	/**
	 * 
	 */
	private void createEmptyRule() {
		EPGValidationRule ruleWidget = new EPGValidationRule(UiCriteriaMode.EPISODE);
		ruleWidget.addDeleteHandler(getRuleDeleteHandler());
		validationRulePanels.add(ruleWidget);
		mainContainer.add(ruleWidget);
	}

	/**
	 * 
	 */
	private void addCreateButton() {
		//create button
		if((ClientAuthorizationManager.isAuthorized(Permissions.EPG_CREATE) && parent.ruleRecord == null)
				|| ClientAuthorizationManager.isAuthorized(Permissions.EPG_MODIFY)) {
			final ButtonWidget createButton = new ButtonWidget(constants.buttonLabelCreate());
			createButton.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
			createButton.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					handleCreate(createButton);
				}});
			mainContainer.add(createButton);
		}
	}
	
	private void handleCreate(ButtonWidget createButton) {
		mainContainer.remove(createButton);
		createEmptyRule();
		addCreateButton();
	}

	private RuleDeleteHandler getRuleDeleteHandler() {
		return new RuleDeleteHandler() {
			@Override
			public void ruleDeleted(RuleDeleteEvent event) {
				validationRulePanels.remove(event.getRule());
				mainContainer.remove((Widget) event.getRule());
			}
		};
	}

	public List<UiValidationRule> getRules() {
		// TODO Auto-generated method stub
		List<UiValidationRule> rules = new ArrayList<UiValidationRule>();
		for (EPGValidationRule rulePanel : validationRulePanels) {
			rules.add((UiValidationRule) rulePanel.getRule());
		}
		return rules;
	}

	@Override
	protected boolean validate() {
		// TODO Auto-generated method stub
		boolean valid = true;
		for (EPGValidationRule rulePanel : validationRulePanels) {
			if (!rulePanel.validate()) {
				valid = false;
			}
		}
		if (!valid) {
			parent.setErrorMessage(messages.ruleGroupValidationCriteriaFix());
		}
		return valid;
	}
}
