/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.rules;

import static com.ericsson.cms.epgmgmt.client.model.UIConstants.EPG_MANAGER;
import static com.ericsson.cms.epgmgmt.client.model.UIConstants.EPG_VALIDATION_RULES;
import static com.ericsson.cms.epgmgmt.client.model.UIConstants.RULE_ENGINE;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.model.UIProvider;
import com.ericsson.cms.epgmgmt.client.model.UiValidationGroup;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;


/**
 * @author amit.r.seth
 *
 */
public class ValidationDetailsView extends AbstractRulesDetailView implements DetailView<Long, UiValidationGroup> {

    private static final String EPG_MANAGER_EPG_VALIDATION_RULES = EPG_MANAGER + "." + RULE_ENGINE + "." + EPG_VALIDATION_RULES;

    private UiValidationGroup validationGroupRecord;

    private ProvidersListContainer providers;
    private ValidationCriteriaContainer validationCriteria;
    private RulesPropertiesContainer properties;

    public ValidationDetailsView(Long recordId) {
        super("EPG Validation Rule Set", recordId);
    }

    /* (non-Javadoc)
     * @see com.ericsson.cms.epgmgmt.client.rules.AbstractRulesDetailView#addTabPanels()
     */
    @Override
    protected void addTabPanels() {
        providers = new ProvidersListContainer(this, false);
        tabContainer.add(providers, "EPG Providers");
        tabs.add(providers);
        WhenToRunContainer whenToRun = new WhenToRunContainer(this, false);
        tabContainer.add(whenToRun, "When to run");
        tabs.add(whenToRun);
        ProgramFilterContainer programFilter = new ProgramFilterContainer(this, false);
        tabContainer.add(programFilter, "Program Filter");
        tabs.add(programFilter);
        validationCriteria = new ValidationCriteriaContainer(this, false);
        tabContainer.add(validationCriteria, "Validation Criteria");
        tabs.add(validationCriteria);
        properties = new RulesPropertiesContainer(this, false);
        tabContainer.add(properties, "Properties");
        tabs.add(properties);
    }

    @Override
    protected void handleCancel() {
        // TODO: Handle cancel. Go back to list screen???
        History.newItem(EPG_MANAGER_EPG_VALIDATION_RULES);
    }

    @Override
    public void release() {
        // TODO Auto-generated method stub

    }

    @Override
    public void revert() {
        // TODO Auto-generated method stub

    }

    @Override
    public void commit() {
        // TODO Auto-generated method stub

    }

    @Override
    public UiValidationGroup getRecord() {
        return validationGroupRecord;
    }

    @Override
    public void saveFailed(Throwable throwable) {
        // TODO Auto-generated method stub

    }

    @Override
    public Widget getWidget() {
        return this;
    }

    @Override
    protected void loadRecord(Long ruleId) {
        busyIndicator.center();
        rpcService.getValidationGroup(ruleId, new AsyncCallback<UiValidationGroup>() {

            @Override
            public void onFailure(Throwable caught) {
                // TODO Auto-generated method stub
                busyIndicator.hide();
                setErrorMessage("Could not get the validation group record. " + caught.getLocalizedMessage());
            }

            @Override
            public void onSuccess(UiValidationGroup result) {
                // TODO Auto-generated method stub
                validationGroupRecord = result;
                ruleRecord = validationGroupRecord;
                addTabPanels();

                tabContainer.selectTab(0);

                busyIndicator.hide();
            }
        });
    }

    @Override
    protected void handleSave() {
        // TODO Auto-generated method stub
        if (validationGroupRecord == null) {
            validationGroupRecord = new UiValidationGroup();
        }
        // Get selected Providers
        if (providers.isGlobalSelected()) {
            validationGroupRecord.setGlobal(true);
            validationGroupRecord.setProviders(null);
        } else {
            validationGroupRecord.setGlobal(false);
            List<UIProvider> providersList = new ArrayList<UIProvider>();
            for (Long providerId : providers.getSelectedProviders()) {
                UIProvider p = new UIProvider();
                p.setId(providerId);
                providersList.add(p);
            }
            validationGroupRecord.setProviders(providersList);
        }
        // Get the Validation Rules to be associated
        validationGroupRecord.setRules(validationCriteria.getRules());
        // Get the properties
        validationGroupRecord.setName(properties.getRuleGroupName());
        validationGroupRecord.setEnabled(properties.isEnabled());
        rpcService.saveValidationGroup(validationGroupRecord, new AsyncCallback<Void>() {

            @Override
            public void onFailure(Throwable caught) {
                String validationMessage = constants.validationRuleSetSaveFailure();
                if (caught instanceof ValidationException ) {
                    ValidationException ve = (ValidationException) caught;
                    for (String message : ve.getValidationMessages()) {
                        validationMessage += "<br>" + message;
                    }
                } else {
                    validationMessage += "<br>" + caught.getLocalizedMessage();
                }
                setErrorHTML(validationMessage);
            }

            @Override
            public void onSuccess(Void result) {
                setInfoMessage(constants.validationRuleSetSaveSuccess());
                Timer redirectTimer = new Timer() {
                    @Override
                    public void run() {
                        History.newItem(EPG_MANAGER_EPG_VALIDATION_RULES);
                    };
                };
                redirectTimer.schedule(5000);
            }
        });
    }

    @Override
    protected boolean validate() {
        // TODO Auto-generated method stub
        if (!properties.validate()) {
            tabContainer.selectTab(4);
            return false;
        }
        if (!validationCriteria.validate()) {
            tabContainer.selectTab(3);
            return false;
        }
        return true;
    }
}
