package com.ericsson.cms.epgmgmt.client.rules;



import java.util.ArrayList;

import java.util.List;



import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;

import com.ericsson.cms.epgmgmt.client.model.UiValidationGroup;

import com.ericsson.cms.epgmgmt.client.rpc.IRulesService;

import com.ericsson.cms.epgmgmt.client.rpc.IRulesServiceAsync;

import com.google.gwt.core.client.GWT;

import com.google.gwt.i18n.client.DateTimeFormat;

import com.google.gwt.user.client.rpc.AsyncCallback;

import com.google.gwt.user.client.ui.Image;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;



/**

 * Data provider for the rules.

 * 

 * @author amit.r.seth

 * 

 */

public class ValidationRulesDataProvider implements DataProvider<Long, UiValidationGroup> {



    // columns for this table

    private final List<Column<?, UiValidationGroup>> columns;

    private final ColumnBase<String, UiValidationGroup> idColumn;

    private final ColumnBase<Image, UiValidationGroup> enabledColumn;

    private final ColumnBase<String, UiValidationGroup> nameColumn;

    private final ColumnBase<String, UiValidationGroup> updateDateColumn;



    private final EPGComponentConstants constants = (EPGComponentConstants) GWT

            .create(EPGComponentConstants.class);



    private final IRulesServiceAsync rpcService = GWT.create(IRulesService.class);



    private SortFeatureImpl<Long, UiValidationGroup> parentSortFeature;



    // column names

    private static final String ID_COLUMN = "id";

    private static final String ENABLED_COLUMN = "enabled";

    private static final String NAME_COLUMN = "name";

    private static final String UPDATE_DATE_COLUMN = "updateDate";



    private IBusyNotifier busyNotifier;



    public ValidationRulesDataProvider(ValidationRulesTabPanel listsPanel) {



        columns = new ArrayList<Column<?, UiValidationGroup>>();



        idColumn = new ColumnBase<String, UiValidationGroup>(ID_COLUMN,

                constants.ruleIdColumn()) {

            @Override

            public View<String> getView(UiValidationGroup record) {

                LabelStringView lb = new LabelStringView(String.valueOf(record

                        .getKey()));

                return lb;

            }

        };

        idColumn.setCellStyle(TableConstants.STYLE_DATACELL_NUMERIC);

        columns.add(idColumn);



        enabledColumn = new ColumnBase<Image, UiValidationGroup>(ENABLED_COLUMN,

                constants.ruleEnabledColumn()) {

            @Override

            public View<Image> getView(UiValidationGroup record) {

                if (record.getEnabled() != null) {

                    ImageView lb;

                    if (record.getEnabled()) {

                        lb = new ImageView("cms_epgmgmt_ui/images/enabled.png");

                    } else {

                        lb = new ImageView("cms_epgmgmt_ui/images/disabled.png");

                    }

                    return lb;

                } else {

                    return new ImageView("cms_epgmgmt_ui/images/disabled.png");

                }

            }

        };

        enabledColumn.setCellStyle(TableConstants.STYLE_DATACELL_ICON);

        columns.add(enabledColumn);



        nameColumn = new ColumnBase<String, UiValidationGroup>(NAME_COLUMN,

                constants.ruleNameColumn()) {

            @Override

            public View<String> getView(UiValidationGroup record) {

                return new LabelStringView(String.valueOf(record.getName()));

            }

        };

        nameColumn.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);

        columns.add(nameColumn);



        updateDateColumn = new ColumnBase<String, UiValidationGroup>(UPDATE_DATE_COLUMN,

                constants.ruleUpdateDateColumn()) {

            @Override

            public View<String> getView(UiValidationGroup record) {

                DateTimeFormat dateFormatter = DateTimeFormat

                        .getFormat(constants.dateFormat());

                LabelStringView lb = new LabelStringView(

                        dateFormatter.format(record.getUpdateDate()));

                return lb;

            }

        };

        updateDateColumn.setCellStyle(TableConstants.STYLE_DATACELL_DATE);

        columns.add(updateDateColumn);



    }



    public ColumnBase<String, UiValidationGroup> getDefaultSortColumn() {

        return nameColumn;

    }



    public List<Column<?, UiValidationGroup>> getSortColumns() {

        return columns;

    }



    @Override

    public List<Column<?, UiValidationGroup>> getColumns() {

        return columns;

    }



    @Override

    public void getRecord(Long key, final AsyncCallback<UiValidationGroup> callback) {

        notifyBusyStart();

        rpcService.getValidationGroup(key, new AsyncCallback<UiValidationGroup>() {



            @Override

            public void onFailure(Throwable caught) {

                // TODO Auto-generated method stub

                callback.onFailure(caught);

                notifyBusyFinish();

            }



            @Override

            public void onSuccess(UiValidationGroup result) {

                // TODO Auto-generated method stub

                callback.onSuccess(result);

                notifyBusyFinish();

            }

        });

    }



    @Override

    public void getRecords(final AsyncCallback<List<UiValidationGroup>> callback) {

        notifyBusyStart();

        rpcService.getValidationGroups(getParentSortFeature().getSortColumnName(),

                getParentSortFeature().isAscending(),

                new AsyncCallback<List<UiValidationGroup>>() {



            @Override

            public void onSuccess(List<UiValidationGroup> result) {

                // TODO Auto-generated method stub

                callback.onSuccess(result);

                notifyBusyFinish();



            }



            @Override

            public void onFailure(Throwable caught) {

                // TODO Auto-generated method stub

                callback.onFailure(caught);

                notifyBusyFinish();



            }

        });

    }



    @Override

    public void initialize(AsyncCallback<Void> callback) {

        callback.onSuccess(null);

    }



    @Override

    public boolean isCheckboxEnabled() {

        return true;

    }



    @Override

    public boolean isRecordCountEnabled() {

        return false;

    }



    /**

     * @return the parentSortFeature

     */

    public SortFeatureImpl<Long, UiValidationGroup> getParentSortFeature() {

        return parentSortFeature;

    }



    /**

     * @param parentSortFeature

     *            the parentSortFeature to set

     */

    public void setParentSortFeature(

            SortFeatureImpl<Long, UiValidationGroup> parentSortFeature) {

        this.parentSortFeature = parentSortFeature;

    }



    public static interface IBusyNotifier {

        void startingToBeBusy();



        void doneBeingBusy();

    }



    public void setBusyNotifier(IBusyNotifier busyNotifier) {

        this.busyNotifier = busyNotifier;

    }



    private void notifyBusyStart() {

        if (busyNotifier != null) {

            busyNotifier.startingToBeBusy();

        }

    }



    private void notifyBusyFinish() {

        if (busyNotifier != null) {

            busyNotifier.doneBeingBusy();

        }

    }

}

