/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.rules;

import java.util.List;

import com.ericsson.cms.epgmgmt.client.Permissions;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.UiLongKeySerializer;
import com.ericsson.cms.epgmgmt.client.model.UiValidationGroup;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AbstractDetailFeature;

/**
 * @author amit.r.seth
 *
 */
public class ValidationRulesDetailFeature extends AbstractDetailFeature<Long, UiValidationGroup> {

	private final EPGComponentConstants constants = (EPGComponentConstants) GWT
			.create(EPGComponentConstants.class);

	public ValidationRulesDetailFeature(ValidationRulesTabPanel rulesListViewPanel) {
        super(new UiLongKeySerializer());
	}

	@Override
	public DetailView<Long, UiValidationGroup> getView(
			UiValidationGroup record,
			DetailViewCallback<Long, UiValidationGroup> callback) {
		// TODO Auto-generated method stub
		return new DummyValidationDetailView();
	}

	@Override
	public boolean hasDetailLink(Column<?, UiValidationGroup> column) {
		return column.getDisplayName().equals(constants.ruleIdColumn())
                && ClientAuthorizationManager.isAuthorized(Permissions.EPG_VIEW);
	}

	@Override
	public void getNew(AsyncCallback<UiValidationGroup> callback) {
		// TODO Auto-generated method stub
		callback.onSuccess(new UiValidationGroup());
	}

	/**
	 * This is useless while these buttons are not displayed and are handled separately
	 */
	@Override
	public void save(UiValidationGroup record, AsyncCallback<Void> callback) {
	}

	/**
	 * This is useless while these buttons are not displayed and are handled separately
	 */
	@Override
	public void delete(List<UiValidationGroup> records,
			AsyncCallback<Void> callback) {
	}

	/**
	 * This is useless while the buttons need to be displayed at the bottom of the screen...
	 * Should always return false.
	 */
	@Override
	public boolean showCreateButton() {
		return false;
	}

	/**
	 * This is useless while the buttons need to be displayed at the bottom of the screen...
	 * Should always return false.
	 */
	@Override
	public boolean showDeleteButton() {
		return false;
	}

}
